/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.XnioByteBufferPool;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowContainerProvider;
import io.undertow.websockets.jsr.WebSocketReconnectHandler;
import jakarta.websocket.server.ServerEndpointConfig;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.xnio.Pool;
import org.xnio.XnioWorker;

public class WebSocketDeploymentInfo
implements Cloneable {
    public static final String ATTRIBUTE_NAME = "io.undertow.websockets.jsr.WebSocketDeploymentInfo";
    private Supplier<XnioWorker> worker = new Supplier<XnioWorker>(){
        volatile XnioWorker worker;

        @Override
        public XnioWorker get() {
            if (this.worker != null) {
                return this.worker;
            }
            this.worker = UndertowContainerProvider.getDefaultContainer().getXnioWorker();
            return this.worker;
        }
    };
    private ByteBufferPool buffers;
    private boolean dispatchToWorkerThread = false;
    private final List<Class<?>> annotatedEndpoints = new ArrayList();
    private final List<ServerEndpointConfig> programaticEndpoints = new ArrayList<ServerEndpointConfig>();
    private final List<ContainerReadyListener> containerReadyListeners = new ArrayList<ContainerReadyListener>();
    private final List<ExtensionHandshake> extensions = new ArrayList<ExtensionHandshake>();
    private String clientBindAddress = null;
    private WebSocketReconnectHandler reconnectHandler;

    public Supplier<XnioWorker> getWorker() {
        return this.worker;
    }

    public WebSocketDeploymentInfo setWorker(Supplier<XnioWorker> worker) {
        this.worker = worker;
        return this;
    }

    public WebSocketDeploymentInfo setWorker(final XnioWorker worker) {
        this.worker = new Supplier<XnioWorker>(){

            @Override
            public XnioWorker get() {
                return worker;
            }
        };
        return this;
    }

    public ByteBufferPool getBuffers() {
        return this.buffers;
    }

    @Deprecated
    public WebSocketDeploymentInfo setBuffers(Pool<ByteBuffer> buffers) {
        return this.setBuffers(new XnioByteBufferPool(buffers));
    }

    public WebSocketDeploymentInfo setBuffers(ByteBufferPool buffers) {
        this.buffers = buffers;
        return this;
    }

    public WebSocketDeploymentInfo addEndpoint(Class<?> annotated) {
        this.annotatedEndpoints.add(annotated);
        return this;
    }

    public WebSocketDeploymentInfo addAnnotatedEndpoints(Collection<Class<?>> annotatedEndpoints) {
        this.annotatedEndpoints.addAll(annotatedEndpoints);
        return this;
    }

    public WebSocketDeploymentInfo addEndpoint(ServerEndpointConfig endpoint) {
        this.programaticEndpoints.add(endpoint);
        return this;
    }

    public WebSocketDeploymentInfo addProgramaticEndpoints(Collection<ServerEndpointConfig> programaticEndpoints) {
        this.programaticEndpoints.addAll(programaticEndpoints);
        return this;
    }

    public List<Class<?>> getAnnotatedEndpoints() {
        return this.annotatedEndpoints;
    }

    public List<ServerEndpointConfig> getProgramaticEndpoints() {
        return this.programaticEndpoints;
    }

    void containerReady(ServerWebSocketContainer container) {
        for (ContainerReadyListener listener : this.containerReadyListeners) {
            listener.ready(container);
        }
    }

    public WebSocketDeploymentInfo addListener(ContainerReadyListener listener) {
        this.containerReadyListeners.add(listener);
        return this;
    }

    public WebSocketDeploymentInfo addListeners(Collection<ContainerReadyListener> listeners) {
        this.containerReadyListeners.addAll(listeners);
        return this;
    }

    public List<ContainerReadyListener> getListeners() {
        return this.containerReadyListeners;
    }

    public boolean isDispatchToWorkerThread() {
        return this.dispatchToWorkerThread;
    }

    public WebSocketDeploymentInfo setDispatchToWorkerThread(boolean dispatchToWorkerThread) {
        this.dispatchToWorkerThread = dispatchToWorkerThread;
        return this;
    }

    public WebSocketDeploymentInfo addExtension(ExtensionHandshake extension) {
        if (null != extension) {
            this.extensions.add(extension);
        }
        return this;
    }

    public WebSocketDeploymentInfo addExtensions(Collection<ExtensionHandshake> extensions) {
        this.extensions.addAll(extensions);
        return this;
    }

    public List<ExtensionHandshake> getExtensions() {
        return this.extensions;
    }

    public String getClientBindAddress() {
        return this.clientBindAddress;
    }

    public WebSocketDeploymentInfo setClientBindAddress(String clientBindAddress) {
        this.clientBindAddress = clientBindAddress;
        return this;
    }

    public WebSocketReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    public WebSocketDeploymentInfo setReconnectHandler(WebSocketReconnectHandler reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
        return this;
    }

    public WebSocketDeploymentInfo clone() {
        return new WebSocketDeploymentInfo().setWorker(this.worker).setBuffers(this.buffers).setDispatchToWorkerThread(this.dispatchToWorkerThread).addAnnotatedEndpoints(this.annotatedEndpoints).addProgramaticEndpoints(this.programaticEndpoints).addListeners(this.containerReadyListeners).addExtensions(this.extensions).setClientBindAddress(this.clientBindAddress).setReconnectHandler(this.reconnectHandler);
    }

    public static interface ContainerReadyListener {
        public void ready(ServerWebSocketContainer var1);
    }
}

