/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.ref;

import org.wildfly.common.ref.Reference;

public class StrongReference<T, A>
implements Reference<T, A> {
    private volatile T referent;
    private final A attachment;

    public StrongReference(T referent, A attachment) {
        this.referent = referent;
        this.attachment = attachment;
    }

    public StrongReference(T referent) {
        this(referent, null);
    }

    @Override
    public T get() {
        return this.referent;
    }

    @Override
    public void clear() {
        this.referent = null;
    }

    @Override
    public A getAttachment() {
        return this.attachment;
    }

    @Override
    public Reference.Type getType() {
        return Reference.Type.STRONG;
    }

    public String toString() {
        return "strong reference to " + String.valueOf(this.get());
    }
}

