/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.client.HttpClient;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="UNDERTOW")
public interface UndertowLogger
extends BasicLogger {
    public static final UndertowLogger ROOT_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName());
    public static final UndertowLogger CLIENT_LOGGER = Logger.getMessageLogger(UndertowLogger.class, HttpClient.class.getPackage().getName());
    public static final UndertowLogger REQUEST_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".request");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5001, value="An exception occurred processing the request")
    public void exceptionProcessingRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5002, value="Exception reading file %s: %s")
    public void exceptionReadingFile(File var1, IOException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5003, value="IOException reading from channel")
    public void ioExceptionReadingFromChannel(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5004, value="Connection terminated parsing multipart data")
    public void connectionTerminatedReadingMultiPartData();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5005, value="Cannot remove uploaded file %s")
    public void cannotRemoveUploadedFile(File var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5006, value="Connection from %s terminated as request header was larger than %s")
    public void requestHeaderWasTooLarge(SocketAddress var1, int var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5007, value="Request was not fully consumed")
    public void requestWasNotFullyConsumed();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5008, value="An invalid token '%s' with value '%s' has been received.")
    public void invalidTokenReceived(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5009, value="A mandatory token %s is missing from the request.")
    public void missingAuthorizationToken(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5010, value="Verification of authentication tokens for user '%s' has failed using mechanism '%s'.")
    public void authenticationFailed(String var1, String var2);
}

