/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.UndertowLogger;
import io.undertow.client.HttpClientCallback;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channel;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

class HttpClientUtils {
    static final ChannelListener<StreamSinkChannel> FLUSHING_CLOSE_LISTENER = new ChannelListener<StreamSinkChannel>(){

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            try {
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            channel.suspendWrites();
                            channel.getWriteSetter().set(null);
                            IoUtils.safeClose((Closeable)channel);
                        }
                    }, new ChannelExceptionHandler<Channel>(){

                        @Override
                        public void handleException(Channel channel, IOException exception) {
                            UndertowLogger.CLIENT_LOGGER.debug("Exception ending request", exception);
                            IoUtils.safeClose((Closeable)channel);
                        }
                    }));
                    channel.resumeWrites();
                } else {
                    IoUtils.safeClose((Closeable)channel);
                }
            }
            catch (IOException e) {
                UndertowLogger.CLIENT_LOGGER.debug("Exception sending request", e);
                IoUtils.safeClose((Closeable)channel);
            }
        }
    };

    HttpClientUtils() {
    }

    static <T> void addCallback(IoFuture<T> result, final HttpClientCallback<T> callback) {
        result.addNotifier(new IoFuture.HandlingNotifier<T, Void>(){

            @Override
            public void handleFailed(IOException exception, Void attachment) {
                callback.failed(exception);
            }

            @Override
            public void handleDone(T data, Void attachment) {
                callback.completed(data);
            }
        }, null);
    }

    static final ChannelListener<StreamSinkChannel> flushingChannelCloseListener() {
        return FLUSHING_CLOSE_LISTENER;
    }
}

