/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;

public class AuthenticationConstraintHandler
implements HttpHandler {
    private final HttpHandler next;

    public AuthenticationConstraintHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        if (this.isAuthenticationRequired(exchange)) {
            SecurityContext context = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
            context.setAuthenticationRequired();
        }
        HttpHandlers.executeHandler(this.next, exchange);
    }

    protected boolean isAuthenticationRequired(HttpServerExchange exchange) {
        return true;
    }
}

