/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.util.List;

public class AuthenticationMechanismsHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private final List<AuthenticationMechanism> authenticationMechanisms;

    public AuthenticationMechanismsHandler(HttpHandler next, List<AuthenticationMechanism> authenticationMechanisms) {
        this.next = next;
        this.authenticationMechanisms = authenticationMechanisms;
    }

    public AuthenticationMechanismsHandler(List<AuthenticationMechanism> authenticationHandlers) {
        this.authenticationMechanisms = authenticationHandlers;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        SecurityContext sc = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        if (sc != null) {
            for (AuthenticationMechanism mechanism : this.authenticationMechanisms) {
                sc.addAuthenticationMechanism(mechanism);
            }
        }
        HttpHandlers.executeHandler(this.next, exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public AuthenticationMechanismsHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

