/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.AttachmentList;
import io.undertow.util.ConduitFactory;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.DateUtils;
import io.undertow.util.Headers;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.xnio.conduits.StreamSinkConduit;

public class CookieHandler
implements HttpHandler {
    public static final String DOMAIN = "$Domain";
    public static final String VERSION = "$Version";
    public static final String PATH = "$Path";
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    public CookieHandler(HttpHandler next) {
        this.next = next;
    }

    public CookieHandler() {
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        Map<String, Cookie> cookies = CookieHandler.parseCookies(exchange);
        exchange.putAttachment(Cookie.REQUEST_COOKIES, new CopyOnWriteMap<String, Cookie>(cookies));
        exchange.putAttachment(Cookie.RESPONSE_COOKIES, new AttachmentList<Cookie>(Cookie.class));
        exchange.addResponseWrapper(CookieConduitWrapper.INSTANCE);
        HttpHandlers.executeHandler(this.next, exchange);
    }

    private static Map<String, Cookie> parseCookies(HttpServerExchange exchange) {
        List<String> cookies = exchange.getRequestHeaders().get(Headers.COOKIE);
        if (cookies == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> parsedCookies = new HashMap<String, Cookie>();
        for (String cookie : cookies) {
            CookieHandler.parseCookie(cookie, parsedCookies);
        }
        return parsedCookies;
    }

    private static void parseCookie(String cookie, Map<String, Cookie> parsedCookies) {
        int state = 0;
        String name = null;
        int start = 0;
        HashMap<String, String> cookies = new HashMap<String, String>();
        HashMap<String, String> additional = new HashMap<String, String>();
        block6: for (int i = 0; i < cookie.length(); ++i) {
            char c = cookie.charAt(i);
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t' || c == ';') {
                        start = i + 1;
                        continue block6;
                    }
                    state = 1;
                }
                case 1: {
                    if (c != '=') continue block6;
                    name = cookie.substring(start, i);
                    start = i + 1;
                    state = 2;
                    continue block6;
                }
                case 2: {
                    String value;
                    if (c == ';') {
                        value = cookie.substring(start, i);
                        if (name.startsWith("$")) {
                            additional.put(name, value);
                        } else {
                            cookies.put(name, value);
                        }
                        state = 0;
                        start = i + 1;
                        continue block6;
                    }
                    if (c != '\"') continue block6;
                    state = 3;
                    start = i + 1;
                    continue block6;
                }
                case 3: {
                    if (c != '\"') continue block6;
                    String value = cookie.substring(start, i);
                    if (name.startsWith("$")) {
                        additional.put(name, value);
                    } else {
                        cookies.put(name, value);
                    }
                    state = 0;
                    start = i + 1;
                }
            }
        }
        if (state == 2) {
            String value = cookie.substring(start);
            if (name.startsWith("$")) {
                additional.put(name, value);
            } else {
                cookies.put(name, value);
            }
        }
        for (Map.Entry entry : cookies.entrySet()) {
            CookieImpl c = new CookieImpl((String)entry.getKey(), (String)entry.getValue());
            if (additional.containsKey(DOMAIN)) {
                c.setDomain((String)additional.get(DOMAIN));
            }
            if (additional.containsKey(VERSION)) {
                c.setVersion(Integer.parseInt((String)additional.get(VERSION)));
            }
            if (additional.containsKey(PATH)) {
                c.setPath((String)additional.get(PATH));
            }
            parsedCookies.put(c.getName(), c);
        }
    }

    private static String getCookieString(Cookie cookie) {
        switch (cookie.getVersion()) {
            case 0: {
                return CookieHandler.addVersion0ResponseCookieToExchange(cookie);
            }
        }
        return CookieHandler.addVersion1ResponseCookieToExchange(cookie);
    }

    private static String addVersion0ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        header.append(cookie.getValue());
        if (cookie.getPath() != null) {
            header.append("; path=");
            header.append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; domain=");
            header.append(cookie.getDomain());
        }
        if (cookie.isDiscard()) {
            header.append("; Discard");
        }
        if (cookie.isSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toOldCookieDateString(cookie.getExpires()));
        } else if (cookie.getMaxAge() != null) {
            if (cookie.getMaxAge() == 0) {
                Date expires = new Date();
                expires.setTime(0L);
                header.append("; Expires=");
                header.append(DateUtils.toOldCookieDateString(expires));
            } else if (cookie.getMaxAge() > 0) {
                Date expires = new Date();
                expires.setTime(expires.getTime() + (long)cookie.getMaxAge().intValue());
                header.append("; Expires=");
                header.append(DateUtils.toOldCookieDateString(expires));
            }
        }
        return header.toString();
    }

    private static String addVersion1ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        header.append(cookie.getValue());
        header.append("; Version=1");
        if (cookie.getPath() != null) {
            header.append("; Path=");
            header.append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; Domain=");
            header.append(cookie.getDomain());
        }
        if (cookie.isDiscard()) {
            header.append("; Discard");
        }
        if (cookie.isSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getMaxAge() != null && cookie.getMaxAge() >= 0) {
            header.append("; Max-Age=");
            header.append(cookie.getMaxAge());
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toDateString(cookie.getExpires()));
        }
        return header.toString();
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public CookieHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    private static class CookieConduitWrapper
    implements ConduitWrapper<StreamSinkConduit> {
        public static final CookieConduitWrapper INSTANCE = new CookieConduitWrapper();

        private CookieConduitWrapper() {
        }

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            List<Cookie> cookies = exchange.getAttachmentList(Cookie.RESPONSE_COOKIES);
            if (!cookies.isEmpty()) {
                ListIterator<Cookie> it = cookies.listIterator();
                while (it.hasNext()) {
                    StringBuilder builder = new StringBuilder();
                    Cookie cookie = it.next();
                    builder.append(CookieHandler.getCookieString(cookie));
                    exchange.getResponseHeaders().add(Headers.SET_COOKIE, builder.toString());
                }
            }
            return factory.create();
        }
    }
}

