/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.util.ConcreteIoFuture;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public class FormEncodedDataHandler
implements HttpHandler {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private String defaultEncoding = "UTF-8";

    public FormEncodedDataHandler(HttpHandler next) {
        this.next = next;
    }

    public FormEncodedDataHandler() {
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        String mimeType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (mimeType != null && mimeType.startsWith(APPLICATION_X_WWW_FORM_URLENCODED)) {
            String cs;
            String charset = this.defaultEncoding;
            String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (contentType != null && (cs = Headers.extractTokenFromHeader(contentType, "charset")) != null) {
                charset = cs;
            }
            exchange.putAttachment(FormDataParser.ATTACHMENT_KEY, new FormEncodedDataParser(charset, exchange));
        }
        HttpHandlers.executeHandler(this.next, exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public FormEncodedDataHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public FormEncodedDataHandler setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    private static final class FormEncodedDataParser
    implements ChannelListener<StreamSourceChannel>,
    FormDataParser {
        private final HttpServerExchange exchange;
        private final FormData data = new FormData();
        private final StringBuilder builder = new StringBuilder();
        private String name = null;
        private volatile ConcreteIoFuture<FormData> ioFuture;
        private String charset;
        private int state = 0;

        private FormEncodedDataParser(String charset, HttpServerExchange exchange) {
            this.exchange = exchange;
            this.charset = charset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(StreamSourceChannel channel) {
            int c = 0;
            Pooled<ByteBuffer> pooled = this.exchange.getConnection().getBufferPool().allocate();
            try {
                ByteBuffer buffer = pooled.getResource();
                do {
                    if ((c = channel.read(buffer)) <= 0) continue;
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        byte n = buffer.get();
                        switch (this.state) {
                            case 0: {
                                if (n == 61) {
                                    this.name = this.builder.toString();
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                if (n == 37 || n == 43) {
                                    this.state = 1;
                                    this.builder.append((char)n);
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 1: {
                                if (n == 61) {
                                    this.name = URLDecoder.decode(this.builder.toString(), this.charset);
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 2: {
                                if (n == 38) {
                                    this.data.add(this.name, this.builder.toString());
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                if (n == 37 || n == 43) {
                                    this.state = 3;
                                    this.builder.append((char)n);
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 3: {
                                if (n == 38) {
                                    this.data.add(this.name, URLDecoder.decode(this.builder.toString(), this.charset));
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                this.builder.append((char)n);
                            }
                        }
                    }
                } while (c > 0);
                if (c == -1) {
                    if (this.state == 2) {
                        this.data.add(this.name, this.builder.toString());
                    } else if (this.state == 3) {
                        this.data.add(this.name, URLDecoder.decode(this.builder.toString(), this.charset));
                    }
                    this.state = 4;
                    this.ioFuture.setResult(this.data);
                }
            }
            catch (IOException e) {
                this.ioFuture.setException(e);
                IoUtils.safeClose((Closeable)channel);
                UndertowLogger.REQUEST_LOGGER.ioExceptionReadingFromChannel(e);
                this.exchange.endExchange();
            }
            finally {
                pooled.free();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IoFuture<FormData> parse() {
            if (this.ioFuture == null) {
                ConcreteIoFuture created = null;
                FormEncodedDataParser formEncodedDataParser = this;
                synchronized (formEncodedDataParser) {
                    if (this.ioFuture == null) {
                        created = new ConcreteIoFuture();
                        this.ioFuture = created;
                    }
                }
                if (created != null) {
                    StreamSourceChannel channel = this.exchange.getRequestChannel();
                    if (channel == null) {
                        created.setException(new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided()));
                    } else {
                        this.handleEvent(channel);
                        if (this.state != 4) {
                            channel.getReadSetter().set(this);
                            channel.resumeReads();
                        }
                    }
                }
            }
            return this.ioFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FormData parseBlocking() throws IOException {
            if (this.ioFuture == null) {
                ConcreteIoFuture created = null;
                FormEncodedDataParser formEncodedDataParser = this;
                synchronized (formEncodedDataParser) {
                    if (this.ioFuture == null) {
                        created = new ConcreteIoFuture();
                        this.ioFuture = created;
                    }
                }
                if (created != null) {
                    StreamSourceChannel channel = this.exchange.getRequestChannel();
                    if (channel == null) {
                        created.setException(new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided()));
                    } else {
                        while (this.state != 4) {
                            this.handleEvent(channel);
                            if (this.state == 4) continue;
                            channel.awaitReadable();
                        }
                    }
                }
            }
            return (FormData)this.ioFuture.get();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.charset = encoding;
        }
    }
}

