/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.blocking.BlockingHttpHandler;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterHandler
implements BlockingHttpHandler {
    private final Map<DispatcherType, List<ManagedFilter>> filters;
    private final Map<DispatcherType, Boolean> asyncSupported;
    private final BlockingHttpHandler next;

    public FilterHandler(Map<DispatcherType, List<ManagedFilter>> filters, BlockingHttpHandler next) {
        this.next = next;
        this.filters = new HashMap<DispatcherType, List<ManagedFilter>>(filters);
        HashMap<DispatcherType, Boolean> asyncSupported = new HashMap<DispatcherType, Boolean>();
        for (Map.Entry<DispatcherType, List<ManagedFilter>> entry : filters.entrySet()) {
            boolean supported = true;
            for (ManagedFilter i : entry.getValue()) {
                if (i.getFilterInfo().isAsyncSupported()) continue;
                supported = false;
                break;
            }
            asyncSupported.put(entry.getKey(), supported);
        }
        this.asyncSupported = asyncSupported;
    }

    @Override
    public void handleBlockingRequest(HttpServerExchange exchange) throws Exception {
        List<ManagedFilter> filters;
        ServletRequest request = exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY);
        ServletResponse response = exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
        DispatcherType dispatcher = exchange.getAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY);
        Boolean supported = this.asyncSupported.get((Object)dispatcher);
        if (supported != null && !supported.booleanValue()) {
            exchange.putAttachment(AsyncContextImpl.ASYNC_SUPPORTED, false);
        }
        if ((filters = this.filters.get((Object)dispatcher)) == null) {
            this.next.handleBlockingRequest(exchange);
        } else {
            FilterChainImpl filterChain = new FilterChainImpl(exchange, filters, this.next);
            filterChain.doFilter(request, response);
        }
    }

    private static class FilterChainImpl
    implements FilterChain {
        int location = 0;
        final HttpServerExchange exchange;
        final List<ManagedFilter> filters;
        final BlockingHttpHandler next;

        private FilterChainImpl(HttpServerExchange exchange, List<ManagedFilter> filters, BlockingHttpHandler next) {
            this.exchange = exchange;
            this.filters = filters;
            this.next = next;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            ServletRequest oldReq = this.exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY);
            ServletResponse oldResp = this.exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
            try {
                this.exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, request);
                this.exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, response);
                int index = this.location++;
                if (index >= this.filters.size()) {
                    this.next.handleBlockingRequest(this.exchange);
                } else {
                    this.filters.get(index).doFilter(request, response, this);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                --this.location;
                this.exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, oldReq);
                this.exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, oldResp);
            }
        }
    }
}

