/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.blocking.BlockingHttpHandler;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.ServletBlockingHttpExchange;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.WorkerDispatcher;
import java.io.Closeable;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.xnio.IoUtils;

public class ServletInitialHandler
implements BlockingHttpHandler,
HttpHandler {
    private final BlockingHttpHandler next;
    private final CompositeThreadSetupAction setupAction;
    private final ServletContextImpl servletContext;
    private volatile BlockingHttpHandler handler;
    private final ManagedServlet managedServlet;

    public ServletInitialHandler(BlockingHttpHandler next, HttpHandler asyncPath, CompositeThreadSetupAction setupAction, ServletContextImpl servletContext, ManagedServlet managedServlet) {
        this.next = next;
        this.setupAction = setupAction;
        this.servletContext = servletContext;
        this.managedServlet = managedServlet;
    }

    public ServletInitialHandler(BlockingHttpHandler next, CompositeThreadSetupAction setupAction, ServletContextImpl servletContext, ManagedServlet managedServlet) {
        this(next, null, setupAction, servletContext, managedServlet);
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    exchange.startBlocking(new ServletBlockingHttpExchange(exchange));
                    ServletInitialHandler handler = ServletInitialHandler.this;
                    handler.handleBlockingRequest(exchange);
                }
                catch (Throwable t) {
                    UndertowLogger.REQUEST_LOGGER.errorf(t, "Internal error handling servlet request %s", (Object)exchange.getRequestURI());
                    exchange.endExchange();
                }
            }
        };
        WorkerDispatcher.dispatch(exchange, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBlockingRequest(HttpServerExchange exchange) throws Exception {
        ServletInfo old = exchange.getAttachment(ServletAttachments.CURRENT_SERVLET);
        try {
            boolean first;
            exchange.putAttachment(ServletAttachments.CURRENT_SERVLET, this.managedServlet.getServletInfo());
            DispatcherType dispatcher = exchange.getAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY);
            boolean bl = first = dispatcher == null || dispatcher == DispatcherType.ASYNC;
            if (first) {
                this.handleFirstRequest(exchange, dispatcher);
            } else {
                this.handleDispatchedRequest(exchange);
            }
        }
        finally {
            exchange.putAttachment(ServletAttachments.CURRENT_SERVLET, old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDispatchedRequest(HttpServerExchange exchange) throws Exception {
        ThreadSetupAction.Handle handle = this.setupAction.setup(exchange);
        try {
            this.next.handleBlockingRequest(exchange);
        }
        finally {
            handle.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFirstRequest(HttpServerExchange exchange, DispatcherType dispatcherType) throws Exception {
        ThreadSetupAction.Handle handle = this.setupAction.setup(exchange);
        try {
            String location;
            if (dispatcherType == null) {
                HttpServletResponseImpl response = new HttpServletResponseImpl(exchange, this.servletContext);
                HttpServletRequestImpl request = new HttpServletRequestImpl(exchange, this.servletContext);
                exchange.putAttachment(HttpServletRequestImpl.DISPATCHER_TYPE_ATTACHMENT_KEY, DispatcherType.REQUEST);
                exchange.putAttachment(HttpServletRequestImpl.ATTACHMENT_KEY, request);
                exchange.putAttachment(HttpServletResponseImpl.ATTACHMENT_KEY, response);
            }
            this.next.handleBlockingRequest(exchange);
            if (!exchange.isResponseStarted() && exchange.getResponseCode() >= 400 && (location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(exchange.getResponseCode())) != null) {
                RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                dispatcher.error(exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY), exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY), this.managedServlet.getServletInfo().getName());
            }
        }
        catch (Throwable t) {
            HttpServletRequestImpl.getRequestImpl(exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY)).onAsyncError(t);
            if (!exchange.isResponseStarted()) {
                exchange.setResponseCode(500);
                exchange.getResponseHeaders().clear();
                String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t);
                if (location == null && t instanceof ServletException) {
                    location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t.getCause());
                }
                if (location != null) {
                    RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                    try {
                        dispatcher.error(exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY), exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY), this.managedServlet.getServletInfo().getName(), t);
                    }
                    catch (Exception e) {
                        UndertowLogger.REQUEST_LOGGER.errorf((Throwable)e, "Exception while generating error page %s", (Object)location);
                    }
                } else {
                    UndertowLogger.REQUEST_LOGGER.errorf(t, "Servlet request failed %s", (Object)exchange);
                }
            }
        }
        finally {
            handle.tearDown();
        }
        HttpServletRequestImpl request = HttpServletRequestImpl.getRequestImpl(exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY));
        HttpServletResponseImpl response = HttpServletResponseImpl.getResponseImpl(exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY));
        if (!request.isAsyncStarted()) {
            response.responseDone();
            FormDataParser parser = exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            IoUtils.safeClose((Closeable)parser);
        } else {
            request.asyncInitialRequestDone();
        }
    }

    public BlockingHttpHandler getHandler() {
        return this.handler;
    }

    public ServletInitialHandler setRootHandler(BlockingHttpHandler rootHandler) {
        HttpHandlers.handlerNotNull(rootHandler);
        this.handler = rootHandler;
        return this;
    }

    public BlockingHttpHandler getNext() {
        return this.next;
    }

    public ManagedServlet getManagedServlet() {
        return this.managedServlet;
    }
}

