/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class Conduits {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(StreamSourceConduit source, long count, ByteBuffer throughBuffer, WritableByteChannel sink) throws IOException {
        long total = 0L;
        throughBuffer.clear();
        while (total < count) {
            long res;
            if (count - total < (long)throughBuffer.remaining()) {
                throughBuffer.limit((int)(count - total));
            }
            try {
                res = source.read(throughBuffer);
                if (res <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink.write(throughBuffer);
            if (res == 0L) {
                return total;
            }
            if ((total += res) >= count) continue;
            throughBuffer.compact();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(ReadableByteChannel source, long count, ByteBuffer throughBuffer, StreamSinkConduit sink) throws IOException {
        long total = 0L;
        throughBuffer.clear();
        while (total < count) {
            long res;
            if (count - total < (long)throughBuffer.remaining()) {
                throughBuffer.limit((int)(count - total));
            }
            try {
                res = source.read(throughBuffer);
                if (res <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink.write(throughBuffer);
            if (res == 0L) {
                return total;
            }
            if ((total += res) >= count) continue;
            throughBuffer.compact();
        }
        return total;
    }
}

