/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.channels.ReadTimeoutStreamSourceChannel;
import io.undertow.channels.WriteTimeoutStreamSinkChannel;
import io.undertow.client.HttpClient;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientConnectionImpl;
import io.undertow.client.HttpClientRequest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Result;
import org.xnio.XnioWorker;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

class HttpClientImpl
extends HttpClient {
    private final OptionMap options;
    private final Pool<ByteBuffer> bufferPool;
    private final Set<HttpClientConnection> connections = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    HttpClientImpl(XnioWorker worker, OptionMap options) {
        super(worker);
        this.options = options;
        this.bufferPool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 4096, 81920);
    }

    @Override
    public IoFuture<HttpClientConnection> connect(SocketAddress destination, OptionMap optionMap) {
        final FutureResult<HttpClientConnection> result = new FutureResult<HttpClientConnection>();
        result.addCancelHandler(new Cancellable(){

            @Override
            public Cancellable cancel() {
                result.setCancelled();
                return this;
            }
        });
        ClientConnectionOpenListener openListener = new ClientConnectionOpenListener(result, optionMap);
        IoFuture<ConnectedStreamChannel> future = this.getWorker().connectStream(destination, openListener, optionMap);
        future.addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, IoFuture<HttpClientConnection>>(){

            @Override
            public void handleCancelled(IoFuture<HttpClientConnection> future) {
                future.cancel();
            }

            @Override
            public void handleFailed(IOException exception, IoFuture<HttpClientConnection> attachment) {
                result.setException(exception);
            }
        }, result.getIoFuture());
        return result.getIoFuture();
    }

    @Override
    public IoFuture<HttpClientRequest> sendRequest(final String method, final URI requestUri, OptionMap optionMap) {
        int destinationPort;
        String host = requestUri.getHost();
        InetSocketAddress destination = host != null ? new InetSocketAddress(host, (destinationPort = requestUri.getPort()) == -1 ? 80 : destinationPort) : null;
        final FutureResult result = new FutureResult();
        result.addCancelHandler(new Cancellable(){

            @Override
            public Cancellable cancel() {
                result.setCancelled();
                return this;
            }
        });
        IoFuture<HttpClientConnection> future = this.connect(destination, optionMap);
        future.addNotifier(new IoFuture.HandlingNotifier<HttpClientConnection, IoFuture<HttpClientRequest>>(){

            @Override
            public void handleCancelled(IoFuture<HttpClientRequest> attachment) {
                attachment.cancel();
            }

            @Override
            public void handleFailed(IOException exception, IoFuture<HttpClientRequest> attachment) {
                result.setException(exception);
            }

            @Override
            public void handleDone(HttpClientConnection data, IoFuture<HttpClientRequest> attachment) {
                try {
                    HttpClientRequest request = data.createRequest(method, requestUri);
                    result.setResult(request);
                }
                catch (IOException e) {
                    result.setException(e);
                }
                catch (Exception e) {
                    result.setException(new IOException(e));
                }
            }
        }, result.getIoFuture());
        return result.getIoFuture();
    }

    @Override
    public void close() throws IOException {
        for (HttpClientConnection connection : this.connections) {
            connection.close();
        }
    }

    Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    void connectionClosed(HttpClientConnection connection) {
        this.connections.remove(connection);
    }

    class ClientConnectionOpenListener
    implements ChannelListener<ConnectedStreamChannel> {
        private final Result<HttpClientConnection> result;
        private final OptionMap options;

        ClientConnectionOpenListener(Result<HttpClientConnection> result, OptionMap options) {
            this.result = result;
            this.options = options;
        }

        @Override
        public void handleEvent(ConnectedStreamChannel channel) {
            StreamSourceChannel readChannel = channel;
            StreamSinkChannel writeChannel = channel;
            if (channel.supportsOption(Options.READ_TIMEOUT)) {
                readChannel = new ReadTimeoutStreamSourceChannel(readChannel);
            }
            if (channel.supportsOption(Options.WRITE_TIMEOUT)) {
                writeChannel = new WriteTimeoutStreamSinkChannel(writeChannel);
            }
            PushBackStreamChannel pushBackStreamChannel = new PushBackStreamChannel(channel);
            AssembledConnectedStreamChannel assembledChannel = channel instanceof SslChannel ? new AssembledConnectedSslStreamChannel((SslChannel)((Object)channel), readChannel, writeChannel) : new AssembledConnectedStreamChannel(channel, readChannel, writeChannel);
            HttpClientConnectionImpl connection = new HttpClientConnectionImpl(assembledChannel, pushBackStreamChannel, this.options, HttpClientImpl.this);
            this.result.setResult(connection);
            HttpClientImpl.this.connections.add(connection);
        }
    }
}

