/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.UndertowLogger;
import io.undertow.channels.GatedStreamSinkChannel;
import io.undertow.client.HttpClientConnectionImpl;
import io.undertow.client.HttpClientOptions;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientResponse;
import io.undertow.client.HttpRequestConduit;
import io.undertow.client.PendingHttpRequest;
import io.undertow.client.UndertowClientMessages;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.FinishableStreamSinkConduit;
import io.undertow.conduits.FixedLengthStreamSinkConduit;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channel;
import java.util.HashSet;
import java.util.Set;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.StreamSinkChannelWrappingConduit;
import org.xnio.conduits.StreamSinkConduit;

class HttpClientRequestImpl
extends HttpClientRequest {
    private final URI target;
    private final boolean http11;
    private final HttpString method;
    private final HttpString protocol;
    private final boolean pipeline;
    private final OptionMap options;
    private final StreamSinkChannel underlyingChannel;
    private final HttpClientConnectionImpl connection;
    private final FutureResult<HttpClientResponse> responseFuture = new FutureResult();
    private volatile StreamSinkChannel conduitChannel;
    private volatile GatedStreamSinkChannel requestChannel;
    private static final Set<HttpString> idempotentMethods = new HashSet<HttpString>();

    HttpClientRequestImpl(HttpClientConnectionImpl connection, StreamSinkChannel underlyingChannel, HttpString method, URI target, boolean pipeline) {
        super(connection);
        this.options = connection.getOptions();
        this.method = method;
        this.target = target;
        this.connection = connection;
        this.underlyingChannel = underlyingChannel;
        this.protocol = this.options.get(HttpClientOptions.PROTOCOL, Protocols.HTTP_1_1);
        this.http11 = Protocols.HTTP_1_1.equals(this.protocol);
        this.pipeline = this.http11 && pipeline;
    }

    @Override
    public String getMethod() {
        return this.method.toString();
    }

    @Override
    public URI getTarget() {
        return this.target;
    }

    @Override
    public String getProtocol() {
        return this.protocol.toString();
    }

    @Override
    public IoFuture<HttpClientResponse> getResponse() {
        return this.responseFuture.getIoFuture();
    }

    String getURIString() {
        try {
            return new URI(null, null, null, -1, this.target.getPath().isEmpty() ? "/" : this.target.getPath(), this.target.getQuery(), this.target.getFragment()).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public StreamSinkChannel writeRequestBody(long contentLength) {
        if (this.requestChannel != null) {
            throw UndertowClientMessages.MESSAGES.requestAlreadyWritten();
        }
        HeaderMap headers = this.getRequestHeaders();
        this.resolveHost(headers);
        boolean keepAlive = this.http11 ? (headers.contains(Headers.CONNECTION) ? !headers.get(Headers.CONNECTION).equals(Headers.CLOSE.toString()) : true) : (Protocols.HTTP_1_0.equals(this.protocol) ? this.options.get(HttpClientOptions.HTTP_KEEP_ALIVE, false) : false);
        HttpString transferEncoding = Headers.IDENTITY;
        boolean hasContent = true;
        if (contentLength == -1L) {
            if (Methods.HEAD.equals(this.method)) {
                hasContent = false;
            } else if (!this.http11) {
                keepAlive = false;
            } else {
                transferEncoding = Headers.CHUNKED;
            }
        } else if (contentLength == 0L) {
            hasContent = false;
        } else if (contentLength <= 0L) {
            throw UndertowClientMessages.MESSAGES.illegalContentLength(contentLength);
        }
        if (hasContent && Methods.HEAD.equals(this.method)) {
            hasContent = false;
        }
        if (keepAlive) {
            if (!headers.contains(Headers.CONNECTION)) {
                headers.put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
            }
        } else {
            headers.put(Headers.CONNECTION, Headers.CLOSE.toString());
        }
        boolean expectContinue = false;
        if (this.http11 && hasContent && headers.contains(Headers.EXPECT)) {
            for (String s : headers.get(Headers.EXPECT)) {
                if (!s.toLowerCase().equals("100-continue")) continue;
                expectContinue = true;
                break;
            }
        }
        boolean pipelineNext = this.pipeline && idempotentMethods.contains(this.method);
        PendingHttpRequest request = new PendingHttpRequest(this, this.connection, keepAlive, hasContent, expectContinue, pipelineNext, this.responseFuture);
        StreamSinkConduit conduit = new StreamSinkChannelWrappingConduit(this.underlyingChannel);
        conduit = new HttpRequestConduit(conduit, this.connection.getBufferPool(), this);
        if (!hasContent) {
            headers.put(Headers.CONTENT_LENGTH, 0L);
            conduit = new FixedLengthStreamSinkConduit(conduit, 0L, false, !keepAlive, this.sendCompletedListener(request));
        } else if (!Headers.IDENTITY.equals(transferEncoding)) {
            headers.put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
            conduit = new ChunkedStreamSinkConduit(conduit, false, !keepAlive, this.sendCompletedListener(request), this);
        } else if (contentLength == -1L) {
            conduit = new FinishableStreamSinkConduit(conduit, this.sendCompletedListener(request));
        } else {
            headers.put(Headers.CONTENT_LENGTH, contentLength);
            conduit = new FixedLengthStreamSinkConduit(conduit, contentLength, false, !keepAlive, this.sendCompletedListener(request));
        }
        this.conduitChannel = new ConduitStreamSinkChannel(this.underlyingChannel, conduit);
        this.requestChannel = new GatedStreamSinkChannel(this.conduitChannel, this, false, false);
        this.connection.enqueueRequest(request);
        return this.requestChannel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void flushHeaders(final PendingHttpRequest request, final boolean openGate) {
        try {
            if (!this.conduitChannel.flush()) {
                this.conduitChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                    @Override
                    public void handleEvent(StreamSinkChannel channel) {
                        channel.suspendWrites();
                        channel.getWriteSetter().set(null);
                        if (!openGate) {
                            request.requestSent();
                        }
                    }
                }, new ChannelExceptionHandler<Channel>(){

                    @Override
                    public void handleException(Channel channel, IOException exception) {
                        UndertowLogger.CLIENT_LOGGER.debug("Exception ending request", exception);
                        IoUtils.safeClose((Closeable)HttpClientRequestImpl.this.connection.getChannel());
                        request.setFailed(exception);
                    }
                }));
                this.conduitChannel.resumeWrites();
            } else {
                request.requestSent();
            }
            if (openGate) return;
        }
        catch (IOException e) {
            UndertowLogger.CLIENT_LOGGER.debug("Exception sending request", e);
            IoUtils.safeClose((Closeable)this.connection.getChannel());
            request.setFailed(e);
        }
    }

    protected void openGate() {
        this.requestChannel.openGate(this);
    }

    private ConduitListener<? super StreamSinkConduit> sendCompletedListener(final PendingHttpRequest request) {
        return new ConduitListener<StreamSinkConduit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(StreamSinkConduit channel) {
                try {
                    request.requestSent();
                }
                finally {
                    if (!HttpClientRequestImpl.this.requestChannel.isGateOpen()) {
                        IoUtils.safeClose((Closeable)HttpClientRequestImpl.this.requestChannel);
                    }
                }
            }
        };
    }

    protected void resolveHost(HeaderMap headers) {
        if (!headers.contains(Headers.HOST)) {
            String host = null;
            if (this.target.isAbsolute()) {
                host = this.target.getHost();
            }
            if (host == null) {
                try {
                    host = this.connection.getPeerAddress(InetSocketAddress.class).getHostString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (host != null) {
                headers.put(Headers.HOST, host);
            } else if (this.http11) {
                headers.put(Headers.HOST, "");
            }
        }
    }

    public String toString() {
        return "HttpClientRequestImpl{" + this.method + " " + this.target + " " + this.protocol + '}';
    }

    static {
        idempotentMethods.add(Methods.GET);
        idempotentMethods.add(Methods.HEAD);
        idempotentMethods.add(Methods.PUT);
        idempotentMethods.add(Methods.DELETE);
        idempotentMethods.add(Methods.OPTIONS);
        idempotentMethods.add(Methods.TRACE);
    }
}

