/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class UndertowOutputStream
extends OutputStream {
    private final HttpServerExchange exchange;
    private ByteBuffer buffer;
    private Pooled<ByteBuffer> pooledBuffer;
    private Integer bufferSize;
    private StreamSinkChannel channel;
    private int state;
    private int written;
    private final Integer contentLength;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITE_STARTED = 2;

    public UndertowOutputStream(HttpServerExchange exchange) {
        this.exchange = exchange;
        String cl = exchange.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
        this.contentLength = cl != null ? Integer.valueOf(Integer.parseInt(cl)) : null;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int remaining;
        if (len < 1) {
            return;
        }
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        ByteBuffer buffer = this.buffer();
        for (int written = 0; written < len; written += remaining) {
            if (buffer.remaining() >= len - written) {
                buffer.put(b, off + written, len - written);
                if (buffer.remaining() == 0) {
                    this.writeBuffer();
                }
                this.updateWritten(len);
                return;
            }
            remaining = buffer.remaining();
            buffer.put(b, off + written, remaining);
            this.writeBuffer();
        }
        this.updateWritten(len);
    }

    void updateWritten(int len) throws IOException {
        this.written += len;
        if (this.contentLength != null && this.written >= this.contentLength) {
            this.flush();
            this.close();
        }
    }

    ByteBuffer underlyingBuffer() {
        return this.buffer();
    }

    @Override
    public void flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        if (this.buffer != null && this.buffer.position() != 0) {
            this.writeBuffer();
        }
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        Channels.flushBlocking(this.channel);
    }

    private void writeBuffer() throws IOException {
        this.buffer.flip();
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        Channels.writeBlocking(this.channel, this.buffer);
        this.buffer.clear();
        this.state |= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        try {
            this.state |= 1;
            if (Bits.anyAreClear(this.state, 2) && this.channel == null) {
                if (this.buffer == null) {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                } else {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + this.buffer.position());
                }
            }
            if (this.buffer != null) {
                this.writeBuffer();
            }
            if (this.channel == null) {
                this.channel = this.exchange.getResponseChannel();
            }
            StreamSinkChannel channel = this.channel;
            channel.shutdownWrites();
            Channels.flushBlocking(channel);
        }
        finally {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.free();
                this.buffer = null;
            } else {
                this.buffer = null;
            }
        }
    }

    public void closeAsync() throws IOException {
        block13: {
            if (Bits.anyAreSet(this.state, 1)) {
                this.exchange.endExchange();
                return;
            }
            this.state |= 1;
            if (Bits.anyAreClear(this.state, 2) && this.channel == null) {
                if (this.buffer == null) {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                } else {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + this.buffer.position());
                }
            }
            if (this.channel == null) {
                this.channel = this.exchange.getResponseChannel();
            }
            if (this.buffer != null) {
                this.buffer.flip();
                try {
                    int res = 0;
                    do {
                        res = this.channel.write(this.buffer);
                        if (this.buffer.hasRemaining()) continue;
                        if (this.pooledBuffer != null) {
                            this.pooledBuffer.free();
                        }
                        this.exchange.endExchange();
                        return;
                    } while (res > 0);
                    if (res == 0) {
                        this.channel.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<StreamSinkChannel>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void handleEvent(StreamSinkChannel channel) {
                                boolean ok = false;
                                do {
                                    int result;
                                    try {
                                        result = channel.write(UndertowOutputStream.this.buffer);
                                        ok = true;
                                    }
                                    catch (IOException e) {
                                        channel.suspendWrites();
                                        IoUtils.safeClose((Closeable)channel);
                                        UndertowOutputStream.this.exchange.endExchange();
                                        return;
                                    }
                                    finally {
                                        if (!ok && UndertowOutputStream.this.pooledBuffer != null) {
                                            UndertowOutputStream.this.pooledBuffer.free();
                                        }
                                    }
                                    if (result == 0) {
                                        return;
                                    }
                                    if (result != -1) continue;
                                    channel.suspendWrites();
                                    IoUtils.safeClose((Closeable)channel);
                                    UndertowOutputStream.this.exchange.endExchange();
                                } while (UndertowOutputStream.this.buffer.hasRemaining());
                                if (UndertowOutputStream.this.pooledBuffer != null) {
                                    UndertowOutputStream.this.pooledBuffer.free();
                                }
                                UndertowOutputStream.this.exchange.endExchange();
                            }
                        });
                        this.channel.resumeWrites();
                        break block13;
                    }
                    if (res == -1) {
                        IoUtils.safeClose((Closeable)this.channel);
                        this.exchange.endExchange();
                        break block13;
                    }
                    this.buffer = null;
                    this.pooledBuffer = null;
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)this.channel);
                    this.exchange.endExchange();
                }
            } else {
                this.exchange.endExchange();
                this.buffer = null;
                this.pooledBuffer = null;
            }
        }
    }

    private ByteBuffer buffer() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            return buffer;
        }
        if (this.bufferSize != null) {
            this.buffer = ByteBuffer.allocateDirect(this.bufferSize);
            return this.buffer;
        }
        this.pooledBuffer = this.exchange.getConnection().getBufferPool().allocate();
        this.buffer = this.pooledBuffer.getResource();
        return this.buffer;
    }

    public void resetBuffer() {
        if (Bits.anyAreClear(this.state, 2)) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.free();
                this.pooledBuffer = null;
            }
        } else {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.buffer = null;
    }

    public void setBufferSize(int size) {
        if (this.buffer != null) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.bufferSize = size;
    }

    public boolean isClosed() {
        return Bits.anyAreSet(this.state, 1);
    }
}

