/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;

public class ServletMatchingHandler
implements HttpHandler {
    private volatile ServletPathMatches paths;
    private final HttpHandler next;

    public ServletMatchingHandler(ServletPathMatches paths, HttpHandler next) {
        this.paths = paths;
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        ServletAttachments servletAttachments = exchange.getAttachment(ServletAttachments.ATTACHMENT_KEY);
        servletAttachments.setServletPathMatch(info);
        servletAttachments.setCurrentServlet(info);
        this.next.handleRequest(exchange);
    }

    public ServletPathMatches getPaths() {
        return this.paths;
    }

    public ServletMatchingHandler setPaths(ServletPathMatches paths) {
        this.paths = paths;
        return this;
    }
}

