/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

public class AsyncSenderImpl
implements Sender {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private final StreamSinkChannel streamSinkChannel;
    private final HttpServerExchange exchange;
    private final ChannelListener<Channel> writeListener = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            try {
                long res;
                long toWrite = Buffers.remaining(AsyncSenderImpl.this.buffer);
                for (long written = 0L; written < toWrite; written += res) {
                    res = AsyncSenderImpl.this.streamSinkChannel.write(AsyncSenderImpl.this.buffer, 0, AsyncSenderImpl.this.buffer.length);
                    if (res != 0L) continue;
                    return;
                }
                AsyncSenderImpl.this.streamSinkChannel.suspendWrites();
                AsyncSenderImpl.this.callback.onComplete(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this);
            }
            catch (IOException e) {
                AsyncSenderImpl.this.streamSinkChannel.suspendWrites();
                AsyncSenderImpl.this.callback.onException(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this, e);
            }
        }
    };
    private ByteBuffer[] buffer;
    private IoCallback callback;

    public AsyncSenderImpl(StreamSinkChannel streamSinkChannel, HttpServerExchange exchange) {
        this.streamSinkChannel = streamSinkChannel;
        this.exchange = exchange;
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        try {
            do {
                if (buffer.remaining() == 0) {
                    callback.onComplete(this.exchange, this);
                    return;
                }
                int res = this.streamSinkChannel.write(buffer);
                if (res != 0) continue;
                this.buffer = new ByteBuffer[]{buffer};
                this.callback = callback;
                this.streamSinkChannel.getWriteSetter().set(this.writeListener);
                this.streamSinkChannel.resumeWrites();
                return;
            } while (buffer.hasRemaining());
            callback.onComplete(this.exchange, this);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        long t = 0L;
        for (ByteBuffer l : buffer) {
            t += (long)l.remaining();
        }
        long total = t;
        long written = 0L;
        try {
            do {
                long res = this.streamSinkChannel.write(buffer);
                written += res;
                if (res != 0L) continue;
                this.buffer = buffer;
                this.callback = callback;
                this.streamSinkChannel.getWriteSetter().set(this.writeListener);
                this.streamSinkChannel.resumeWrites();
                return;
            } while (written < total);
            callback.onComplete(this.exchange, this);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(String data, IoCallback callback) {
        this.send(ByteBuffer.wrap(data.getBytes(utf8)), callback);
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        this.send(ByteBuffer.wrap(data.getBytes(charset)), callback);
    }

    @Override
    public void close(final IoCallback callback) {
        block5: {
            try {
                this.streamSinkChannel.shutdownWrites();
                if (!this.streamSinkChannel.flush()) {
                    this.streamSinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            callback.onComplete(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this);
                        }
                    }, new ChannelExceptionHandler<StreamSinkChannel>(){

                        @Override
                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            callback.onException(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this, exception);
                        }
                    }));
                    this.streamSinkChannel.resumeWrites();
                } else if (callback != null) {
                    callback.onComplete(this.exchange, this);
                }
            }
            catch (IOException e) {
                if (callback == null) break block5;
                callback.onException(this.exchange, this, e);
            }
        }
    }

    @Override
    public void close() {
        this.close(null);
    }
}

