/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.client.HttpClient;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientResponse;
import io.undertow.client.HttpContinueNotification;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpContinue;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Methods;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;

public final class ProxyHandler
implements HttpHandler {
    private static final AttachmentKey<HttpClientConnection> proxyConnection = AttachmentKey.create(HttpClientConnection.class);
    private static final ChannelListener<HttpServerConnection> CONN_CLOSE_LISTENER = new ChannelListener<HttpServerConnection>(){

        @Override
        public void handleEvent(HttpServerConnection channel) {
            IoUtils.safeClose((Closeable)channel.getAttachment(proxyConnection));
        }
    };
    private static final IoFuture.HandlingNotifier<HttpClientResponse, HttpServerExchange> RESPONSE_NOTIFIER = new IoFuture.HandlingNotifier<HttpClientResponse, HttpServerExchange>(){

        @Override
        public void handleCancelled(HttpServerExchange exchange) {
            exchange.setResponseCode(500);
            exchange.endExchange();
        }

        @Override
        public void handleFailed(IOException exception, HttpServerExchange exchange) {
            exchange.setResponseCode(500);
            exchange.endExchange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleDone(final HttpClientResponse response, HttpServerExchange exchange) {
            HeaderMap inboundResponseHeaders = response.getResponseHeaders();
            HeaderMap outboundResponseHeaders = exchange.getResponseHeaders();
            exchange.setResponseCode(response.getResponseCode());
            ProxyHandler.copyHeaders(outboundResponseHeaders, inboundResponseHeaders);
            if (exchange.isUpgrade()) {
                exchange.upgradeChannel(new ExchangeCompletionListener(){

                    @Override
                    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        ConnectedStreamChannel clientChannel = null;
                        try {
                            clientChannel = response.getRequest().getConnection().performUpgrade();
                            exchange.getConnection().resetChannel();
                            StreamConnection streamConnection = exchange.getConnection().getChannel();
                            if (exchange.getConnection().getExtraBytes() != null) {
                                streamConnection.getSourceChannel().setConduit(new ReadDataStreamSourceConduit(streamConnection.getSourceChannel().getConduit(), exchange.getConnection()));
                            }
                            ChannelListeners.initiateTransfer(Long.MAX_VALUE, clientChannel, streamConnection.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler(), ChannelListeners.closingChannelExceptionHandler(), exchange.getConnection().getBufferPool());
                            ChannelListeners.initiateTransfer(Long.MAX_VALUE, streamConnection.getSourceChannel(), clientChannel, ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler(), ChannelListeners.closingChannelExceptionHandler(), exchange.getConnection().getBufferPool());
                        }
                        catch (IOException e) {
                            IoUtils.safeClose(new Closeable[0]);
                        }
                    }
                });
            }
            try {
                ChannelListeners.initiateTransfer(Long.MAX_VALUE, response.readReplyBody(), exchange.getResponseChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(response.getRequest(), exchange), ChannelListeners.closingChannelExceptionHandler(), ChannelListeners.closingChannelExceptionHandler(), exchange.getConnection().getBufferPool());
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                try {
                    if (!exchange.isResponseStarted()) {
                        exchange.setResponseCode(500);
                    }
                }
                finally {
                    exchange.endExchange();
                }
            }
        }
    };
    private final HttpClient client;
    private final SocketAddress destination;
    private final IoFuture.HandlingNotifier<HttpClientConnection, HttpServerExchange> notifier = new IoFuture.HandlingNotifier<HttpClientConnection, HttpServerExchange>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleCancelled(HttpServerExchange exchange) {
            try {
                if (!exchange.isResponseStarted()) {
                    exchange.setResponseCode(500);
                }
            }
            finally {
                exchange.endExchange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleFailed(IOException exception, HttpServerExchange exchange) {
            try {
                if (!exchange.isResponseStarted()) {
                    exchange.setResponseCode(500);
                }
            }
            finally {
                exchange.endExchange();
            }
        }

        @Override
        public void handleDone(HttpClientConnection connection, HttpServerExchange exchange) {
            HttpServerConnection serverConnection = exchange.getConnection();
            serverConnection.putAttachment(proxyConnection, connection);
            serverConnection.getCloseSetter().set(CONN_CLOSE_LISTENER);
            ProxyHandler.this.handleRequest(exchange);
        }
    };

    public ProxyHandler(HttpClient client, SocketAddress destination) {
        this.client = client;
        this.destination = destination;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) {
        HttpServerConnection serverConnection = exchange.getConnection();
        HttpClientConnection clientConnection = serverConnection.getAttachment(proxyConnection);
        if (clientConnection == null) {
            exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

                @Override
                public void run() {
                    ProxyHandler.this.client.connect(ProxyHandler.this.destination, OptionMap.EMPTY).addNotifier(ProxyHandler.this.notifier, exchange);
                }
            });
            return;
        }
        exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(clientConnection, exchange, serverConnection));
    }

    static void copyHeaders(HeaderMap to, HeaderMap from) {
        long f = from.fastIterateNonEmpty();
        while (f != -1L) {
            HeaderValues values = from.fiCurrent(f);
            to.putAll(values.getHeaderName(), values);
            f = from.fiNextNonEmpty(f);
        }
    }

    private static final class HTTPTrailerChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private final Attachable source;
        private final Attachable target;

        private HTTPTrailerChannelListener(Attachable source, Attachable target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            HeaderMap trailers = this.source.getAttachment(ChunkedStreamSourceConduit.TRAILERS);
            if (trailers != null) {
                this.target.putAttachment(ChunkedStreamSinkConduit.TRAILERS, trailers);
            }
            try {
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeWrites();
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    private static class ProxyAction
    implements Runnable {
        private final HttpClientConnection clientConnection;
        private final HttpServerExchange exchange;
        private final HttpServerConnection serverConnection;

        public ProxyAction(HttpClientConnection clientConnection, HttpServerExchange exchange, HttpServerConnection serverConnection) {
            this.clientConnection = clientConnection;
            this.exchange = exchange;
            this.serverConnection = serverConnection;
        }

        @Override
        public void run() {
            HttpClientRequest request;
            try {
                String requestURI = this.exchange.getRequestURI();
                String qs = this.exchange.getQueryString();
                if (qs != null && !qs.isEmpty()) {
                    requestURI = requestURI + "?" + qs;
                }
                request = this.clientConnection.createRequest(this.exchange.getRequestMethod(), new URI(URLEncoder.encode(requestURI, "UTF-8")));
            }
            catch (URISyntaxException e) {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
                return;
            }
            catch (UnsupportedEncodingException e) {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
                return;
            }
            HeaderMap inboundRequestHeaders = this.exchange.getRequestHeaders();
            HeaderMap outboundRequestHeaders = request.getRequestHeaders();
            ProxyHandler.copyHeaders(outboundRequestHeaders, inboundRequestHeaders);
            long requestContentLength = this.exchange.getRequestContentLength();
            if (HttpContinue.requiresContinueResponse(this.exchange)) {
                request.setContinueHandler(new HttpContinueNotification(){

                    @Override
                    public void handleContinue(final HttpContinueNotification.ContinueContext context) {
                        HttpContinue.sendContinueResponse(ProxyAction.this.exchange, new IoCallback(){

                            @Override
                            public void onComplete(HttpServerExchange exchange, Sender sender) {
                                context.done();
                            }

                            @Override
                            public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                context.done();
                            }
                        });
                    }
                });
            }
            if (requestContentLength == 0L || this.exchange.getRequestMethod().equals(Methods.GET)) {
                request.writeRequestBody(0L);
            } else {
                ChannelListeners.initiateTransfer(Long.MAX_VALUE, this.exchange.getRequestChannel(), request.writeRequestBody(requestContentLength), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(this.exchange, request), ChannelListeners.closingChannelExceptionHandler(), ChannelListeners.closingChannelExceptionHandler(), this.exchange.getConnection().getBufferPool());
            }
            IoFuture<HttpClientResponse> futureResponse = request.getResponse();
            futureResponse.addNotifier(RESPONSE_NOTIFIER, this.exchange);
        }
    }
}

