/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.SameThreadExecutor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultServlet
extends HttpServlet {
    private final Deployment deployment;
    private final DefaultServletConfig config;
    private final ResourceManager resourceManager;
    private final List<String> welcomePages;

    public DefaultServlet(Deployment deployment, DefaultServletConfig config, List<String> welcomePages) {
        this.deployment = deployment;
        this.config = config;
        this.welcomePages = welcomePages;
        this.resourceManager = deployment.getDeploymentInfo().getResourceManager();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getPath(req);
        if (!this.isAllowed(path)) {
            resp.sendError(404);
            return;
        }
        Resource resource = this.resourceManager.getResource(path);
        if (resource == null) {
            if (req.getDispatcherType() == DispatcherType.INCLUDE) {
                throw new FileNotFoundException(path);
            }
            resp.sendError(404);
            return;
        }
        if (resource.isDirectory()) {
            this.handleWelcomePage(req, resp, path);
        } else {
            this.serveFileBlocking(req, resp, resource);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        switch (req.getDispatcherType()) {
            case INCLUDE: 
            case FORWARD: {
                this.doGet(req, resp);
                break;
            }
            default: {
                super.doPost(req, resp);
            }
        }
    }

    private void serveFileBlocking(HttpServletRequest req, HttpServletResponse resp, Resource resource) throws IOException {
        Long contentLength;
        ETag etag = resource.getETag();
        Date lastModified = resource.getLastModified();
        if (!ETagUtils.handleIfMatch(req.getHeader("If-Match"), etag, false) || !DateUtils.handleIfUnmodifiedSince(req.getHeader("If-Unmodified-Since"), lastModified)) {
            resp.setStatus(412);
            return;
        }
        if (!ETagUtils.handleIfNoneMatch(req.getHeader("If-None-Match"), etag, true) || !DateUtils.handleIfModifiedSince(req.getHeader("If-Modified-Since"), lastModified)) {
            resp.setStatus(304);
            return;
        }
        String contentType = this.deployment.getServletContext().getMimeType(resource.getName());
        if (contentType != null) {
            resp.setHeader("Content-Type", contentType);
        } else {
            resp.setHeader("Content-Type", "application/octet-stream");
        }
        if (lastModified != null) {
            resp.setHeader("Last-Modified", resource.getLastModifiedString());
        }
        if (etag != null) {
            resp.setHeader("ETag", etag.toString());
        }
        if ((contentLength = resource.getContentLength()) != null) {
            resp.setContentLengthLong(contentLength);
        }
        if (!req.getMethod().equals("HEAD")) {
            resource.serve(ServletRequestContext.requireCurrent().getOriginalRequest().getExchange());
        }
    }

    private void handleWelcomePage(HttpServletRequest req, HttpServletResponse resp, String oldPath) throws IOException, ServletException {
        String pathWithTraingSlash;
        String welcomePage = this.findWelcomeFile(oldPath);
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        String string = pathWithTraingSlash = pathInfo.endsWith("/") ? pathInfo : pathInfo + "/";
        if (welcomePage != null) {
            this.redirect(req, welcomePage);
        } else {
            String path = this.findWelcomeServlet(pathWithTraingSlash);
            if (path != null) {
                this.redirect(req, path);
            } else {
                resp.sendError(404);
            }
        }
    }

    private void redirect(HttpServletRequest req, final String pathAddition) {
        final HttpServletRequestImpl requestImpl = ServletRequestContext.requireCurrent().getOriginalRequest();
        final HttpServerExchange exchange = requestImpl.getExchange();
        if (!exchange.isRequestChannelAvailable()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

            @Override
            public void run() {
                String path = pathAddition;
                if (!exchange.getRelativePath().endsWith("/")) {
                    path = "/" + path;
                }
                exchange.getResponseHeaders().clear();
                exchange.setResponseCode(200);
                exchange.setRelativePath(exchange.getRelativePath() + path);
                exchange.setCanonicalPath(exchange.getCanonicalPath() + path);
                exchange.setRequestPath(exchange.getRequestPath() + path);
                exchange.setRequestURI(exchange.getRequestURI() + path);
                HttpHandlers.executeRootHandler(requestImpl.getServletContext().getDeployment().getServletHandler(), exchange, false);
            }
        });
    }

    private String findWelcomeFile(String path) {
        String realPath = path.endsWith("/") ? path : path + "/";
        for (String i : this.welcomePages) {
            try {
                Resource resource = this.resourceManager.getResource(realPath + i);
                if (resource == null) continue;
                return i;
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    private String findWelcomeServlet(String path) {
        for (String i : this.welcomePages) {
            ServletPathMatch handler = this.deployment.getServletPaths().getServletHandlerByExactPath(path + i);
            if (handler == null) continue;
            return i;
        }
        return null;
    }

    private String getPath(HttpServletRequest request) {
        if (request.getDispatcherType() == DispatcherType.INCLUDE && request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    private boolean isAllowed(String path) {
        if (!path.isEmpty() && (path.startsWith("/META-INF") || path.startsWith("META-INF") || path.startsWith("/WEB-INF") || path.startsWith("WEB-INF"))) {
            return false;
        }
        int pos = path.lastIndexOf(47);
        String lastSegment = pos == -1 ? path : path.substring(pos + 1);
        if (lastSegment.isEmpty()) {
            return true;
        }
        int ext = lastSegment.lastIndexOf(46);
        if (ext == -1) {
            return true;
        }
        String extension = lastSegment.substring(ext + 1, lastSegment.length());
        if (this.config.isDefaultAllowed()) {
            return !this.config.getDisallowed().contains(extension);
        }
        return this.config.getAllowed().contains(extension);
    }
}

