/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.DateUtils;
import io.undertow.util.Headers;
import java.util.Date;

public class DateHandler
implements HttpHandler {
    private final HttpHandler next;
    private volatile String cachedDateString;
    private volatile long nextUpdateTime = -1L;

    public DateHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        long time = System.currentTimeMillis();
        if (time < this.nextUpdateTime) {
            exchange.getResponseHeaders().put(Headers.DATE, this.cachedDateString);
        } else {
            String dateString;
            this.nextUpdateTime = time + 1000L;
            this.cachedDateString = dateString = DateUtils.toDateString(new Date(time));
            exchange.getResponseHeaders().put(Headers.DATE, dateString);
        }
        this.next.handleRequest(exchange);
    }
}

