/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.AttachmentKey;
import io.undertow.util.SameThreadExecutor;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.XnioExecutor;

public class AsyncContextImpl
implements AsyncContext {
    public static final AttachmentKey<Boolean> ASYNC_SUPPORTED = AttachmentKey.create(Boolean.class);
    public static final AttachmentKey<Executor> ASYNC_EXECUTOR = AttachmentKey.create(Executor.class);
    private final List<BoundAsyncListener> asyncListeners = new CopyOnWriteArrayList<BoundAsyncListener>();
    private final HttpServerExchange exchange;
    private final ServletRequest servletRequest;
    private final ServletResponse servletResponse;
    private final TimeoutTask timeoutTask = new TimeoutTask();
    private final ServletRequestContext servletRequestContext;
    private AsyncContextImpl previousAsyncContext;
    private volatile long timeout = 120000L;
    private volatile XnioExecutor.Key timeoutKey;
    private boolean dispatched;
    private boolean initialRequestDone;
    private Thread initiatingThread;
    private final Deque<Runnable> asyncTaskQueue = new ArrayDeque<Runnable>();
    private boolean processingAsyncTask = false;

    public AsyncContextImpl(final HttpServerExchange exchange, ServletRequest servletRequest, ServletResponse servletResponse, ServletRequestContext servletRequestContext, AsyncContextImpl previousAsyncContext) {
        this.exchange = exchange;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.servletRequestContext = servletRequestContext;
        this.previousAsyncContext = previousAsyncContext;
        this.initiatingThread = Thread.currentThread();
        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

            @Override
            public void run() {
                exchange.setDispatchExecutor(null);
                AsyncContextImpl.this.initialRequestDone();
            }
        });
    }

    public void updateTimeout() {
        XnioExecutor.Key key = this.timeoutKey;
        if (key != null && !key.remove()) {
            return;
        }
        if (this.timeout > 0L) {
            this.timeoutKey = this.exchange.getIoThread().executeAfter(this.timeoutTask, this.timeout, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    @Override
    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    @Override
    public boolean hasOriginalRequestAndResponse() {
        return this.servletRequest instanceof HttpServletRequestImpl && this.servletResponse instanceof HttpServletResponseImpl;
    }

    @Override
    public void dispatch() {
        HttpServletRequestImpl requestImpl = this.servletRequestContext.getOriginalRequest();
        Deployment deployment = requestImpl.getServletContext().getDeployment();
        ServletPathMatch handler = this.servletRequest instanceof HttpServletRequest ? deployment.getServletPaths().getServletHandlerByPath(((HttpServletRequest)this.servletRequest).getServletPath()) : deployment.getServletPaths().getServletHandlerByPath(this.exchange.getRelativePath());
        HttpServerExchange exchange = requestImpl.getExchange();
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        servletRequestContext.setDispatcherType(DispatcherType.ASYNC);
        servletRequestContext.setServletRequest(this.servletRequest);
        servletRequestContext.setServletResponse(this.servletResponse);
        this.dispatchAsyncRequest(deployment.getServletDispatcher(), handler, exchange);
    }

    private void dispatchAsyncRequest(final ServletDispatcher servletDispatcher, final ServletPathMatch pathInfo, final HttpServerExchange exchange) {
        this.doDispatch(new Runnable(){

            @Override
            public void run() {
                HttpHandlers.executeRootHandler(new HttpHandler(){

                    @Override
                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        servletDispatcher.dispatchToPath(exchange, pathInfo, DispatcherType.ASYNC);
                    }
                }, exchange, false);
            }
        });
    }

    @Override
    public void dispatch(String path) {
        this.dispatch(this.servletRequest.getServletContext(), path);
    }

    @Override
    public void dispatch(ServletContext context, String path) {
        HttpServletRequestImpl requestImpl = this.servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = this.servletRequestContext.getOriginalResponse();
        HttpServerExchange exchange = requestImpl.getExchange();
        exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).setDispatcherType(DispatcherType.ASYNC);
        requestImpl.setAttribute("javax.servlet.async.request_uri", requestImpl.getRequestURI());
        requestImpl.setAttribute("javax.servlet.async.context_path", requestImpl.getContextPath());
        requestImpl.setAttribute("javax.servlet.async.servlet_path", requestImpl.getServletPath());
        requestImpl.setAttribute("javax.servlet.async.query_string", requestImpl.getQueryString());
        String newQueryString = "";
        int qsPos = path.indexOf("?");
        String newServletPath = path;
        if (qsPos != -1) {
            newQueryString = newServletPath.substring(qsPos + 1);
            newServletPath = newServletPath.substring(0, qsPos);
        }
        String newRequestUri = context.getContextPath() + newServletPath;
        HashMap<String, Deque<String>> newQueryParameters = new HashMap<String, Deque<String>>();
        String[] arr$ = newQueryString.split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ArrayDeque<String> queue;
            String part;
            String name = part = arr$[i$];
            String value = "";
            int equals = part.indexOf(61);
            if (equals != -1) {
                name = part.substring(0, equals);
                value = part.substring(equals + 1);
            }
            if ((queue = (ArrayDeque<String>)newQueryParameters.get(name)) == null) {
                queue = new ArrayDeque<String>(1);
                newQueryParameters.put(name, queue);
            }
            queue.add(value);
        }
        requestImpl.setQueryParameters(newQueryParameters);
        requestImpl.getExchange().setRelativePath(newServletPath);
        requestImpl.getExchange().setQueryString(newQueryString);
        requestImpl.getExchange().setRequestPath(newRequestUri);
        requestImpl.getExchange().setRequestURI(newRequestUri);
        requestImpl.setServletContext((ServletContextImpl)context);
        responseImpl.setServletContext((ServletContextImpl)context);
        Deployment deployment = requestImpl.getServletContext().getDeployment();
        ServletPathMatch info = deployment.getServletPaths().getServletHandlerByPath(newServletPath);
        requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY).setServletPathMatch(info);
        this.dispatchAsyncRequest(deployment.getServletDispatcher(), info, exchange);
    }

    @Override
    public synchronized void complete() {
        this.onAsyncComplete();
        this.completeInternal();
    }

    public synchronized void completeInternal() {
        if (!this.initialRequestDone && Thread.currentThread() == this.initiatingThread) {
            if (this.dispatched) {
                throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyDispatched();
            }
            this.exchange.unDispatch();
            this.dispatched = true;
            HttpServletRequestImpl request = this.servletRequestContext.getOriginalRequest();
            this.initialRequestDone();
            request.asyncRequestDispatched();
        } else {
            this.doDispatch(new Runnable(){

                @Override
                public void run() {
                    HttpServletResponseImpl response = AsyncContextImpl.this.servletRequestContext.getOriginalResponse();
                    response.responseDone();
                }
            });
        }
    }

    @Override
    public void start(final Runnable run) {
        Executor executor = this.asyncExecutor();
        final CompositeThreadSetupAction setup = this.servletRequestContext.getOriginalRequest().getServletContext().getDeployment().getThreadSetupAction();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThreadSetupAction.Handle handle = setup.setup(null);
                try {
                    run.run();
                }
                finally {
                    handle.tearDown();
                }
            }
        });
    }

    private Executor asyncExecutor() {
        Executor executor = this.exchange.getAttachment(ASYNC_EXECUTOR);
        if (executor == null) {
            executor = this.exchange.getDispatchExecutor();
        }
        if (executor == null) {
            executor = this.exchange.getConnection().getWorker();
        }
        return executor;
    }

    @Override
    public void addListener(AsyncListener listener) {
        this.asyncListeners.add(new BoundAsyncListener(listener, this.servletRequest, this.servletResponse));
    }

    @Override
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.asyncListeners.add(new BoundAsyncListener(listener, servletRequest, servletResponse));
    }

    public boolean isDispatched() {
        return this.dispatched;
    }

    @Override
    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            InstanceFactory<T> factory = ((ServletContextImpl)this.servletRequest.getServletContext()).getDeployment().getDeploymentInfo().getClassIntrospecter().createInstanceFactory(clazz);
            return (T)((AsyncListener)factory.createInstance().getInstance());
        }
        catch (NoSuchMethodException e) {
            throw new ServletException(e);
        }
        catch (InstantiationException e) {
            throw new ServletException(e);
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    public void handleError(Throwable error) {
        this.dispatched = false;
        this.onAsyncError(error);
        if (!this.dispatched) {
            this.servletRequest.setAttribute("javax.servlet.error.exception", error);
            try {
                ((HttpServletResponse)this.servletResponse).sendError(500);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            }
            if (!this.dispatched) {
                this.complete();
            }
        }
    }

    public synchronized void initialRequestDone() {
        this.initialRequestDone = true;
        if (this.previousAsyncContext != null) {
            this.previousAsyncContext.onAsyncStart(this);
            this.previousAsyncContext = null;
        }
        if (!this.processingAsyncTask) {
            this.processAsyncTask();
        }
        this.initiatingThread = null;
    }

    private synchronized void doDispatch(final Runnable runnable) {
        if (this.dispatched) {
            throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyDispatched();
        }
        this.dispatched = true;
        final HttpServletRequestImpl request = this.servletRequestContext.getOriginalRequest();
        this.addAsyncTask(new Runnable(){

            @Override
            public void run() {
                request.asyncRequestDispatched();
                runnable.run();
            }
        });
        if (this.timeoutKey != null) {
            this.timeoutKey.remove();
        }
    }

    private synchronized void processAsyncTask() {
        if (!this.initialRequestDone) {
            return;
        }
        this.updateTimeout();
        Runnable task = this.asyncTaskQueue.poll();
        if (task != null) {
            this.processingAsyncTask = true;
            this.asyncExecutor().execute(new TaskDispatchRunnable(task));
        } else {
            this.processingAsyncTask = false;
        }
    }

    public synchronized void addAsyncTask(Runnable runnable) {
        this.asyncTaskQueue.add(runnable);
        if (!this.processingAsyncTask) {
            this.processAsyncTask();
        }
    }

    private void onAsyncComplete() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent(this, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onComplete(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    private void onAsyncTimeout() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent(this, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onTimeout(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    private void onAsyncStart(AsyncContext newAsyncContext) {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent(newAsyncContext, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onStartAsync(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    private void onAsyncError(Throwable t) {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent(this, listener.servletRequest, listener.servletResponse, t);
            try {
                listener.asyncListener.onError(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    private final class BoundAsyncListener {
        final AsyncListener asyncListener;
        final ServletRequest servletRequest;
        final ServletResponse servletResponse;

        private BoundAsyncListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.asyncListener = asyncListener;
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }
    }

    private class TaskDispatchRunnable
    implements Runnable {
        private final Runnable task;

        private TaskDispatchRunnable(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.task.run();
            }
            finally {
                AsyncContextImpl.this.processAsyncTask();
            }
        }
    }

    private final class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AsyncContextImpl asyncContextImpl = AsyncContextImpl.this;
            synchronized (asyncContextImpl) {
                if (!AsyncContextImpl.this.dispatched) {
                    UndertowServletLogger.REQUEST_LOGGER.debug("Async request timed out");
                    AsyncContextImpl.this.onAsyncTimeout();
                    if (!AsyncContextImpl.this.dispatched) {
                        try {
                            ((HttpServletResponse)AsyncContextImpl.this.servletResponse).sendError(500);
                        }
                        catch (IOException e) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        }
                        if (!AsyncContextImpl.this.dispatched) {
                            AsyncContextImpl.this.complete();
                        }
                    }
                }
            }
        }
    }
}

