/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.ajp.AjpParseState;
import io.undertow.ajp.AjpParser;
import io.undertow.ajp.AjpRequestConduit;
import io.undertow.ajp.AjpResponseConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.EmptyStreamSourceConduit;
import org.xnio.conduits.StreamSinkChannelWrappingConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

final class AjpReadListener
implements ChannelListener<StreamSourceChannel> {
    private final StreamSinkChannel responseChannel;
    private AjpParseState state = new AjpParseState();
    private HttpServerExchange httpServerExchange;
    private final HttpServerConnection connection;
    private volatile int read = 0;
    private final int maxRequestSize;

    AjpReadListener(StreamSinkChannel responseChannel, StreamSourceChannel requestChannel, HttpServerConnection connection) {
        this.responseChannel = responseChannel;
        this.connection = connection;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 51200);
        this.httpServerExchange = new HttpServerExchange(connection, requestChannel, this.responseChannel);
        this.httpServerExchange.addExchangeCompleteListener(new StartNextRequestAction(requestChannel, responseChannel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(StreamSourceChannel channel) {
        Pooled<ByteBuffer> existing = this.connection.getExtraBytes();
        Pooled<ByteBuffer> pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = pooled.getResource();
        boolean free = true;
        try {
            do {
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res == 0) {
                    if (!channel.isReadResumed()) {
                        channel.getReadSetter().set(this);
                        channel.resumeReads();
                    }
                    return;
                }
                if (res == -1) {
                    try {
                        channel.shutdownReads();
                        StreamSinkChannel responseChannel = this.responseChannel;
                        responseChannel.shutdownWrites();
                        if (!responseChannel.flush()) {
                            responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                            responseChannel.resumeWrites();
                        }
                    }
                    catch (IOException e) {
                        if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    return;
                }
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                int begin = buffer.remaining();
                AjpParser.INSTANCE.parse(buffer, this.state, this.httpServerExchange);
                this.read += begin - buffer.remaining();
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes(pooled);
                }
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)this.connection);
                return;
            } while (!this.state.isComplete());
            channel.getReadSetter().set(null);
            channel.suspendReads();
            HttpServerExchange httpServerExchange = this.httpServerExchange;
            httpServerExchange.putAttachment(UndertowOptions.ATTACHMENT_KEY, this.connection.getUndertowOptions());
            AjpConduitWrapper channelWrapper = new AjpConduitWrapper(new AjpResponseConduit(new StreamSinkChannelWrappingConduit(this.responseChannel), this.connection.getBufferPool(), httpServerExchange));
            httpServerExchange.addResponseWrapper(channelWrapper);
            httpServerExchange.addRequestWrapper(channelWrapper.getRequestWrapper());
            try {
                httpServerExchange.setRequestScheme(this.connection.getSslSession() != null ? "https" : "http");
                this.state = null;
                this.httpServerExchange = null;
                HttpHandlers.executeRootHandler(this.connection.getRootHandler(), httpServerExchange, Thread.currentThread() instanceof XnioExecutor);
            }
            catch (Throwable t) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t);
                IoUtils.safeClose((Closeable)channel);
                IoUtils.safeClose((Closeable)this.connection);
            }
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
            IoUtils.safeClose((Closeable)this.connection.getChannel());
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private class AjpConduitWrapper
    implements ConduitWrapper<StreamSinkConduit> {
        private final AjpResponseConduit responseConduit;

        private AjpConduitWrapper(AjpResponseConduit responseConduit) {
            this.responseConduit = responseConduit;
        }

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            return this.responseConduit;
        }

        public ConduitWrapper<StreamSourceConduit> getRequestWrapper() {
            return new ConduitWrapper<StreamSourceConduit>(){

                @Override
                public StreamSourceConduit wrap(ConduitFactory<StreamSourceConduit> factory, HttpServerExchange exchange) {
                    Long length;
                    StreamSourceConduit conduit = factory.create();
                    conduit = new ReadDataStreamSourceConduit(conduit, exchange.getConnection());
                    HeaderMap requestHeaders = exchange.getRequestHeaders();
                    HttpString transferEncoding = Headers.IDENTITY;
                    boolean hasTransferEncoding = requestHeaders.contains(Headers.TRANSFER_ENCODING);
                    if (hasTransferEncoding) {
                        transferEncoding = new HttpString(requestHeaders.getLast(Headers.TRANSFER_ENCODING));
                    }
                    if (hasTransferEncoding && !transferEncoding.equals(Headers.IDENTITY)) {
                        length = null;
                    } else if (exchange.getRequestHeaders().contains(Headers.CONTENT_LENGTH)) {
                        long contentLength = Long.parseLong(requestHeaders.getFirst(Headers.CONTENT_LENGTH));
                        if (contentLength == 0L) {
                            UndertowLogger.REQUEST_LOGGER.trace("No content, starting next request");
                            exchange.terminateRequest();
                            return new EmptyStreamSourceConduit(conduit.getReadThread());
                        }
                        length = contentLength;
                    } else {
                        UndertowLogger.REQUEST_LOGGER.trace("No content length or transfer coding, starting next request");
                        exchange.terminateRequest();
                        return new EmptyStreamSourceConduit(conduit.getReadThread());
                    }
                    return new AjpRequestConduit(conduit, AjpConduitWrapper.this.responseConduit, length);
                }
            };
        }
    }

    private static class StartNextRequestAction
    implements ExchangeCompletionListener {
        private StreamSourceChannel requestChannel;
        private StreamSinkChannel responseChannel;

        public StartNextRequestAction(StreamSourceChannel requestChannel, StreamSinkChannel responseChannel) {
            this.requestChannel = requestChannel;
            this.responseChannel = responseChannel;
        }

        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            StreamSourceChannel channel = this.requestChannel;
            AjpReadListener listener = new AjpReadListener(this.responseChannel, channel, exchange.getConnection());
            channel.getReadSetter().set(listener);
            channel.resumeReads();
            this.responseChannel = null;
            this.requestChannel = null;
            nextListener.proceed();
        }

        private static class DoNextRequestRead
        implements Runnable {
            private final AjpReadListener listener;
            private final StreamSourceChannel channel;

            public DoNextRequestRead(AjpReadListener listener, StreamSourceChannel channel) {
                this.listener = listener;
                this.channel = channel;
            }

            @Override
            public void run() {
                this.listener.handleEvent(this.channel);
            }
        }
    }
}

