/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.CachedAuthenticatedSessionMechanism;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.security.impl.RoleMappingManagerImpl;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.AttachmentHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.core.DeploymentImpl;
import io.undertow.servlet.core.ErrorPages;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.handlers.DispatcherTypePredicate;
import io.undertow.servlet.handlers.FilterHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletDispatchingHandler;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletInitialHandler;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import io.undertow.servlet.handlers.security.SecurityPathMatches;
import io.undertow.servlet.handlers.security.ServletAuthenticationConstraintHandler;
import io.undertow.servlet.handlers.security.ServletConfidentialityConstraintHandler;
import io.undertow.servlet.handlers.security.ServletFormAuthenticationMechanism;
import io.undertow.servlet.handlers.security.ServletSecurityConstraintHandler;
import io.undertow.servlet.handlers.security.ServletSecurityRoleHandler;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import javax.servlet.annotation.ServletSecurity;

public class DeploymentManagerImpl
implements DeploymentManager {
    private final DeploymentInfo originalDeployment;
    private final ServletContainer servletContainer;
    private volatile DeploymentImpl deployment;
    private volatile DeploymentManager.State state = DeploymentManager.State.UNDEPLOYED;
    private volatile InstanceHandle<Executor> executor;
    private volatile InstanceHandle<Executor> asyncExecutor;

    public DeploymentManagerImpl(DeploymentInfo deployment, ServletContainer servletContainer) {
        this.originalDeployment = deployment;
        this.servletContainer = servletContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy() {
        DeploymentImpl deployment;
        DeploymentInfo deploymentInfo = this.originalDeployment.clone();
        deploymentInfo.validate();
        this.deployment = deployment = new DeploymentImpl(deploymentInfo);
        ServletContextImpl servletContext = new ServletContextImpl(this.servletContainer, deployment);
        deployment.setServletContext(servletContext);
        ArrayList<ThreadSetupAction> setup = new ArrayList<ThreadSetupAction>();
        setup.add(new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()));
        setup.addAll(deploymentInfo.getThreadSetupActions());
        CompositeThreadSetupAction threadSetupAction = new CompositeThreadSetupAction(setup);
        deployment.setThreadSetupAction(threadSetupAction);
        ThreadSetupAction.Handle handle = threadSetupAction.setup(null);
        try {
            ApplicationListeners listeners = this.createListeners();
            deployment.setApplicationListeners(listeners);
            for (ServletContainerInitializerInfo sci : deploymentInfo.getServletContainerInitializers()) {
                InstanceHandle<? extends ServletContainerInitializer> instance = sci.getInstanceFactory().createInstance();
                try {
                    instance.getInstance().onStartup(sci.getHandlesTypes(), servletContext);
                }
                finally {
                    instance.release();
                }
            }
            listeners.contextInitialized();
            this.initializeErrorPages(deployment, deploymentInfo);
            this.initializeMimeMappings(deployment, deploymentInfo);
            this.initializeTempDir(servletContext, deploymentInfo);
            ServletPathMatches matches = this.setupServletChains(servletContext, threadSetupAction, listeners);
            deployment.setServletPaths(matches);
            HttpHandler wrappedHandlers = ServletDispatchingHandler.INSTANCE;
            wrappedHandlers = this.wrapHandlers(wrappedHandlers, deploymentInfo.getInnerHandlerChainWrappers());
            HttpHandler securityHandler = this.setupSecurityHandlers(wrappedHandlers);
            wrappedHandlers = new PredicateHandler(DispatcherTypePredicate.REQUEST, securityHandler, wrappedHandlers);
            wrappedHandlers = this.wrapHandlers(wrappedHandlers, deploymentInfo.getOuterHandlerChainWrappers());
            ServletInitialHandler servletInitialHandler = new ServletInitialHandler(matches, wrappedHandlers, deployment.getThreadSetupAction(), servletContext);
            deployment.setServletHandler(servletInitialHandler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            handle.tearDown();
        }
        this.state = DeploymentManager.State.DEPLOYED;
    }

    private HttpHandler setupSecurityHandlers(HttpHandler initialHandler) {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        HttpHandler current = initialHandler;
        SecurityPathMatches securityPathMatches = this.buildSecurityConstraints();
        current = new AuthenticationCallHandler(current);
        if (!securityPathMatches.isEmpty()) {
            current = new ServletAuthenticationConstraintHandler(current);
        }
        current = new ServletConfidentialityConstraintHandler(deploymentInfo.getConfidentialPortManager(), current);
        if (!securityPathMatches.isEmpty()) {
            current = new ServletSecurityConstraintHandler(securityPathMatches, current);
        }
        if (loginConfig != null) {
            LinkedList<AuthenticationMechanism> authenticationMechanisms = new LinkedList<AuthenticationMechanism>();
            authenticationMechanisms.add(new CachedAuthenticatedSessionMechanism());
            String requestedMechanism = loginConfig.getAuthMethod();
            if (requestedMechanism.equalsIgnoreCase("BASIC")) {
                authenticationMechanisms.add(new BasicAuthenticationMechanism(loginConfig.getRealmName(), "BASIC"));
            } else if (requestedMechanism.equalsIgnoreCase("FORM")) {
                authenticationMechanisms.add(new ServletFormAuthenticationMechanism("FORM", loginConfig.getLoginPage(), loginConfig.getErrorPage()));
            } else if (requestedMechanism.equalsIgnoreCase("CLIENT_CERT")) {
                authenticationMechanisms.add(new ClientCertAuthenticationMechanism("CLIENT_CERT"));
            }
            current = new AuthenticationMechanismsHandler(current, authenticationMechanisms);
        }
        current = new CachedAuthenticatedSessionHandler(current, this.deployment.getServletContext());
        current = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, deploymentInfo.getIdentityManager(), current);
        return current;
    }

    private SecurityPathMatches buildSecurityConstraints() {
        SecurityPathMatches.Builder builder = SecurityPathMatches.builder(this.deployment.getDeploymentInfo());
        HashSet<String> urlPatterns = new HashSet<String>();
        for (SecurityConstraint constraint : this.deployment.getDeploymentInfo().getSecurityConstraints()) {
            builder.addSecurityConstraint(constraint);
            for (WebResourceCollection webResources : constraint.getWebResourceCollections()) {
                urlPatterns.addAll(webResources.getUrlPatterns());
            }
        }
        for (ServletInfo servlet : this.deployment.getDeploymentInfo().getServlets().values()) {
            ServletSecurityInfo securityInfo = servlet.getServletSecurityInfo();
            if (securityInfo == null) continue;
            HashSet<String> mappings = new HashSet<String>(servlet.getMappings());
            mappings.removeAll(urlPatterns);
            if (mappings.isEmpty()) continue;
            HashSet<String> methods = new HashSet<String>();
            for (HttpMethodSecurityInfo method : securityInfo.getHttpMethodSecurityInfo()) {
                methods.add(method.getMethod());
                if (method.getRolesAllowed().isEmpty() && method.getEmptyRoleSemantic() == ServletSecurity.EmptyRoleSemantic.PERMIT) continue;
                SecurityConstraint newConstraint = ((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addRolesAllowed(method.getRolesAllowed())).setTransportGuaranteeType(method.getTransportGuaranteeType())).addWebResourceCollection(new WebResourceCollection().addUrlPatterns(mappings).addHttpMethod(method.getMethod()));
                builder.addSecurityConstraint(newConstraint);
            }
            SecurityConstraint newConstraint = ((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addRolesAllowed(securityInfo.getRolesAllowed())).setTransportGuaranteeType(securityInfo.getTransportGuaranteeType())).addWebResourceCollection(new WebResourceCollection().addUrlPatterns(mappings).addHttpMethodOmissions(methods));
            builder.addSecurityConstraint(newConstraint);
        }
        return builder.build();
    }

    private void initializeTempDir(ServletContextImpl servletContext, DeploymentInfo deploymentInfo) {
        if (deploymentInfo.getTempDir() != null) {
            servletContext.setAttribute("javax.servlet.context.tempdir", deploymentInfo.getTempDir());
        } else {
            servletContext.setAttribute("javax.servlet.context.tempdir", new File(SecurityActions.getSystemProperty("java.io.tmpdir")));
        }
    }

    private void initializeMimeMappings(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        HashMap<String, String> mappings = new HashMap<String, String>(MimeMappings.DEFAULT_MIME_MAPPINGS);
        for (MimeMapping mapping : deploymentInfo.getMimeMappings()) {
            mappings.put(mapping.getExtension(), mapping.getMimeType());
        }
        deployment.setMimeExtensionMappings(mappings);
    }

    private void initializeErrorPages(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        HashMap<Integer, String> codes = new HashMap<Integer, String>();
        HashMap<Class<? extends Throwable>, String> exceptions = new HashMap<Class<? extends Throwable>, String>();
        for (ErrorPage page : deploymentInfo.getErrorPages()) {
            if (page.getExceptionType() != null) {
                exceptions.put(page.getExceptionType(), page.getLocation());
                continue;
            }
            codes.put(page.getErrorCode(), page.getLocation());
        }
        deployment.setErrorPages(new ErrorPages(codes, exceptions));
    }

    private ServletPathMatches setupServletChains(ServletContextImpl servletContext, CompositeThreadSetupAction threadSetupAction, ApplicationListeners listeners) {
        ArrayList<Lifecycle> lifecycles = new ArrayList<Lifecycle>();
        ServletChain defaultHandler = null;
        ServletHandler defaultServlet = null;
        LinkedHashMap<String, ManagedFilter> managedFilterMap = new LinkedHashMap<String, ManagedFilter>();
        HashMap allServlets = new HashMap();
        HashMap<String, ServletHandler> extensionServlets = new HashMap<String, ServletHandler>();
        HashMap<String, ServletHandler> pathServlets = new HashMap<String, ServletHandler>();
        HashSet<String> pathMatches = new HashSet<String>();
        HashSet<String> extensionMatches = new HashSet<String>();
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (Map.Entry<String, FilterInfo> entry : deploymentInfo.getFilters().entrySet()) {
            ManagedFilter managedFilter = new ManagedFilter(entry.getValue(), servletContext);
            managedFilterMap.put(entry.getValue().getName(), managedFilter);
            lifecycles.add(managedFilter);
        }
        for (FilterMappingInfo filterMappingInfo : deploymentInfo.getFilterMappings()) {
            if (filterMappingInfo.getMappingType() != FilterMappingInfo.MappingType.URL) continue;
            String string = filterMappingInfo.getMapping();
            if (!string.startsWith("*.")) {
                pathMatches.add(string);
                continue;
            }
            extensionMatches.add(string.substring(2));
        }
        for (Map.Entry entry : deploymentInfo.getServlets().entrySet()) {
            ServletInfo servletInfo = (ServletInfo)entry.getValue();
            ManagedServlet managedServlet = new ManagedServlet(servletInfo, servletContext);
            lifecycles.add(managedServlet);
            ServletHandler handler = new ServletHandler(managedServlet);
            allServlets.put(entry.getKey(), handler);
            for (String path : ((ServletInfo)entry.getValue()).getMappings()) {
                if (path.equals("/")) {
                    pathMatches.add("/*");
                    if (pathServlets.containsKey("/*")) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                    }
                    defaultServlet = handler;
                    defaultHandler = this.servletChain(handler, managedServlet);
                    continue;
                }
                if (!path.startsWith("*.")) {
                    pathMatches.add(path);
                    if (pathServlets.containsKey(path)) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                    }
                    pathServlets.put(path, handler);
                    continue;
                }
                String ext = path.substring(2);
                extensionMatches.add(ext);
                extensionServlets.put(ext, handler);
            }
        }
        if (defaultServlet == null) {
            DefaultServletConfig config = deploymentInfo.getDefaultServletConfig() == null ? new DefaultServletConfig() : deploymentInfo.getDefaultServletConfig();
            DefaultServlet defaultServlet2 = new DefaultServlet(this.deployment, config, deploymentInfo.getWelcomePages());
            ManagedServlet managedServlet = new ManagedServlet(new ServletInfo("io.undertow.DefaultServlet", DefaultServlet.class, new ImmediateInstanceFactory<DefaultServlet>(defaultServlet2)), servletContext);
            lifecycles.add(managedServlet);
            pathMatches.add("/*");
            defaultServlet = new ServletHandler(managedServlet);
            defaultHandler = new ServletChain(defaultServlet, managedServlet);
        }
        ServletPathMatches.Builder builder = ServletPathMatches.builder();
        for (String string : pathMatches) {
            ServletChain initialHandler;
            ServletHandler targetServlet = this.resolveServletForPath(string, pathServlets);
            HashMap<DispatcherType, List<ManagedFilter>> noExtension = new HashMap<DispatcherType, List<ManagedFilter>>();
            HashMap extension = new HashMap();
            for (String ext : extensionMatches) {
                extension.put(ext, new HashMap());
            }
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = (ManagedFilter)managedFilterMap.get(filterMapping.getFilterName());
                if (filterMapping.getMappingType() == FilterMappingInfo.MappingType.SERVLET) {
                    if (targetServlet == null || !filterMapping.getMapping().equals(targetServlet.getManagedServlet().getServletInfo().getName())) continue;
                    DeploymentManagerImpl.addToListMap(noExtension, filterMapping.getDispatcher(), filter);
                    for (Map l : extension.values()) {
                        DeploymentManagerImpl.addToListMap(l, filterMapping.getDispatcher(), filter);
                    }
                    continue;
                }
                if (filterMapping.getMapping().isEmpty() || !filterMapping.getMapping().startsWith("*.")) {
                    if (!this.isFilterApplicable(string, filterMapping.getMapping())) continue;
                    DeploymentManagerImpl.addToListMap(noExtension, filterMapping.getDispatcher(), filter);
                    for (Map l : extension.values()) {
                        DeploymentManagerImpl.addToListMap(l, filterMapping.getDispatcher(), filter);
                    }
                    continue;
                }
                DeploymentManagerImpl.addToListMap((Map)extension.get(filterMapping.getMapping().substring(2)), filterMapping.getDispatcher(), filter);
            }
            if (noExtension.isEmpty()) {
                initialHandler = targetServlet != null ? this.servletChain(targetServlet, targetServlet.getManagedServlet()) : defaultHandler;
            } else {
                FilterHandler handler = targetServlet != null ? new FilterHandler(noExtension, targetServlet) : new FilterHandler(noExtension, defaultServlet);
                initialHandler = this.servletChain(handler, targetServlet == null ? defaultServlet.getManagedServlet() : targetServlet.getManagedServlet());
            }
            if (string.endsWith("/*")) {
                String prefix = string.substring(0, string.length() - 2);
                builder.addPrefixMatch(prefix, initialHandler);
                for (Map.Entry entry : extension.entrySet()) {
                    ServletHandler pathServlet = targetServlet;
                    if (pathServlet == null) {
                        pathServlet = (ServletHandler)extensionServlets.get(entry.getKey());
                    }
                    if (pathServlet == null) {
                        pathServlet = defaultServlet;
                    }
                    HttpHandler handler = pathServlet;
                    if (!((Map)entry.getValue()).isEmpty()) {
                        handler = new FilterHandler((Map)entry.getValue(), handler);
                    }
                    builder.addExtensionMatch(prefix, (String)entry.getKey(), this.servletChain(handler, pathServlet.getManagedServlet()));
                }
                continue;
            }
            if (string.isEmpty()) {
                builder.addExactMatch("/", initialHandler);
                continue;
            }
            builder.addExactMatch(string, initialHandler);
        }
        for (Map.Entry entry : allServlets.entrySet()) {
            HashMap<DispatcherType, List<ManagedFilter>> filters = new HashMap<DispatcherType, List<ManagedFilter>>();
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = (ManagedFilter)managedFilterMap.get(filterMapping.getFilterName());
                if (filterMapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !filterMapping.getMapping().equals(entry.getKey())) continue;
                DeploymentManagerImpl.addToListMap(filters, filterMapping.getDispatcher(), filter);
            }
            if (filters.isEmpty()) {
                builder.addNameMatch((String)entry.getKey(), this.servletChain((HttpHandler)entry.getValue(), ((ServletHandler)entry.getValue()).getManagedServlet()));
                continue;
            }
            builder.addNameMatch((String)entry.getKey(), this.servletChain(new FilterHandler(filters, (HttpHandler)entry.getValue()), ((ServletHandler)entry.getValue()).getManagedServlet()));
        }
        builder.setDefaultServlet(defaultHandler);
        this.deployment.addLifecycleObjects(lifecycles);
        return builder.build();
    }

    private ApplicationListeners createListeners() {
        ArrayList<ManagedListener> managedListeners = new ArrayList<ManagedListener>();
        for (ListenerInfo listener : this.deployment.getDeploymentInfo().getListeners()) {
            managedListeners.add(new ManagedListener(listener));
        }
        return new ApplicationListeners(managedListeners, this.deployment.getServletContext());
    }

    private ServletChain servletChain(HttpHandler next, ManagedServlet managedServlet) {
        HttpHandler servletHandler = new ServletSecurityRoleHandler(next, new RoleMappingManagerImpl(this.deployment.getDeploymentInfo().getPrincipleVsRoleMapping()));
        servletHandler = this.wrapHandlers(servletHandler, managedServlet.getServletInfo().getHandlerChainWrappers());
        servletHandler = this.wrapHandlers(servletHandler, this.deployment.getDeploymentInfo().getDispatchedHandlerChainWrappers());
        return new ServletChain(servletHandler, managedServlet);
    }

    private HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }

    private ServletHandler resolveServletForPath(String path, Map<String, ServletHandler> pathServlets) {
        if (pathServlets.containsKey(path)) {
            return pathServlets.get(path);
        }
        String match = null;
        ServletHandler servlet = null;
        for (Map.Entry<String, ServletHandler> entry : pathServlets.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith("/*")) continue;
            String base = key.substring(0, key.length() - 2);
            if (match != null && base.length() <= match.length() || !path.startsWith(base)) continue;
            match = base;
            servlet = entry.getValue();
        }
        return servlet;
    }

    private boolean isFilterApplicable(String path, String filterPath) {
        if (path.isEmpty()) {
            return filterPath.equals("/*") || filterPath.equals("/");
        }
        if (filterPath.endsWith("/*")) {
            String baseFilterPath = filterPath.substring(0, filterPath.length() - 1);
            return path.startsWith(baseFilterPath);
        }
        return filterPath.equals(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpHandler start() throws ServletException {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            for (Lifecycle object : this.deployment.getLifecycleObjects()) {
                object.start();
            }
            AttachmentHandler<Executor> root = this.deployment.getServletHandler();
            if (this.deployment.getDeploymentInfo().getExecutorFactory() != null) {
                try {
                    this.executor = this.deployment.getDeploymentInfo().getExecutorFactory().createInstance();
                    root = new AttachmentHandler<Executor>(HttpServerExchange.DISPATCH_EXECUTOR, root, this.executor.getInstance());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.deployment.getDeploymentInfo().getExecutorFactory() != null && this.deployment.getDeploymentInfo().getAsyncExecutorFactory() != null) {
                try {
                    this.asyncExecutor = this.deployment.getDeploymentInfo().getAsyncExecutorFactory().createInstance();
                    root = new AttachmentHandler<Executor>(AsyncContextImpl.ASYNC_EXECUTOR, root, this.asyncExecutor.getInstance());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
            this.state = DeploymentManager.State.STARTED;
            AttachmentHandler<Executor> attachmentHandler = root;
            return attachmentHandler;
        }
        finally {
            handle.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ServletException {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            try {
                for (Lifecycle object : this.deployment.getLifecycleObjects()) {
                    object.stop();
                }
            }
            finally {
                if (this.executor != null) {
                    this.executor.release();
                }
                if (this.asyncExecutor != null) {
                    this.asyncExecutor.release();
                }
                this.executor = null;
                this.asyncExecutor = null;
            }
        }
        finally {
            handle.tearDown();
            if (this.executor != null) {
                this.executor.release();
            }
            if (this.asyncExecutor != null) {
                this.asyncExecutor.release();
            }
            this.executor = null;
            this.asyncExecutor = null;
        }
        this.state = DeploymentManager.State.DEPLOYED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy() {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            this.deployment.getApplicationListeners().contextDestroyed();
            this.deployment.getApplicationListeners().stop();
            this.deployment = null;
        }
        finally {
            handle.tearDown();
        }
        this.state = DeploymentManager.State.UNDEPLOYED;
    }

    @Override
    public DeploymentManager.State getState() {
        return this.state;
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }

    private static <K, V> void addToListMap(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(value);
    }
}

