/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class HeaderMap
implements Iterable<HttpString> {
    private final Map<HttpString, Object> values = new TreeMap<HttpString, Object>();

    @Override
    public Iterator<HttpString> iterator() {
        return this.values.keySet().iterator();
    }

    public String getFirst(HttpString headerName) {
        Object value = this.values.get(headerName);
        if (value instanceof List) {
            return (String)((List)value).get(0);
        }
        return (String)value;
    }

    public String getLast(HttpString headerName) {
        Object value = this.values.get(headerName);
        if (value instanceof List) {
            List list = (List)value;
            return (String)list.get(list.size() - 1);
        }
        return (String)value;
    }

    public List<String> get(HttpString headerName) {
        Object value = this.values.get(headerName);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        return Collections.singletonList((String)value);
    }

    public void add(HttpString headerName, String headerValue) {
        Object value = this.values.get(headerName);
        if (value == null) {
            this.values.put(headerName, headerValue);
        } else if (value instanceof List) {
            ((List)value).add(headerValue);
        } else {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add((String)value);
            list.add(headerValue);
            this.values.put(headerName, list);
        }
    }

    public void add(HttpString headerName, long headerValue) {
        this.add(headerName, Long.toString(headerValue));
    }

    public void addAll(HttpString headerName, Collection<String> headerValues) {
        Object value = this.values.get(headerName);
        if (value == null) {
            this.values.put(headerName, new ArrayList<String>(headerValues));
        } else if (value instanceof List) {
            ((List)value).addAll(headerValues);
        } else {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add((String)value);
            list.addAll(headerValues);
            this.values.put(headerName, list);
        }
    }

    public void clear() {
        this.values.clear();
    }

    public Collection<HttpString> getHeaderNames() {
        return new HashSet<HttpString>(this.values.keySet());
    }

    public void put(HttpString headerName, String headerValue) {
        this.values.put(headerName, headerValue);
    }

    public void put(HttpString headerName, long headerValue) {
        this.values.put(headerName, Long.toString(headerValue));
    }

    public void putAll(HttpString headerName, Collection<String> headerValues) {
        ArrayList<String> list = new ArrayList<String>(headerValues);
        this.values.put(headerName, list);
    }

    public Collection<String> remove(HttpString headerName) {
        Object value = this.values.remove(headerName);
        if (value instanceof List) {
            return (Collection)value;
        }
        return Collections.singletonList((String)value);
    }

    public void lock() {
    }

    public boolean contains(HttpString headerName) {
        Object value = this.values.get(headerName);
        return value != null;
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "HeaderMap{values=" + this.values + '}';
    }
}

