/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.xnio.Buffers;

public class ResponseCachingSender
implements Sender {
    private final Sender delegate;
    private final DirectBufferCache.CacheEntry cacheEntry;
    private final long length;
    private long written;

    public ResponseCachingSender(Sender delegate, DirectBufferCache.CacheEntry cacheEntry, long length) {
        this.delegate = delegate;
        this.cacheEntry = cacheEntry;
        this.length = length;
    }

    @Override
    public void send(ByteBuffer src, IoCallback callback) {
        ByteBuffer origSrc = src.duplicate();
        this.delegate.send(src, callback);
        this.handleUpdate(origSrc);
    }

    @Override
    public void send(ByteBuffer[] srcs, IoCallback callback) {
        ByteBuffer[] origSrc = new ByteBuffer[srcs.length];
        long total = 0L;
        for (int i = 0; i < srcs.length; ++i) {
            origSrc[i] = srcs[i].duplicate();
            total += (long)origSrc[i].remaining();
        }
        this.delegate.send(srcs, callback);
        this.handleUpdate(origSrc, total);
    }

    @Override
    public void send(ByteBuffer src) {
        ByteBuffer origSrc = src.duplicate();
        this.delegate.send(src);
        this.handleUpdate(origSrc);
    }

    @Override
    public void send(ByteBuffer[] srcs) {
        ByteBuffer[] origSrc = new ByteBuffer[srcs.length];
        long total = 0L;
        for (int i = 0; i < srcs.length; ++i) {
            origSrc[i] = srcs[i].duplicate();
            total += (long)origSrc[i].remaining();
        }
        this.delegate.send(srcs);
        this.handleUpdate(origSrc, total);
    }

    @Override
    public void send(String data, IoCallback callback) {
        this.delegate.send(data, callback);
        try {
            this.handleUpdate(ByteBuffer.wrap(data.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        this.delegate.send(data, charset, callback);
        this.handleUpdate(ByteBuffer.wrap(data.getBytes(charset)));
    }

    @Override
    public void send(String data) {
        this.delegate.send(data);
        try {
            this.handleUpdate(ByteBuffer.wrap(data.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void send(String data, Charset charset) {
        this.delegate.send(data, charset);
        this.handleUpdate(ByteBuffer.wrap(data.getBytes(charset)));
    }

    @Override
    public void close(IoCallback callback) {
        if (this.written != this.length) {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        this.delegate.close();
    }

    @Override
    public void close() {
        if (this.written != this.length) {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        this.delegate.close();
    }

    private void handleUpdate(ByteBuffer origSrc) {
        LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
        ByteBuffer[] buffers = new ByteBuffer[pooled.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = pooled[i].getResource();
        }
        this.written += (long)Buffers.copy(buffers, 0, buffers.length, origSrc);
        if (this.written == this.length) {
            for (ByteBuffer buffer : buffers) {
                buffer.flip();
            }
            this.cacheEntry.enable();
        }
    }

    private void handleUpdate(ByteBuffer[] origSrc, long totalWritten) {
        LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
        ByteBuffer[] buffers = new ByteBuffer[pooled.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = pooled[i].getResource();
        }
        long leftToCopy = totalWritten;
        for (int i = 0; i < origSrc.length; ++i) {
            ByteBuffer buf = origSrc[i];
            if ((long)buf.remaining() > leftToCopy) {
                buf.limit((int)((long)buf.position() + leftToCopy));
            }
            Buffers.copy(buffers, 0, buffers.length, buf);
            if ((leftToCopy -= (long)buf.remaining()) == 0L) break;
        }
        this.written += totalWritten;
        if (this.written == this.length) {
            for (ByteBuffer buffer : buffers) {
                buffer.flip();
            }
            this.cacheEntry.enable();
        }
    }
}

