/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class SessionListenerBridge
implements SessionListener {
    private final ThreadSetupAction threadSetup;
    private final ApplicationListeners applicationListeners;
    private final ServletContext servletContext;

    public SessionListenerBridge(ThreadSetupAction threadSetup, ApplicationListeners applicationListeners, ServletContext servletContext) {
        this.threadSetup = threadSetup;
        this.applicationListeners = applicationListeners;
        this.servletContext = servletContext;
    }

    @Override
    public void sessionCreated(Session session, HttpServerExchange exchange) {
        HttpSessionImpl httpSession = HttpSessionImpl.forSession(session, this.servletContext, true);
        this.applicationListeners.sessionCreated(httpSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        ThreadSetupAction.Handle handle = null;
        try {
            HttpSessionImpl httpSession = HttpSessionImpl.forSession(session, this.servletContext, false);
            if (reason == SessionListener.SessionDestroyedReason.TIMEOUT) {
                handle = this.threadSetup.setup(exchange);
            }
            for (String attribute : session.getAttributeNames()) {
                session.removeAttribute(attribute);
            }
            this.applicationListeners.sessionDestroyed(httpSession);
        }
        finally {
            ServletRequestContext current;
            if (handle != null) {
                handle.tearDown();
            }
            if ((current = ServletRequestContext.current()) != null) {
                current.setSession(null);
            }
        }
    }

    @Override
    public void attributeAdded(Session session, String name, Object value) {
        HttpSessionImpl httpSession = HttpSessionImpl.forSession(session, this.servletContext, false);
        this.applicationListeners.httpSessionAttributeAdded(httpSession, name, value);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(httpSession, name, value));
        }
    }

    @Override
    public void attributeUpdated(Session session, String name, Object value, Object old) {
        HttpSessionImpl httpSession = HttpSessionImpl.forSession(session, this.servletContext, false);
        if (old != value) {
            if (old instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent(httpSession, name, old));
            }
            this.applicationListeners.httpSessionAttributeReplaced(httpSession, name, old);
        }
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(httpSession, name, value));
        }
    }

    @Override
    public void attributeRemoved(Session session, String name, Object old) {
        HttpSessionImpl httpSession = HttpSessionImpl.forSession(session, this.servletContext, false);
        if (old != null) {
            this.applicationListeners.httpSessionAttributeRemoved(httpSession, name, old);
            if (old instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent(httpSession, name, old));
            }
        }
    }
}

