/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;

public class FilterRegistrationImpl
implements FilterRegistration,
FilterRegistration.Dynamic {
    private final FilterInfo filterInfo;
    private final Deployment deployment;

    public FilterRegistrationImpl(FilterInfo filterInfo, Deployment deployment) {
        this.filterInfo = filterInfo;
        this.deployment = deployment;
    }

    @Override
    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (String servlet : servletNames) {
            if (isMatchAfter) {
                if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                    deploymentInfo.addFilterServletNameMapping(this.filterInfo.getName(), servlet, DispatcherType.REQUEST);
                    continue;
                }
                for (DispatcherType dispatcher : dispatcherTypes) {
                    deploymentInfo.addFilterServletNameMapping(this.filterInfo.getName(), servlet, dispatcher);
                }
                continue;
            }
            if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                deploymentInfo.insertFilterServletNameMapping(0, this.filterInfo.getName(), servlet, DispatcherType.REQUEST);
                continue;
            }
            for (DispatcherType dispatcher : dispatcherTypes) {
                deploymentInfo.insertFilterServletNameMapping(0, this.filterInfo.getName(), servlet, dispatcher);
            }
        }
        this.deployment.getServletPaths().invalidate();
    }

    @Override
    public Collection<String> getServletNameMappings() {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        ArrayList<String> ret = new ArrayList<String>();
        for (FilterMappingInfo mapping : deploymentInfo.getFilterMappings()) {
            if (mapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !mapping.getFilterName().equals(this.filterInfo.getName())) continue;
            ret.add(mapping.getMapping());
        }
        return ret;
    }

    @Override
    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (String url : urlPatterns) {
            if (isMatchAfter) {
                if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                    deploymentInfo.addFilterUrlMapping(this.filterInfo.getName(), url, DispatcherType.REQUEST);
                    continue;
                }
                for (DispatcherType dispatcher : dispatcherTypes) {
                    deploymentInfo.addFilterUrlMapping(this.filterInfo.getName(), url, dispatcher);
                }
                continue;
            }
            if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
                deploymentInfo.insertFilterUrlMapping(0, this.filterInfo.getName(), url, DispatcherType.REQUEST);
                continue;
            }
            for (DispatcherType dispatcher : dispatcherTypes) {
                deploymentInfo.insertFilterUrlMapping(0, this.filterInfo.getName(), url, dispatcher);
            }
        }
        this.deployment.getServletPaths().invalidate();
    }

    @Override
    public Collection<String> getUrlPatternMappings() {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        ArrayList<String> ret = new ArrayList<String>();
        for (FilterMappingInfo mapping : deploymentInfo.getFilterMappings()) {
            if (mapping.getMappingType() != FilterMappingInfo.MappingType.URL || !mapping.getFilterName().equals(this.filterInfo.getName())) continue;
            ret.add(mapping.getMapping());
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.filterInfo.getName();
    }

    @Override
    public String getClassName() {
        return this.filterInfo.getFilterClass().getName();
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.filterInfo.getInitParams().containsKey(name)) {
            return false;
        }
        this.filterInfo.addInitParam(name, value);
        return true;
    }

    @Override
    public String getInitParameter(String name) {
        return this.filterInfo.getInitParams().get(name);
    }

    @Override
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (this.setInitParameter(entry.getKey(), entry.getValue())) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    @Override
    public Map<String, String> getInitParameters() {
        return this.filterInfo.getInitParams();
    }

    @Override
    public void setAsyncSupported(boolean isAsyncSupported) {
        this.filterInfo.setAsyncSupported(isAsyncSupported);
    }
}

