/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.security.basic;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;

class MapIdentityManager
implements IdentityManager {
    private final Map<String, char[]> users;

    public MapIdentityManager(Map<String, char[]> users) {
        this.users = users;
    }

    @Override
    public Account verify(Account account) {
        return account;
    }

    @Override
    public Account verify(String id, Credential credential) {
        Account account = this.getAccount(id);
        if (account != null && this.verifyCredential(account, credential)) {
            return account;
        }
        return null;
    }

    @Override
    public Account verify(Credential credential) {
        return null;
    }

    private boolean verifyCredential(Account account, Credential credential) {
        if (credential instanceof PasswordCredential) {
            char[] password = ((PasswordCredential)credential).getPassword();
            char[] expectedPassword = this.users.get(account.getPrincipal().getName());
            return Arrays.equals(password, expectedPassword);
        }
        return false;
    }

    @Override
    public char[] getPassword(Account account) {
        return this.users.get(account.getPrincipal().getName());
    }

    @Override
    public byte[] getHash(Account account) {
        return null;
    }

    @Override
    public Account getAccount(final String id) {
        if (this.users.containsKey(id)) {
            return new Account(){
                private final Principal principal = new Principal(){

                    @Override
                    public String getName() {
                        return id;
                    }
                };

                @Override
                public Principal getPrincipal() {
                    return this.principal;
                }

                @Override
                public boolean isUserInGroup(String group) {
                    return false;
                }
            };
        }
        return null;
    }
}

