/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.api;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.util.AttachmentKey;
import java.util.List;

public interface SecurityContext {
    public static final AttachmentKey<SecurityContext> ATTACHMENT_KEY = AttachmentKey.create(SecurityContext.class);

    public boolean authenticate();

    public boolean login(String var1, String var2);

    public void logout();

    public void setAuthenticationRequired();

    public void addAuthenticationMechanism(AuthenticationMechanism var1);

    public List<AuthenticationMechanism> getAuthenticationMechanisms();

    public boolean isAuthenticated();

    public Account getAuthenticatedAccount();

    public String getMechanismName();

    public IdentityManager getIdentityManager();

    public void authenticationComplete(Account var1, String var2);

    public void authenticationFailed(String var1, String var2);

    public void registerNotificationReceiver(NotificationReceiver var1);

    public void removeNotificationReceiver(NotificationReceiver var1);

    public static class AuthenticationResult {
        private final AuthenticationMechanism.AuthenticationMechanismOutcome outcome;
        private final Runnable sendChallengeTask;

        public AuthenticationResult(AuthenticationMechanism.AuthenticationMechanismOutcome outcome, Runnable sendChallengeTask) {
            this.outcome = outcome;
            this.sendChallengeTask = sendChallengeTask;
        }

        public AuthenticationMechanism.AuthenticationMechanismOutcome getOutcome() {
            return this.outcome;
        }

        public Runnable getSendChallengeTask() {
            return this.sendChallengeTask;
        }
    }
}

