/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.handlers.AbstractConfidentialityHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.net.URI;
import java.net.URISyntaxException;

public class SinglePortConfidentialityHandler
extends AbstractConfidentialityHandler {
    private final int redirectPort;

    public SinglePortConfidentialityHandler(HttpHandler next, int redirectPort) {
        super(next);
        this.redirectPort = redirectPort == 443 ? -1 : redirectPort;
    }

    @Override
    protected URI getRedirectURI(HttpServerExchange exchange) throws URISyntaxException {
        return this.getRedirectURI(exchange, this.redirectPort);
    }

    protected URI getRedirectURI(HttpServerExchange exchange, int port) throws URISyntaxException {
        String host = exchange.getRequestHeaders().getFirst(Headers.HOST);
        host = host == null ? exchange.getDestinationAddress().getAddress().getHostAddress() : (host.startsWith("[") ? host.substring(1, host.indexOf(93)) : host.substring(0, host.indexOf(58)));
        String queryString = exchange.getQueryString();
        return new URI("https", null, host, port, exchange.getRequestURI(), queryString == null || queryString.length() == 0 ? null : queryString, null);
    }
}

