/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.io.Sender;
import io.undertow.io.UndertowInputStream;
import io.undertow.io.UndertowOutputStream;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.SenderImpl;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConduitFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.ImmediateConduitFactory;
import io.undertow.util.Protocols;
import io.undertow.util.SecureHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkChannelWrappingConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceChannelWrappingConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class HttpServerExchange
extends AbstractAttachable {
    public static final AttachmentKey<Executor> DISPATCH_EXECUTOR = AttachmentKey.create(Executor.class);
    public static final AttachmentKey<Runnable> DISPATCH_TASK = AttachmentKey.create(Runnable.class);
    private static final Logger log = Logger.getLogger(HttpServerExchange.class);
    private final HttpServerConnection connection;
    private final HeaderMap requestHeaders = new HeaderMap();
    private final HeaderMap responseHeaders = new HeaderMap();
    private final List<ExchangeCompletionListener> exchangeCompleteListeners = new ArrayList<ExchangeCompletionListener>(2);
    private final Deque<DefaultResponseListener> defaultResponseListeners = new ArrayDeque<DefaultResponseListener>(1);
    private Map<String, Deque<String>> queryParameters;
    private final StreamSinkChannel underlyingResponseChannel;
    private final StreamSourceChannel underlyingRequestChannel;
    private StreamSinkChannel responseChannel;
    private StreamSourceChannel requestChannel;
    private BlockingHttpExchange blockingHttpExchange;
    private HttpString protocol;
    private int state = 200;
    private HttpString requestMethod;
    private String requestScheme;
    private String requestURI;
    private String requestPath;
    private String canonicalPath;
    private String relativePath;
    private String resolvedPath = "";
    private String queryString;
    private List<ConduitWrapper<StreamSourceConduit>> requestWrappers = new ArrayList<ConduitWrapper<StreamSourceConduit>>(3);
    private List<ConduitWrapper<StreamSinkConduit>> responseWrappers = new ArrayList<ConduitWrapper<StreamSinkConduit>>(3);
    private static final int MASK_RESPONSE_CODE = Bits.intBitMask(0, 9);
    private static final int FLAG_RESPONSE_SENT = 1024;
    private static final int FLAG_RESPONSE_TERMINATED = 2048;
    private static final int FLAG_REQUEST_TERMINATED = 4096;
    private static final int FLAG_PERSISTENT = 16384;
    private static final int FLAG_DISPATCHED = 32768;
    private static final int FLAG_IN_IO_THREAD = 65536;
    private static final int FLAG_IN_CALL = 131072;

    public HttpServerExchange(HttpServerConnection connection, StreamSourceChannel requestChannel, StreamSinkChannel responseChannel) {
        this.connection = connection;
        this.underlyingRequestChannel = requestChannel;
        this.underlyingResponseChannel = connection == null ? null : responseChannel;
    }

    public HttpString getProtocol() {
        return this.protocol;
    }

    public void setProtocol(HttpString protocol) {
        this.protocol = protocol;
    }

    public boolean isHttp09() {
        return this.protocol.equals(Protocols.HTTP_0_9);
    }

    public boolean isHttp10() {
        return this.protocol.equals(Protocols.HTTP_1_0);
    }

    public boolean isHttp11() {
        return this.protocol.equals(Protocols.HTTP_1_1);
    }

    public HttpString getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(HttpString requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getRequestScheme() {
        return this.requestScheme;
    }

    public void setRequestScheme(String requestScheme) {
        this.requestScheme = requestScheme;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    void setParsedRequestPath(String requestPath) {
        this.relativePath = requestPath;
        this.requestPath = requestPath;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public void setResolvedPath(String resolvedPath) {
        this.resolvedPath = resolvedPath;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public void setCanonicalPath(String canonicalPath) {
        this.canonicalPath = canonicalPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRequestURL() {
        String host = this.getRequestHeaders().getFirst(Headers.HOST);
        if (host == null) {
            host = this.getDestinationAddress().getAddress().getHostAddress();
        }
        return this.getRequestScheme() + "://" + host + this.getRequestURI();
    }

    public HttpServerConnection getConnection() {
        return this.connection;
    }

    public boolean isPersistent() {
        return Bits.anyAreSet(this.state, 16384);
    }

    void setInIoThread(boolean inIoThread) {
        this.state = inIoThread ? (this.state |= 0x10000) : (this.state &= 0xFFFEFFFF);
    }

    public boolean isInIoThread() {
        return Bits.anyAreSet(this.state, 65536);
    }

    public boolean isUpgrade() {
        return this.getResponseCode() == 101;
    }

    public void setPersistent(boolean persistent) {
        this.state = persistent ? (this.state |= 0x4000) : (this.state &= 0xFFFFBFFF);
    }

    public boolean isDispatched() {
        return Bits.anyAreSet(this.state, 32768);
    }

    void clearDispatched() {
        this.state &= 0xFFFF7FFF;
        this.removeAttachment(DISPATCH_EXECUTOR);
        this.removeAttachment(DISPATCH_TASK);
    }

    public void dispatch() {
        this.state |= 0x8000;
    }

    public void dispatch(Runnable runnable) {
        this.dispatch(null, runnable);
    }

    public void dispatch(Executor executor, Runnable runnable) {
        if (this.isInCall()) {
            this.state |= 0x8000;
            if (executor != null) {
                this.putAttachment(DISPATCH_EXECUTOR, executor);
            }
            this.putAttachment(DISPATCH_TASK, runnable);
        } else if (executor == null) {
            this.getConnection().getWorker().execute(runnable);
        } else {
            executor.execute(runnable);
        }
    }

    public void dispatch(HttpHandler handler) {
        this.dispatch(null, handler);
    }

    public void dispatch(Executor executor, final HttpHandler handler) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HttpHandlers.executeRootHandler(handler, HttpServerExchange.this, false);
            }
        };
        this.dispatch(executor, runnable);
    }

    public void setDispatchExecutor(Executor executor) {
        if (executor == null) {
            this.removeAttachment(DISPATCH_EXECUTOR);
        } else {
            this.putAttachment(DISPATCH_EXECUTOR, executor);
        }
    }

    public Executor getDispatchExecutor() {
        return this.getAttachment(DISPATCH_EXECUTOR);
    }

    boolean isInCall() {
        return Bits.anyAreSet(this.state, 131072);
    }

    void setInCall(boolean value) {
        this.state = value ? (this.state |= 0x20000) : (this.state &= 0xFFFDFFFF);
    }

    public void upgradeChannel(ExchangeCompletionListener upgradeCompleteListener) {
        this.setResponseCode(101);
        this.exchangeCompleteListeners.add(0, upgradeCompleteListener);
    }

    public void upgradeChannel(String productName, ExchangeCompletionListener upgradeCompleteListener) {
        this.setResponseCode(101);
        HeaderMap headers = this.getResponseHeaders();
        headers.add(Headers.UPGRADE, productName);
        headers.add(Headers.CONNECTION, "Upgrade");
        this.exchangeCompleteListeners.add(0, upgradeCompleteListener);
    }

    public void addExchangeCompleteListener(ExchangeCompletionListener listener) {
        this.exchangeCompleteListeners.add(listener);
    }

    public void addDefaultResponseListener(DefaultResponseListener listener) {
        this.defaultResponseListeners.add(listener);
    }

    public InetSocketAddress getSourceAddress() {
        return this.connection.getPeerAddress(InetSocketAddress.class);
    }

    public InetSocketAddress getDestinationAddress() {
        return this.connection.getLocalAddress(InetSocketAddress.class);
    }

    public HeaderMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public HeaderMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Deque<String>> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new SecureHashMap<String, Deque<String>>(0);
        }
        return this.queryParameters;
    }

    public void addQueryParam(String name, String param) {
        Deque<String> list;
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.queryParameters.get(name)) == null) {
            list = new ArrayDeque<String>();
            this.queryParameters.put(name, list);
        }
        list.add(param);
    }

    public boolean isResponseStarted() {
        return Bits.allAreSet(this.state, 1024);
    }

    public StreamSourceChannel getRequestChannel() {
        List<ConduitWrapper<StreamSourceConduit>> wrappers = this.requestWrappers;
        this.requestWrappers = null;
        if (wrappers == null) {
            return null;
        }
        ConduitFactory<StreamSourceConduit> factory = new ImmediateConduitFactory<StreamSourceChannelWrappingConduit>(new StreamSourceChannelWrappingConduit(this.underlyingRequestChannel));
        for (final ConduitWrapper<StreamSourceConduit> wrapper : wrappers) {
            final ImmediateConduitFactory<StreamSourceChannelWrappingConduit> oldFactory = factory;
            factory = new ConduitFactory<StreamSourceConduit>(){

                @Override
                public StreamSourceConduit create() {
                    return (StreamSourceConduit)wrapper.wrap(oldFactory, HttpServerExchange.this);
                }
            };
        }
        this.requestChannel = new ConduitStreamSourceChannel(this.underlyingRequestChannel, new ReadDispatchConduit((StreamSourceConduit)factory.create()));
        return this.requestChannel;
    }

    public boolean isRequestChannelAvailable() {
        return this.requestWrappers != null;
    }

    public boolean isComplete() {
        return Bits.allAreSet(this.state, 6144);
    }

    public void terminateRequest() {
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 4096)) {
            return;
        }
        this.state = oldVal | 0x1000;
        if (Bits.anyAreSet(oldVal, 2048)) {
            this.invokeExchangeCompleteListeners();
        }
    }

    private void invokeExchangeCompleteListeners() {
        if (!this.exchangeCompleteListeners.isEmpty()) {
            int i = this.exchangeCompleteListeners.size() - 1;
            ExchangeCompletionListener next = this.exchangeCompleteListeners.get(i);
            next.exchangeEvent(this, new ExchangeCompleteNextListener(this.exchangeCompleteListeners, this, i));
        }
    }

    public void ungetRequestBytes(Pooled<ByteBuffer> unget) {
        if (this.connection.getExtraBytes() == null) {
            this.connection.setExtraBytes(unget);
        } else {
            Pooled<ByteBuffer> eb = this.connection.getExtraBytes();
            ByteBuffer buf = eb.getResource();
            ByteBuffer ugBuffer = unget.getResource();
            if (ugBuffer.limit() - ugBuffer.remaining() > buf.remaining()) {
                ugBuffer.compact();
                ugBuffer.put(buf);
                ugBuffer.flip();
                eb.free();
                this.connection.setExtraBytes(unget);
            } else {
                byte[] data = new byte[ugBuffer.remaining() + buf.remaining()];
                int first = ugBuffer.remaining();
                ugBuffer.get(data);
                buf.get(data, first, buf.remaining());
                eb.free();
                unget.free();
                final ByteBuffer newBuffer = ByteBuffer.wrap(data);
                this.connection.setExtraBytes(new Pooled<ByteBuffer>(){

                    @Override
                    public void discard() {
                    }

                    @Override
                    public void free() {
                    }

                    @Override
                    public ByteBuffer getResource() throws IllegalStateException {
                        return newBuffer;
                    }
                });
            }
        }
    }

    public StreamSinkChannel getResponseChannel() {
        List<ConduitWrapper<StreamSinkConduit>> wrappers = this.responseWrappers;
        this.responseWrappers = null;
        if (wrappers == null) {
            return null;
        }
        ConduitFactory<StreamSinkConduit> factory = new ImmediateConduitFactory<StreamSinkChannelWrappingConduit>(new StreamSinkChannelWrappingConduit(this.underlyingResponseChannel));
        for (final ConduitWrapper<StreamSinkConduit> wrapper : wrappers) {
            final ImmediateConduitFactory<StreamSinkChannelWrappingConduit> oldFactory = factory;
            factory = new ConduitFactory<StreamSinkConduit>(){

                @Override
                public StreamSinkConduit create() {
                    return (StreamSinkConduit)wrapper.wrap(oldFactory, HttpServerExchange.this);
                }
            };
        }
        ConduitStreamSinkChannel channel = new ConduitStreamSinkChannel(this.underlyingResponseChannel, new WriteDispatchConduit((StreamSinkConduit)factory.create()));
        this.responseChannel = channel;
        this.startResponse();
        return channel;
    }

    public Sender getResponseSender() {
        StreamSinkChannel channel = this.getResponseChannel();
        if (channel == null) {
            return null;
        }
        return new SenderImpl(channel, this);
    }

    public boolean isResponseChannelAvailable() {
        return this.responseWrappers != null;
    }

    public void setResponseCode(int responseCode) {
        if (responseCode < 0 || responseCode > 999) {
            throw new IllegalArgumentException("Invalid response code");
        }
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.state = oldVal & ~MASK_RESPONSE_CODE | responseCode & MASK_RESPONSE_CODE;
    }

    public void addRequestWrapper(ConduitWrapper<StreamSourceConduit> wrapper) {
        List<ConduitWrapper<StreamSourceConduit>> wrappers = this.requestWrappers;
        if (wrappers == null) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        wrappers.add(wrapper);
    }

    public void addResponseWrapper(ConduitWrapper<StreamSinkConduit> wrapper) {
        List<ConduitWrapper<StreamSinkConduit>> wrappers = this.responseWrappers;
        if (wrappers == null) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        wrappers.add(wrapper);
    }

    public BlockingHttpExchange startBlocking() {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = new DefaultBlockingHttpExchange(this);
        return old;
    }

    public BlockingHttpExchange startBlocking(BlockingHttpExchange httpExchange) {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = httpExchange;
        return old;
    }

    public InputStream getInputStream() {
        if (this.blockingHttpExchange == null) {
            throw UndertowMessages.MESSAGES.startBlockingHasNotBeenCalled();
        }
        return this.blockingHttpExchange.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this.blockingHttpExchange == null) {
            throw UndertowMessages.MESSAGES.startBlockingHasNotBeenCalled();
        }
        return this.blockingHttpExchange.getOutputStream();
    }

    public int getResponseCode() {
        return this.state & MASK_RESPONSE_CODE;
    }

    void terminateResponse() {
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 2048)) {
            return;
        }
        this.state = oldVal | 0x800;
        if (Bits.anyAreSet(oldVal, 4096)) {
            this.invokeExchangeCompleteListeners();
        }
    }

    public void endExchange() {
        while (!this.defaultResponseListeners.isEmpty()) {
            DefaultResponseListener listener = this.defaultResponseListeners.poll();
            try {
                if (!listener.handleDefaultResponse(this)) continue;
                return;
            }
            catch (Exception e) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception running default response listener", e);
            }
        }
        final int state = this.state;
        if (Bits.anyAreClear(state, 4096)) {
            if (this.requestChannel == null) {
                this.getRequestChannel();
            }
            int totalRead = 0;
            block5: while (true) {
                try {
                    long read;
                    do {
                        read = Channels.drain(this.requestChannel, Long.MAX_VALUE);
                        totalRead = (int)((long)totalRead + read);
                        if (read != 0L) continue;
                        if (this.getResponseCode() == 417 && totalRead <= 0) break block5;
                        this.requestChannel.getReadSetter().set(ChannelListeners.drainListener(Long.MAX_VALUE, new ChannelListener<StreamSourceChannel>(){

                            @Override
                            public void handleEvent(StreamSourceChannel channel) {
                                if (Bits.anyAreClear(state, 2048)) {
                                    HttpServerExchange.this.closeAndFlushResponse();
                                }
                            }
                        }, new ChannelExceptionHandler<StreamSourceChannel>(){

                            @Override
                            public void handleException(StreamSourceChannel channel, IOException e) {
                                UndertowLogger.REQUEST_LOGGER.debug("Exception draining request stream", e);
                                IoUtils.safeClose((Closeable)HttpServerExchange.this.connection.getChannel());
                            }
                        }));
                        this.requestChannel.resumeReads();
                        return;
                    } while (read != -1L);
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_LOGGER.debug("Exception draining request stream", e);
                    IoUtils.safeClose((Closeable)this.connection.getChannel());
                    continue;
                }
                break;
            }
        }
        if (Bits.anyAreClear(state, 2048)) {
            this.closeAndFlushResponse();
        }
    }

    private void closeAndFlushResponse() {
        try {
            if (this.isResponseChannelAvailable()) {
                this.getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                this.getResponseChannel();
            }
            if (this.responseChannel.isOpen()) {
                this.responseChannel.shutdownWrites();
            }
            if (!this.responseChannel.flush()) {
                this.responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                    @Override
                    public void handleEvent(StreamSinkChannel channel) {
                        channel.suspendWrites();
                        channel.getWriteSetter().set(null);
                    }
                }, new ChannelExceptionHandler<Channel>(){

                    @Override
                    public void handleException(Channel channel, IOException exception) {
                        UndertowLogger.REQUEST_LOGGER.debug("Exception ending request", exception);
                        IoUtils.safeClose((Closeable)HttpServerExchange.this.connection.getChannel());
                    }
                }));
                this.responseChannel.resumeWrites();
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_LOGGER.debug("Exception ending request", e);
            IoUtils.safeClose((Closeable)this.connection.getChannel());
        }
    }

    void startResponse() throws IllegalStateException {
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.state = oldVal | 0x400;
        log.tracef("Starting to write response for %s using channel %s", (Object)this, (Object)this.underlyingResponseChannel);
        HeaderMap responseHeaders = this.responseHeaders;
        responseHeaders.lock();
    }

    public XnioExecutor getIoThread() {
        return this.underlyingResponseChannel.getIoThread();
    }

    private class ReadDispatchConduit
    extends AbstractStreamSourceConduit<StreamSourceConduit>
    implements StreamSourceConduit,
    Runnable {
        protected ReadDispatchConduit(StreamSourceConduit next) {
            super(next);
        }

        @Override
        public void resumeReads() {
            if (HttpServerExchange.this.isInCall()) {
                HttpServerExchange.this.dispatch(this);
            } else {
                super.resumeReads();
            }
        }

        @Override
        public void run() {
            super.resumeReads();
        }
    }

    private class WriteDispatchConduit
    extends AbstractStreamSinkConduit<StreamSinkConduit>
    implements StreamSinkConduit,
    Runnable {
        private boolean wakeup;

        protected WriteDispatchConduit(StreamSinkConduit next) {
            super(next);
        }

        @Override
        public void resumeWrites() {
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = false;
                HttpServerExchange.this.dispatch(this);
            } else {
                super.resumeWrites();
            }
        }

        @Override
        public void wakeupWrites() {
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = true;
                HttpServerExchange.this.dispatch(this);
            } else {
                super.wakeupWrites();
            }
        }

        @Override
        public void run() {
            if (this.wakeup) {
                super.wakeupWrites();
            } else {
                super.resumeWrites();
            }
        }
    }

    private static class DefaultBlockingHttpExchange
    implements BlockingHttpExchange {
        private InputStream inputStream;
        private OutputStream outputStream;
        private final HttpServerExchange exchange;

        DefaultBlockingHttpExchange(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public InputStream getInputStream() {
            if (this.inputStream == null) {
                this.inputStream = new UndertowInputStream(this.exchange);
            }
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.outputStream == null) {
                this.outputStream = new UndertowOutputStream(this.exchange);
            }
            return this.outputStream;
        }
    }

    private static class ExchangeCompleteNextListener
    implements ExchangeCompletionListener.NextListener {
        private final List<ExchangeCompletionListener> list;
        private final HttpServerExchange exchange;
        private int i;

        public ExchangeCompleteNextListener(List<ExchangeCompletionListener> list, HttpServerExchange exchange, int i) {
            this.list = list;
            this.exchange = exchange;
            this.i = i;
        }

        @Override
        public void proceed() {
            if (--this.i >= 0) {
                ExchangeCompletionListener next = this.list.get(this.i);
                next.exchangeEvent(this.exchange, this);
            }
        }
    }
}

