/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

public class URLDecodingHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private String charset = "UTF-8";

    public URLDecodingHandler() {
    }

    public URLDecodingHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        try {
            exchange.setRelativePath(URLDecoder.decode(exchange.getRelativePath(), this.charset));
            exchange.setCanonicalPath(URLDecoder.decode(exchange.getRequestPath(), this.charset));
            for (Map.Entry<String, Deque<String>> entry : exchange.getQueryParameters().entrySet()) {
                Deque<String> value = entry.getValue();
                ArrayDeque<String> newValue = new ArrayDeque<String>(value.size());
                for (String v : value) {
                    newValue.push(URLDecoder.decode(v, this.charset));
                }
                entry.setValue(newValue);
            }
            this.next.handleRequest(exchange);
        }
        catch (UnsupportedEncodingException e) {
            UndertowLogger.REQUEST_LOGGER.debug("Unsupported encoding", e);
            exchange.setResponseCode(500);
            exchange.endExchange();
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public URLDecodingHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public URLDecodingHandler setCharset(String charset) {
        this.charset = charset;
        return this;
    }
}

