/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class FileResource
implements Resource {
    private static final Logger log = Logger.getLogger("io.undertow.server.resources.file");
    private final Path file;

    public FileResource(Path file) {
        this.file = file;
    }

    @Override
    public Date getLastModified() {
        try {
            return new Date(Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis());
        }
        catch (IOException e) {
            return new Date(0L);
        }
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        return this.file.getFileName().toString();
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.file, new LinkOption[0]);
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.file);){
            for (Path child : stream) {
                resources.add(new FileResource(child));
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            UndertowLogger.ROOT_LOGGER.warn("could not list directory", x);
        }
        return resources;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.file.getFileName().toString();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serve(HttpServerExchange exchange) {
        FileChannel fileChannel;
        try {
            try {
                fileChannel = exchange.getConnection().getWorker().getXnio().openFile(this.file.toFile(), FileAccess.READ_ONLY);
            }
            catch (FileNotFoundException e) {
                exchange.setResponseCode(404);
                exchange.endExchange();
                return;
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_LOGGER.exceptionReadingFile(this.file, e);
            exchange.setResponseCode(500);
            exchange.endExchange();
            return;
        }
        StreamSinkChannel response = exchange.getResponseChannel();
        response.getCloseSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<Channel>(){

            @Override
            public void handleEvent(Channel channel) {
                IoUtils.safeClose((Closeable)fileChannel);
            }
        });
        try {
            log.tracef("Serving file %s (blocking)", (Object)fileChannel);
            Channels.transferBlocking(response, fileChannel, 0L, Files.size(this.file));
            log.tracef("Finished serving %s, shutting down (blocking)", (Object)fileChannel);
            response.shutdownWrites();
            log.tracef("Finished serving %s, flushing (blocking)", (Object)fileChannel);
            Channels.flushBlocking(response);
            log.tracef("Finished serving %s (complete)", (Object)fileChannel);
            exchange.endExchange();
        }
        catch (IOException ignored) {
            log.tracef("Failed to serve %s: %s", (Object)fileChannel, (Object)ignored);
            exchange.endExchange();
            IoUtils.safeClose((Closeable)response);
        }
        finally {
            IoUtils.safeClose((Closeable)fileChannel);
        }
    }

    @Override
    public Long getContentLength() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public Resource getIndexResource(List<String> possible) {
        for (String possibility : possible) {
            Path index = this.file.resolve(possibility);
            if (!Files.exists(index, new LinkOption[0])) continue;
            return new FileResource(index);
        }
        return null;
    }
}

