/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.spec.ServletCookieAdaptor;
import io.undertow.servlet.spec.ServletOutputStreamImpl;
import io.undertow.servlet.spec.ServletPrintWriter;
import io.undertow.servlet.spec.ServletPrintWriterDelegate;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;

public final class HttpServletResponseImpl
implements HttpServletResponse {
    public static final AttachmentKey<ServletResponse> ATTACHMENT_KEY = AttachmentKey.create(ServletResponse.class);
    private final HttpServerExchange exchange;
    private volatile ServletContextImpl servletContext;
    private ServletOutputStreamImpl servletOutputStream;
    private ResponseState responseState = ResponseState.NONE;
    private PrintWriter writer;
    private Integer bufferSize;
    private Long contentLength;
    private boolean insideInclude = false;
    private boolean charsetSet = false;
    private String contentType;
    private String charset;
    private Locale locale;
    private boolean responseDone = false;

    public HttpServletResponseImpl(HttpServerExchange exchange, ServletContextImpl servletContext) {
        this.exchange = exchange;
        this.servletContext = servletContext;
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    @Override
    public void addCookie(javax.servlet.http.Cookie cookie) {
        if (this.insideInclude) {
            return;
        }
        AttachmentList<Cookie> cookies = this.exchange.getAttachment(Cookie.RESPONSE_COOKIES);
        cookies.add(new ServletCookieAdaptor(cookie));
    }

    @Override
    public boolean containsHeader(String name) {
        return this.exchange.getResponseHeaders().contains(new HttpString(name));
    }

    @Override
    public String encodeURL(String url) {
        return url;
    }

    @Override
    public String encodeRedirectURL(String url) {
        return url;
    }

    @Override
    public String encodeUrl(String url) {
        return url;
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return url;
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        if (this.exchange.isResponseStarted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        this.resetBuffer();
        this.writer = null;
        this.responseState = ResponseState.NONE;
        this.exchange.setResponseCode(sc);
        String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(sc);
        if (location != null) {
            RequestDispatcherImpl requestDispatcher = new RequestDispatcherImpl(location, this.servletContext);
            try {
                requestDispatcher.error(this.exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY), this.exchange.getAttachment(ATTACHMENT_KEY), this.exchange.getAttachment(ServletAttachments.CURRENT_SERVLET).getManagedServlet().getServletInfo().getName(), msg);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        } else if (msg != null) {
            this.setContentType("text/html");
            this.getWriter().write(msg);
            this.getWriter().close();
        }
        this.responseDone();
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        String realPath;
        if (this.exchange.isResponseStarted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        this.resetBuffer();
        this.setStatus(302);
        if (location.startsWith("/")) {
            realPath = location;
        } else {
            String current = this.exchange.getRelativePath();
            int lastSlash = current.lastIndexOf("/");
            if (lastSlash != -1) {
                current = current.substring(0, lastSlash + 1);
            }
            realPath = this.servletContext.getContextPath() + CanonicalPathUtils.canonicalize(current + location);
        }
        String host = this.exchange.getRequestHeaders().getFirst(Headers.HOST);
        if (host == null) {
            host = this.exchange.getDestinationAddress().getAddress().getHostAddress();
        }
        String loc = this.exchange.getRequestScheme() + "://" + host + realPath;
        this.exchange.getResponseHeaders().put(Headers.LOCATION, loc);
        this.responseDone();
    }

    @Override
    public void setDateHeader(String name, long date) {
        this.setHeader(name, DateUtils.toDateString(new Date(date)));
    }

    @Override
    public void addDateHeader(String name, long date) {
        this.addHeader(name, DateUtils.toDateString(new Date(date)));
    }

    @Override
    public void setHeader(String name, String value) {
        this.setHeader(new HttpString(name), value);
    }

    public void setHeader(HttpString name, String value) {
        if (this.insideInclude) {
            return;
        }
        this.exchange.getResponseHeaders().put(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.addHeader(new HttpString(name), value);
    }

    public void addHeader(HttpString name, String value) {
        if (this.insideInclude) {
            return;
        }
        this.exchange.getResponseHeaders().add(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    @Override
    public void setStatus(int sc) {
        if (this.insideInclude) {
            return;
        }
        this.exchange.setResponseCode(sc);
    }

    @Override
    public void setStatus(int sc, String sm) {
        if (this.insideInclude) {
            return;
        }
        this.setStatus(sc);
    }

    @Override
    public int getStatus() {
        return this.exchange.getResponseCode();
    }

    @Override
    public String getHeader(String name) {
        return this.exchange.getResponseHeaders().getFirst(new HttpString(name));
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return new ArrayList<String>(this.exchange.getResponseHeaders().get(new HttpString(name)));
    }

    @Override
    public Collection<String> getHeaderNames() {
        HashSet<String> headers = new HashSet<String>();
        for (HttpString i : this.exchange.getResponseHeaders()) {
            headers.add(i.toString());
        }
        return headers;
    }

    @Override
    public String getCharacterEncoding() {
        if (this.charset == null) {
            return "ISO-8859-1";
        }
        return this.charset;
    }

    @Override
    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType + ";charset=" + this.getCharacterEncoding();
        }
        return null;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.responseState == ResponseState.WRITER) {
            throw UndertowServletMessages.MESSAGES.getWriterAlreadyCalled();
        }
        this.responseState = ResponseState.STREAM;
        this.createOutputStream();
        return this.servletOutputStream;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (this.responseState == ResponseState.STREAM) {
                throw UndertowServletMessages.MESSAGES.getOutputStreamAlreadyCalled();
            }
            this.responseState = ResponseState.WRITER;
            this.createOutputStream();
            ServletPrintWriter servletPrintWriter = new ServletPrintWriter(this.servletOutputStream, this.getCharacterEncoding());
            this.writer = ServletPrintWriterDelegate.newInstance(servletPrintWriter);
        }
        return this.writer;
    }

    private void createOutputStream() {
        if (this.servletOutputStream == null) {
            this.servletOutputStream = this.bufferSize == null ? new ServletOutputStreamImpl(this.contentLength, this) : new ServletOutputStreamImpl(this.contentLength, this, this.bufferSize);
        }
    }

    @Override
    public void setCharacterEncoding(String charset) {
        if (this.insideInclude || this.exchange.isResponseStarted() || this.writer != null || this.isCommitted()) {
            return;
        }
        this.charsetSet = true;
        this.charset = charset;
        if (this.contentType != null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
        }
    }

    @Override
    public void setContentLength(int len) {
        if (this.insideInclude || this.exchange.isResponseStarted()) {
            return;
        }
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + len);
        this.contentLength = len;
    }

    @Override
    public void setContentLengthLong(long len) {
        if (this.insideInclude || this.exchange.isResponseStarted()) {
            return;
        }
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + len);
        this.contentLength = len;
    }

    @Override
    public void setContentType(String type) {
        if (this.insideInclude || this.exchange.isResponseStarted()) {
            return;
        }
        this.contentType = type;
        int split = type.indexOf(";");
        if (split != -1) {
            this.contentType = this.contentType.substring(0, split);
            int pos = type.indexOf("charset=");
            if (pos != -1) {
                char c;
                int i = pos + "charset=".length();
                while ((c = type.charAt(i++)) != ' ' && c != '\t' && c != ';' && i < type.length()) {
                }
                if (this.writer == null && !this.isCommitted()) {
                    this.charsetSet = true;
                    this.charset = type.substring(pos + "charset=".length(), i);
                }
            }
        }
        this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
    }

    @Override
    public void setBufferSize(int size) {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.setBufferSize(size);
        }
        this.bufferSize = size;
    }

    @Override
    public int getBufferSize() {
        if (this.bufferSize == null) {
            return this.exchange.getConnection().getBufferSize();
        }
        return this.bufferSize;
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        } else {
            this.createOutputStream();
            this.servletOutputStream.flush();
        }
    }

    public void closeStreamAndWriter() throws IOException {
        if (this.writer != null) {
            if (!this.servletOutputStream.isClosed()) {
                this.writer.flush();
            }
            this.writer.close();
        } else if (this.servletOutputStream == null) {
            this.createOutputStream();
        }
        this.servletOutputStream.close();
    }

    @Override
    public void resetBuffer() {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.resetBuffer();
        }
        if (this.writer != null) {
            this.writer = new PrintWriter(this.servletOutputStream, false);
        }
    }

    @Override
    public boolean isCommitted() {
        return this.exchange.isResponseStarted();
    }

    @Override
    public void reset() {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.resetBuffer();
        }
        this.writer = null;
        this.responseState = ResponseState.NONE;
        this.exchange.getResponseHeaders().clear();
        this.exchange.setResponseCode(200);
    }

    @Override
    public void setLocale(Locale loc) {
        if (this.insideInclude || this.exchange.isResponseStarted()) {
            return;
        }
        this.locale = loc;
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LANGUAGE, loc.getLanguage() + "-" + loc.getCountry());
        if (!this.charsetSet && this.writer == null) {
            Map<String, String> localeCharsetMapping = this.servletContext.getDeployment().getDeploymentInfo().getLocaleCharsetMapping();
            String charset = localeCharsetMapping.get(this.locale.toString());
            if (charset == null && (charset = localeCharsetMapping.get(this.locale.getLanguage() + "_" + this.locale.getCountry())) == null) {
                charset = localeCharsetMapping.get(this.locale.getLanguage());
            }
            if (charset != null) {
                this.charset = charset;
                if (this.contentType != null) {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.getContentType());
                }
            }
        }
    }

    @Override
    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public void responseDone() {
        if (this.responseDone) {
            return;
        }
        this.servletContext.updateSessionAccessTime(this.exchange);
        this.responseDone = true;
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.servletOutputStream != null) {
            try {
                this.servletOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.exchange.endExchange();
        }
    }

    public boolean isInsideInclude() {
        return this.insideInclude;
    }

    public void setInsideInclude(boolean insideInclude) {
        this.insideInclude = insideInclude;
    }

    public void setServletContext(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    public static HttpServletResponseImpl getResponseImpl(ServletResponse response) {
        HttpServletResponseImpl requestImpl;
        if (response instanceof HttpServletResponseImpl) {
            requestImpl = (HttpServletResponseImpl)response;
        } else if (response instanceof ServletResponseWrapper) {
            requestImpl = HttpServletResponseImpl.getResponseImpl(((ServletResponseWrapper)response).getResponse());
        } else {
            throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
        }
        return requestImpl;
    }

    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    public static enum ResponseState {
        NONE,
        STREAM,
        WRITER;

    }
}

