/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.channels.DelegatingStreamSinkChannel;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;

final class AsyncSendTimeoutStreamSinkChannel
extends DelegatingStreamSinkChannel<AsyncSendTimeoutStreamSinkChannel> {
    private final XnioExecutor.Key key;

    public AsyncSendTimeoutStreamSinkChannel(final WebSocketChannel wsChannel, StreamSinkChannel channel, int asyncSendTimeout) {
        super(channel);
        this.key = asyncSendTimeout > 0 ? channel.getWriteThread().executeAfter(new Runnable(){

            @Override
            public void run() {
                IoUtils.safeClose((Closeable)wsChannel);
            }
        }, asyncSendTimeout, TimeUnit.MILLISECONDS) : null;
    }

    @Override
    public void close() throws IOException {
        if (this.key != null) {
            this.key.remove();
        }
        super.close();
    }
}

