/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

public final class ByteString
implements Comparable<ByteString>,
Serializable {
    private static final long serialVersionUID = -5998895518404718196L;
    private final byte[] bytes;
    private final int offs;
    private final int len;
    private final transient int hashCode;
    private static final Field hashCodeField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field f = null;
            for (Field field : ByteString.class.getDeclaredFields()) {
                if (!field.getName().equals("hashCode")) continue;
                f = field;
                break;
            }
            if (f == null) {
                throw new NoSuchFieldError("No hashCode field");
            }
            f.setAccessible(true);
            return f;
        }
    });

    private ByteString(byte[] bytes, int offs, int len) {
        this.bytes = bytes;
        this.offs = offs;
        this.len = len;
        if (offs + len > bytes.length || offs < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.hashCode = ByteString.calcHashCode(bytes, offs, len);
    }

    private static int calcHashCode(byte[] bytes, int offs, int len) {
        int hashCode = 1;
        int end = offs + len;
        for (int i = offs; i < end; ++i) {
            hashCode = 31 * hashCode + bytes[i];
        }
        return hashCode;
    }

    private ByteString(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public static ByteString of(byte ... bytes) {
        return new ByteString((byte[])bytes.clone());
    }

    public static ByteString copyOf(byte[] b, int offs, int len) {
        return new ByteString(Arrays.copyOfRange(b, offs, offs + len));
    }

    public static ByteString getBytes(String str, String charset) throws UnsupportedEncodingException {
        return new ByteString(str.getBytes(charset));
    }

    public static ByteString getBytes(String str, Charset charset) {
        return new ByteString(str.getBytes(charset));
    }

    public static ByteString getBytes(ByteBuffer buffer) {
        return ByteString.getBytes(buffer, buffer.remaining());
    }

    public static ByteString getBytes(ByteBuffer buffer, int length) {
        byte[] b = new byte[length];
        buffer.get(b);
        return new ByteString(b);
    }

    public byte[] getBytes() {
        return Arrays.copyOfRange(this.bytes, this.offs, this.len);
    }

    public void getBytes(byte[] dest) {
        this.getBytes(dest, 0, dest.length);
    }

    public void getBytes(byte[] dest, int offs) {
        this.getBytes(dest, offs, dest.length - offs);
    }

    public void getBytes(byte[] dest, int offs, int len) {
        System.arraycopy(this.bytes, this.offs, dest, offs, Math.min(this.len, len));
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        return new String(this.bytes, this.offs, this.len, charset);
    }

    public int length() {
        return this.len;
    }

    public ByteString substring(int offs) {
        return this.substring(offs, this.len - offs);
    }

    public ByteString substring(int offs, int len) {
        if (this.len - offs < len) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteString(this.bytes, this.offs + offs, len);
    }

    @Override
    public int compareTo(ByteString o) {
        if (this == o) {
            return 0;
        }
        int len = this.len;
        int olen = o.len;
        int offs = this.offs;
        int ooffs = o.offs;
        byte[] b = this.bytes;
        byte[] ob = o.bytes;
        int clen = Math.min(len, olen);
        for (int i = 0; i < clen; ++i) {
            int d = b[offs + i] - ob[ooffs + i];
            if (d == 0) continue;
            return Integer.signum(d);
        }
        return Integer.signum(len - olen);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            hashCodeField.set(this, ByteString.calcHashCode(this.bytes, this.offs, this.len));
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    private static boolean equals(byte[] a, int aoff, byte[] b, int boff, int len) {
        for (int i = 0; i < len; ++i) {
            if (a[i + aoff] == b[i + boff]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof ByteString && this.equals((ByteString)obj);
    }

    public boolean equals(ByteString other) {
        int len = this.len;
        return this == other || len == other.len && this.hashCode == other.hashCode && ByteString.equals(this.bytes, this.offs, other.bytes, other.offs, len);
    }
}

