/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.ReadListenerSettable;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class EmptyStreamSourceChannel
implements StreamSourceChannel,
ReadListenerSettable<EmptyStreamSourceChannel>,
CloseListenerSettable<EmptyStreamSourceChannel> {
    private final XnioIoThread thread;
    private final Runnable readRunnable = new Runnable(){

        @Override
        public void run() {
            ChannelListener listener = EmptyStreamSourceChannel.this.readListener;
            if (listener == null) {
                EmptyStreamSourceChannel.this.suspendReads();
                return;
            }
            ChannelListeners.invokeChannelListener(EmptyStreamSourceChannel.this, listener);
            int oldVal = EmptyStreamSourceChannel.this.state;
            if (Bits.allAreSet(oldVal, 4) && Bits.allAreClear(oldVal, 3)) {
                EmptyStreamSourceChannel.this.thread.execute(this);
            }
        }
    };
    private volatile int state;
    private ChannelListener<? super EmptyStreamSourceChannel> readListener;
    private ChannelListener<? super EmptyStreamSourceChannel> closeListener;
    private static final int CLOSED = 1;
    private static final int EMPTIED = 2;
    private static final int RESUMED = 4;
    private static final AtomicIntegerFieldUpdater<EmptyStreamSourceChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(EmptyStreamSourceChannel.class, "state");

    public EmptyStreamSourceChannel(XnioIoThread thread) {
        this.thread = thread;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return 0L;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        this.emptied();
        return -1L;
    }

    @Override
    public void setReadListener(ChannelListener<? super EmptyStreamSourceChannel> readListener) {
        this.readListener = readListener;
    }

    @Override
    public ChannelListener<? super EmptyStreamSourceChannel> getReadListener() {
        return this.readListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super EmptyStreamSourceChannel> closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public ChannelListener<? super EmptyStreamSourceChannel> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<? extends EmptyStreamSourceChannel> getReadSetter() {
        return new ReadListenerSettable.Setter<EmptyStreamSourceChannel>(this);
    }

    public ChannelListener.Setter<? extends EmptyStreamSourceChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<EmptyStreamSourceChannel>(this);
    }

    private void emptied() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet(oldVal = this.state, 2)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 2));
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.emptied();
        return -1L;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        this.emptied();
        return -1L;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.emptied();
        return -1;
    }

    @Override
    public void suspendReads() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreClear(oldVal = this.state, 4)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & 0xFFFFFFFB));
    }

    @Override
    public void resumeReads() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 5)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = 4));
        if (Bits.allAreClear(oldVal, 2)) {
            this.thread.execute(this.readRunnable);
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.allAreSet(this.state, 4);
    }

    @Override
    public void wakeupReads() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 1)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = 4));
        this.thread.execute(this.readRunnable);
    }

    @Override
    public void shutdownReads() throws IOException {
        int oldVal = stateUpdater.getAndSet(this, 3);
        if (Bits.allAreClear(oldVal, 1)) {
            this.thread.execute(ChannelListeners.getChannelListenerTask(this, this.closeListener));
        }
    }

    @Override
    public void awaitReadable() throws IOException {
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.thread;
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.thread;
    }

    @Override
    public XnioWorker getWorker() {
        return this.thread.getWorker();
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 1);
    }

    @Override
    public void close() throws IOException {
        int oldVal = stateUpdater.getAndSet(this, 3);
        if (Bits.allAreClear(oldVal, 1)) {
            this.thread.execute(ChannelListeners.getChannelListenerTask(this, this.closeListener));
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }
}

