/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.SSLContext;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.ssl.JsseAcceptingSslStreamChannel;
import org.xnio.ssl.JsseAcceptingSslStreamConnection;
import org.xnio.ssl.JsseConnectedSslStreamChannel;
import org.xnio.ssl.JsseSslUtils;
import org.xnio.ssl.SslConnectionWrapper;
import org.xnio.ssl.XnioSsl;

public final class JsseXnioSsl
extends XnioSsl {
    private final Pool<ByteBuffer> socketBufferPool;
    private final Pool<ByteBuffer> applicationBufferPool;
    private final SSLContext sslContext;

    public JsseXnioSsl(Xnio xnio, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        this(xnio, optionMap, JsseSslUtils.createSSLContext(optionMap));
    }

    public JsseXnioSsl(Xnio xnio, OptionMap optionMap, SSLContext sslContext) {
        super(xnio, sslContext, optionMap);
        int appBufSize = optionMap.get(Options.SSL_APPLICATION_BUFFER_SIZE, 17000);
        int pktBufSize = optionMap.get(Options.SSL_PACKET_BUFFER_SIZE, 17000);
        int appBufRegionSize = optionMap.get(Options.SSL_APPLICATION_BUFFER_REGION_SIZE, appBufSize * 16);
        int pktBufRegionSize = optionMap.get(Options.SSL_PACKET_BUFFER_REGION_SIZE, pktBufSize * 16);
        this.socketBufferPool = new ByteBufferSlicePool(optionMap.get(Options.USE_DIRECT_BUFFERS, false) ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, pktBufSize, pktBufRegionSize);
        this.applicationBufferPool = new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, appBufSize, appBufRegionSize);
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, final ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(IoUtils.directExecutor());
        IoFuture<ConnectedStreamChannel> connectedChannelFuture = worker.connectStream(bindAddress, destination, (ChannelListener<? super ConnectedStreamChannel>)new ChannelListener<ConnectedStreamChannel>(){

            @Override
            public void handleEvent(ConnectedStreamChannel tcpChannel) {
                ConnectedSslStreamChannel channel = JsseXnioSsl.this.createSslConnectedStreamChannel(JsseXnioSsl.this.sslContext, tcpChannel, optionMap);
                if (!futureResult.setResult(channel)) {
                    IoUtils.safeClose((Closeable)channel);
                } else {
                    ChannelListeners.invokeChannelListener(channel, openListener);
                }
            }
        }, bindListener, optionMap).addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, FutureResult<ConnectedSslStreamChannel>>(){

            @Override
            public void handleCancelled(FutureResult<ConnectedSslStreamChannel> result) {
                result.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<ConnectedSslStreamChannel> result) {
                result.setException(exception);
            }
        }, futureResult);
        futureResult.getIoFuture().addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, IoFuture<ConnectedStreamChannel>>(){

            @Override
            public void handleCancelled(IoFuture<ConnectedStreamChannel> result) {
                result.cancel();
            }
        }, connectedChannelFuture);
        futureResult.addCancelHandler(connectedChannelFuture);
        return futureResult.getIoFuture();
    }

    private StreamConnection createWrappedConnection(StreamConnection original, InetSocketAddress destination, OptionMap optionMap) {
        return SslConnectionWrapper.wrap(original, JsseSslUtils.createSSLEngine(this.sslContext, optionMap, destination), this.socketBufferPool, this.applicationBufferPool);
    }

    @Override
    public IoFuture<StreamConnection> openSslConnection(XnioWorker worker, InetSocketAddress bindAddress, final InetSocketAddress destination, final ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(worker);
        IoFuture<StreamConnection> connection = worker.openStreamConnection(bindAddress, destination, openListener, bindListener, optionMap);
        connection.addNotifier(new IoFuture.HandlingNotifier<StreamConnection, FutureResult<StreamConnection>>(){

            @Override
            public void handleCancelled(FutureResult<StreamConnection> attachment) {
                attachment.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<StreamConnection> attachment) {
                attachment.setException(exception);
            }
        }, futureResult);
        futureResult.addCancelHandler(connection);
        worker.openStreamConnection(bindAddress, destination, (ChannelListener<? super StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection channel) {
                StreamConnection wrappedConnection = JsseXnioSsl.this.createWrappedConnection(channel, destination, optionMap);
                if (!futureResult.setResult(wrappedConnection)) {
                    IoUtils.safeClose((Closeable)channel);
                } else {
                    ChannelListeners.invokeChannelListener(wrappedConnection, openListener);
                }
            }
        }, bindListener, optionMap);
        return futureResult.getIoFuture();
    }

    @Override
    public AcceptingChannel<ConnectedSslStreamChannel> createSslTcpServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedSslStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        JsseAcceptingSslStreamChannel server = new JsseAcceptingSslStreamChannel(this.sslContext, worker.createStreamServer(bindAddress, null, optionMap), optionMap, this.socketBufferPool, this.applicationBufferPool, optionMap.get(Options.SSL_STARTTLS, false));
        if (acceptListener != null) {
            server.getAcceptSetter().set(acceptListener);
        }
        return server;
    }

    @Override
    public AcceptingChannel<StreamConnection> createSslConnectionServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<StreamConnection>> acceptListener, OptionMap optionMap) throws IOException {
        JsseAcceptingSslStreamConnection server = new JsseAcceptingSslStreamConnection(this.sslContext, worker.createStreamConnectionServer(bindAddress, null, optionMap), optionMap, this.socketBufferPool, this.applicationBufferPool);
        if (acceptListener != null) {
            server.getAcceptSetter().set(acceptListener);
        }
        return server;
    }

    ConnectedSslStreamChannel createSslConnectedStreamChannel(SSLContext sslContext, ConnectedStreamChannel tcpChannel, OptionMap optionMap) {
        return new JsseConnectedSslStreamChannel(tcpChannel, JsseSslUtils.createSSLEngine(sslContext, optionMap, tcpChannel.getPeerAddress(InetSocketAddress.class)), this.socketBufferPool, this.applicationBufferPool, optionMap.get(Options.SSL_STARTTLS, false));
    }
}

