/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

final class SslConduitEngine {
    private static final Logger log = Logger.getLogger("org.xnio.conduits");
    private static final String FQCN = SslConduitEngine.class.getName();
    private static final int NEED_WRAP = 1;
    private static final int NEED_UNWRAP = 2;
    private final SSLEngine engine;
    private final Pooled<ByteBuffer> receiveBuffer;
    private final Pooled<ByteBuffer> sendBuffer;
    private final Pooled<ByteBuffer> readBuffer;
    private final StreamSinkConduit sinkConduit;
    private final StreamSourceConduit sourceConduit;
    private volatile short state;
    private static final AtomicIntegerFieldUpdater<SslConduitEngine> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(SslConduitEngine.class, "state");
    private long bytesConsumed = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SslConduitEngine(StreamSinkConduit sinkConduit, StreamSourceConduit sourceConduit, SSLEngine engine, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool) {
        if (engine == null) {
            throw new IllegalArgumentException("engine is null");
        }
        this.sinkConduit = sinkConduit;
        this.sourceConduit = sourceConduit;
        this.engine = engine;
        SSLSession session = engine.getSession();
        int packetBufferSize = session.getPacketBufferSize();
        boolean ok = false;
        this.receiveBuffer = socketBufferPool.allocate();
        try {
            this.receiveBuffer.getResource().flip();
            this.sendBuffer = socketBufferPool.allocate();
            try {
                if (this.receiveBuffer.getResource().capacity() < packetBufferSize || this.sendBuffer.getResource().capacity() < packetBufferSize) {
                    throw new IllegalArgumentException("Socket buffer is too small (" + this.receiveBuffer.getResource().capacity() + "). Expected capacity is " + packetBufferSize);
                }
                int applicationBufferSize = session.getApplicationBufferSize();
                this.readBuffer = applicationBufferPool.allocate();
                try {
                    if (this.readBuffer.getResource().capacity() < applicationBufferSize) {
                        throw new IllegalArgumentException("Application buffer is too small");
                    }
                    ok = true;
                }
                finally {
                    if (!ok) {
                        this.readBuffer.free();
                    }
                }
            }
            finally {
                if (!ok) {
                    this.sendBuffer.free();
                }
            }
        }
        finally {
            if (!ok) {
                this.receiveBuffer.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long resetBytesConsumed() {
        try {
            long l = this.bytesConsumed;
            return l;
        }
        finally {
            this.bytesConsumed = 0L;
        }
    }

    public ByteBuffer getWrappedBuffer() {
        return this.sendBuffer.getResource();
    }

    public boolean wrap(ByteBuffer src) throws IOException {
        return this.wrap(src, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wrap(ByteBuffer[] srcs, int offset, int length) throws IOException {
        boolean wrapAgain;
        SSLEngineResult result;
        if (length < 1) {
            return false;
        }
        ByteBuffer buffer = this.sendBuffer.getResource();
        Object object = this.getWrapLock();
        synchronized (object) {
            result = this.engineWrap(srcs, offset, length, buffer);
            wrapAgain = this.handleWrapResult(result, false);
            this.bytesConsumed += (long)result.bytesConsumed();
        }
        return wrapAgain && (this.handleHandshake(result, true) || !this.isUnwrapNeeded() && Buffers.hasRemaining(srcs, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wrap(ByteBuffer src, boolean isCloseExpected) throws IOException {
        boolean wrapAgain;
        SSLEngineResult result;
        ByteBuffer buffer = this.sendBuffer.getResource();
        Object object = this.getWrapLock();
        synchronized (object) {
            result = this.engineWrap(src, buffer);
            wrapAgain = this.handleWrapResult(result, isCloseExpected);
            this.bytesConsumed += (long)result.bytesConsumed();
        }
        return wrapAgain && (this.handleHandshake(result, true) || !this.isUnwrapNeeded() && src.hasRemaining());
    }

    private SSLEngineResult engineWrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dest) throws SSLException {
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Wrapping %s into %s", (Object)srcs, (Object)dest);
        return this.engine.wrap(srcs, offset, length, dest);
    }

    private SSLEngineResult engineWrap(ByteBuffer src, ByteBuffer dest) throws SSLException {
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Wrapping %s into %s", (Object)src, (Object)dest);
        return this.engine.wrap(src, dest);
    }

    private boolean handleWrapResult(SSLEngineResult result, boolean closeExpected) throws IOException {
        assert (Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Wrap result is %s", (Object)result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                break;
            }
            case BUFFER_OVERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                ByteBuffer buffer = this.sendBuffer.getResource();
                if (buffer.position() == 0) {
                    throw new IOException("SSLEngine required a bigger send buffer but our buffer was already big enough");
                }
                return true;
            }
            case CLOSED: {
                if (!closeExpected) {
                    throw new ClosedChannelException();
                }
            }
            case OK: {
                if (result.bytesConsumed() != 0 || result.bytesProduced() <= 0 || this.doFlush()) break;
                return false;
            }
            default: {
                throw new IllegalStateException("Unexpected wrap result status: " + (Object)((Object)result.getStatus()));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleHandshake(SSLEngineResult result, boolean write) throws IOException {
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        if (this.isWrapNeeded()) {
            Object object = this.getWrapLock();
            synchronized (object) {
                if (this.doFlush()) {
                    this.clearNeedWrap();
                }
            }
        }
        boolean newResult = false;
        block21: while (true) {
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[result.getHandshakeStatus().ordinal()]) {
                case 1: {
                    this.clearNeedUnwrap();
                    return true;
                }
                case 2: {
                    this.clearNeedUnwrap();
                    return false;
                }
                case 3: {
                    this.clearNeedUnwrap();
                    if (write) {
                        return true;
                    }
                    Object buffer = this.sendBuffer.getResource();
                    Object object = this.getWrapLock();
                    synchronized (object) {
                        if (this.doFlush()) {
                            result = this.engineWrap(Buffers.EMPTY_BYTE_BUFFER, (ByteBuffer)buffer);
                            if (!this.handleWrapResult(result, true) || !this.doFlush()) {
                                this.needWrap();
                                return false;
                            }
                            newResult = true;
                            this.clearNeedWrap();
                            continue block21;
                        }
                        assert (!this.isUnwrapNeeded());
                        this.needWrap();
                        return false;
                    }
                }
                case 4: {
                    if (!write) {
                        return newResult;
                    }
                    Object buffer = this.getWrapLock();
                    synchronized (buffer) {
                        this.doFlush();
                    }
                    buffer = this.receiveBuffer.getResource();
                    ByteBuffer unwrappedBuffer = this.readBuffer.getResource();
                    Object object = this.getUnwrapLock();
                    synchronized (object) {
                        result = this.engineUnwrap((ByteBuffer)buffer, unwrappedBuffer);
                        int unwrapResult = this.handleUnwrapResult(result);
                        if (unwrapResult >= 0) {
                            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || result.bytesConsumed() > 0) {
                                this.clearNeedUnwrap();
                                continue block21;
                            }
                            assert (!this.isWrapNeeded());
                            this.needUnwrap();
                            return false;
                        }
                        if (unwrapResult == -1 && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            this.closeOutbound();
                            this.closeInbound();
                            throw new ClosedChannelException();
                        }
                    }
                }
                continue block21;
                case 5: {
                    Runnable task;
                    while ((task = this.engine.getDelegatedTask()) != null) {
                        try {
                            task.run();
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }
                    return true;
                }
            }
            break;
        }
        throw new IOException("Unexpected handshake status: " + (Object)((Object)result.getHandshakeStatus()));
    }

    private SSLEngineResult engineUnwrap(ByteBuffer buffer, ByteBuffer unwrappedBuffer) throws IOException {
        if (!buffer.hasRemaining()) {
            buffer.compact();
            this.sourceConduit.read(buffer);
            buffer.flip();
        }
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Unwrapping %s into %s", (Object)buffer, (Object)unwrappedBuffer);
        return this.engine.unwrap(buffer, unwrappedBuffer);
    }

    public ByteBuffer getUnwrapBuffer() {
        return this.receiveBuffer.getResource();
    }

    public int unwrap(ByteBuffer dst) throws IOException {
        return (int)this.unwrap(new ByteBuffer[]{dst}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unwrap(ByteBuffer[] dsts, int offset, int length) throws IOException {
        SSLEngineResult result;
        if (dsts.length == 0 || length == 0) {
            return 0L;
        }
        ByteBuffer buffer = this.receiveBuffer.getResource();
        ByteBuffer unwrappedBuffer = this.readBuffer.getResource();
        long total = 0L;
        Object object = this.getUnwrapLock();
        synchronized (object) {
            if (unwrappedBuffer.position() > 0 && unwrappedBuffer.hasRemaining()) {
                total += (long)this.copyUnwrappedData(dsts, offset, length, unwrappedBuffer);
            }
        }
        int res = 0;
        do {
            Object object2 = this.getUnwrapLock();
            synchronized (object2) {
                if (!Buffers.hasRemaining(dsts, offset, length)) {
                    return total;
                }
                result = this.engineUnwrap(buffer, unwrappedBuffer);
                res = this.handleUnwrapResult(result);
                total += (long)this.copyUnwrappedData(dsts, offset, length, unwrappedBuffer);
            }
        } while (this.handleHandshake(result, false) || res > 0);
        if (total == 0L && res == -1) {
            return -1L;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyUnwrappedData(ByteBuffer[] dsts, int offset, int length, ByteBuffer unwrappedBuffer) {
        assert (Thread.holdsLock(this.getUnwrapLock()));
        unwrappedBuffer.flip();
        try {
            int n = Buffers.copy(dsts, offset, length, unwrappedBuffer);
            return n;
        }
        finally {
            unwrappedBuffer.compact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleUnwrapResult(SSLEngineResult result) throws IOException {
        assert (!Thread.holdsLock(this.getWrapLock()));
        assert (Thread.holdsLock(this.getUnwrapLock()));
        log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Unwrap result is %s", (Object)result);
        switch (result.getStatus()) {
            case BUFFER_OVERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                return 0;
            }
            case BUFFER_UNDERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                ByteBuffer buffer = this.receiveBuffer.getResource();
                Object object = this.getUnwrapLock();
                synchronized (object) {
                    int n;
                    buffer.compact();
                    try {
                        n = this.sourceConduit.read(buffer);
                        buffer.flip();
                    }
                    catch (Throwable throwable) {
                        buffer.flip();
                        throw throwable;
                    }
                    return n;
                }
            }
            case CLOSED: {
                if (result.bytesConsumed() > 0) {
                    return result.bytesConsumed();
                }
                return -1;
            }
            case OK: {
                return result.bytesConsumed();
            }
        }
        throw new IOException("Unexpected unwrap result status: " + (Object)((Object)result.getStatus()));
    }

    private Object getUnwrapLock() {
        return this.receiveBuffer;
    }

    private Object getWrapLock() {
        return this.sendBuffer;
    }

    private boolean doFlush() throws IOException {
        return this.doFlush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(boolean shutdown) throws IOException {
        assert (Thread.holdsLock(this.getWrapLock()));
        assert (!Thread.holdsLock(this.getUnwrapLock()));
        if (this.sinkConduit.isWriteShutdown()) {
            return true;
        }
        ByteBuffer buffer = this.sendBuffer.getResource();
        if (!(!shutdown || this.engine.isOutboundDone() && this.engine.isInboundDone())) {
            SSLEngineResult result;
            do {
                if (this.handleWrapResult(result = this.engineWrap(Buffers.EMPTY_BYTE_BUFFER, buffer), true)) continue;
                return false;
            } while (this.handleHandshake(result, true));
            result = this.engineWrap(Buffers.EMPTY_BYTE_BUFFER, buffer);
            this.handleWrapResult(result, true);
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || !this.engine.isOutboundDone()) {
                return false;
            }
        }
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                int res = this.sinkConduit.write(buffer);
                if (res != 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            buffer.compact();
        }
        return this.sinkConduit.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOutbound() throws IOException {
        try {
            this.engine.closeOutbound();
            this.doFlush(true);
        }
        finally {
            this.sendBuffer.free();
        }
    }

    public void awaitWritable() throws IOException {
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
    }

    public boolean flush() throws IOException {
        return this.doFlush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInbound() throws IOException {
        try {
            Object object = this.getUnwrapLock();
            synchronized (object) {
                if (!this.engine.isInboundDone()) {
                    this.engine.closeInbound();
                }
            }
            this.wrap(Buffers.EMPTY_BYTE_BUFFER, true);
            this.flush();
        }
        finally {
            this.readBuffer.free();
            this.receiveBuffer.free();
        }
    }

    public void awaitReadable() throws IOException {
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
    }

    private void needWrap() {
        this.setFlags(1);
    }

    private boolean isWrapNeeded() {
        return Bits.allAreSet(this.state, 1);
    }

    private void clearNeedWrap() {
        this.clearFlags(1);
    }

    private void needUnwrap() {
        this.setFlags(2);
    }

    private boolean isUnwrapNeeded() {
        return Bits.allAreSet(this.state, 2);
    }

    private void clearNeedUnwrap() {
        this.clearFlags(2);
    }

    private int setFlags(int flags) {
        short oldState;
        do {
            if (((oldState = this.state) & flags) != flags) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState | flags));
        return oldState;
    }

    private int clearFlags(int flags) {
        short oldState;
        do {
            if (((oldState = this.state) & flags) != 0) continue;
            return oldState;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState & ~flags));
        return oldState;
    }
}

