/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.PendingHttpRequest;
import io.undertow.client.ResponseParseState;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public abstract class HttpResponseParser {
    public static final HttpResponseParser INSTANCE;
    private static final int NORMAL = 0;
    private static final int WHITESPACE = 1;
    private static final int BEGIN_LINE_END = 2;
    private static final int LINE_END = 3;
    private static final int AWAIT_DATA_END = 4;

    abstract int handleHttpVersion(ByteBuffer var1, int var2, ResponseParseState var3, PendingHttpRequest var4);

    abstract int handleHeader(ByteBuffer var1, int var2, ResponseParseState var3, PendingHttpRequest var4);

    public int handle(ByteBuffer buffer, int noBytes, ResponseParseState currentState, PendingHttpRequest builder) {
        if (currentState.state == 0 && (noBytes = this.handleHttpVersion(buffer, noBytes, currentState, builder)) == 0) {
            return 0;
        }
        if (currentState.state == 1 && (noBytes = this.handleStatusCode(buffer, noBytes, currentState, builder)) == 0) {
            return 0;
        }
        if (currentState.state == 2 && (noBytes = this.handleReasonPhrase(buffer, noBytes, currentState, builder)) == 0) {
            return 0;
        }
        if (currentState.state == 3 && (noBytes = this.handleAfterReasonPhrase(buffer, noBytes, currentState, builder)) == 0) {
            return 0;
        }
        while (currentState.state != 6) {
            if (currentState.state == 4 && (noBytes = this.handleHeader(buffer, noBytes, currentState, builder)) == 0) {
                return 0;
            }
            if (currentState.state != 5 || (noBytes = this.handleHeaderValue(buffer, noBytes, currentState, builder)) != 0) continue;
            return 0;
        }
        return noBytes;
    }

    final int handleStatusCode(ByteBuffer buffer, int remaining, ResponseParseState state, PendingHttpRequest builder) {
        StringBuilder stringBuilder = state.stringBuilder;
        if (stringBuilder == null) {
            state.stringBuilder = stringBuilder = new StringBuilder();
        }
        while (remaining > 0) {
            char next = (char)buffer.get();
            --remaining;
            if (next == ' ' || next == '\t') {
                builder.setStatusCode(Integer.parseInt(stringBuilder.toString()));
                state.state = 2;
                state.stringBuilder = null;
                state.parseState = 0;
                state.pos = 0;
                state.nextHeader = null;
                return remaining;
            }
            stringBuilder.append(next);
        }
        return remaining;
    }

    final int handleReasonPhrase(ByteBuffer buffer, int remaining, ResponseParseState state, PendingHttpRequest builder) {
        StringBuilder stringBuilder = state.stringBuilder;
        if (stringBuilder == null) {
            state.stringBuilder = stringBuilder = new StringBuilder();
        }
        while (remaining > 0) {
            char next = (char)buffer.get();
            --remaining;
            if (next == '\n' || next == '\r') {
                builder.setReasonPhrase(stringBuilder.toString());
                state.state = 3;
                state.stringBuilder = null;
                state.parseState = 0;
                state.leftOver = (byte)next;
                state.pos = 0;
                state.nextHeader = null;
                return remaining;
            }
            stringBuilder.append(next);
        }
        return remaining;
    }

    final int handleHeaderValue(ByteBuffer buffer, int remaining, ResponseParseState state, PendingHttpRequest builder) {
        StringBuilder stringBuilder = state.stringBuilder;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            state.parseState = 0;
        }
        int parseState = state.parseState;
        while (remaining > 0) {
            byte next = buffer.get();
            --remaining;
            switch (parseState) {
                case 0: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) {
                        parseState = 1;
                        break;
                    }
                    stringBuilder.append((char)next);
                    break;
                }
                case 1: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) break;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append((char)next);
                    parseState = 0;
                    break;
                }
                case 2: 
                case 3: {
                    if (next == 10 && parseState == 2) {
                        parseState = 3;
                        break;
                    }
                    if (next == 9 || next == 32) {
                        parseState = 1;
                        break;
                    }
                    HttpString nextStandardHeader = state.nextHeader;
                    String headerValue = stringBuilder.toString();
                    builder.getResponseHeaders().add(nextStandardHeader, headerValue);
                    state.nextHeader = null;
                    state.leftOver = next;
                    state.stringBuilder = null;
                    if (next == 13) {
                        parseState = 4;
                        break;
                    }
                    state.state = 4;
                    state.parseState = 0;
                    return remaining;
                }
                case 4: {
                    state.state = 6;
                    return remaining;
                }
            }
        }
        state.parseState = parseState;
        state.stringBuilder = stringBuilder;
        return remaining;
    }

    protected int handleAfterReasonPhrase(ByteBuffer buffer, int remaining, ResponseParseState state, PendingHttpRequest builder) {
        boolean newLine;
        boolean bl = newLine = state.leftOver == 10;
        while (remaining > 0) {
            byte next = buffer.get();
            --remaining;
            if (newLine) {
                if (next == 10) {
                    state.state = 6;
                    return remaining;
                }
                state.state = 4;
                state.leftOver = next;
                return remaining;
            }
            if (next == 10) {
                newLine = true;
                continue;
            }
            if (next == 13 || next == 32 || next == 9) continue;
            state.state = 4;
            state.leftOver = next;
            return remaining;
        }
        if (newLine) {
            state.leftOver = (byte)10;
        }
        return remaining;
    }

    protected static Map<String, HttpString> httpStrings() {
        Class[] classs;
        HashMap<String, HttpString> results = new HashMap<String, HttpString>();
        for (Class c : classs = new Class[]{Headers.class, Methods.class, Protocols.class}) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.getType().equals(HttpString.class)) continue;
                field.setAccessible(true);
                HttpString result = null;
                try {
                    result = (HttpString)field.get(null);
                    results.put(result.toString(), result);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return results;
    }

    static {
        try {
            Class<?> cls = HttpResponseParser.class.getClassLoader().loadClass(HttpResponseParser.class.getName() + "$$generated");
            INSTANCE = (HttpResponseParser)cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

