/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.SslConduitEngine;

public class SslStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final SslConduitEngine sslEngine;

    protected SslStreamSourceConduit(StreamSourceConduit next, SslConduitEngine sslEngine) {
        super(next);
        this.sslEngine = sslEngine;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        ByteBuffer unwrapBuffer = this.sslEngine.getUnwrapBuffer();
        super.read(unwrapBuffer);
        return this.sslEngine.unwrap(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        ByteBuffer unwrapBuffer = this.sslEngine.getUnwrapBuffer();
        super.read(unwrapBuffer);
        return this.sslEngine.unwrap(dsts, offs, len);
    }

    @Override
    public void terminateReads() throws IOException {
        this.sslEngine.closeInbound();
        super.terminateReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.sslEngine.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.sslEngine.awaitReadable(time, timeUnit);
    }
}

