/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.WebSocketFrameCorruptedException;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketHandshakeException;
import io.undertow.websockets.core.WebSocketMessages;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Set;

public class WebSocketMessages_$bundle
implements Serializable,
WebSocketMessages {
    private static final long serialVersionUID = 1L;
    public static final WebSocketMessages_$bundle INSTANCE = new WebSocketMessages_$bundle();
    private static final String invalidPayloadLengthForPing = "UT002019: Invalid payload for PING (payload length must be <= 125, was %s)";
    private static final String notAllPayloadDataWritten = "UT002004: Cannot call shutdownWrites, only %s of %s bytes written";
    private static final String webSocketAcceptKeyMismatch = "UT002037: Sec-WebSocket-Accept mismatch, expecting %s, received %s";
    private static final String senderCallbacksEmpty = "UT002030: Array of SenderCallbacks must be non empty";
    private static final String closedBeforeAllBytesWereRead = "UT002025: Closed before all bytes where read";
    private static final String streamIsBroken = "UT002027: Could not send data, as the underlying web socket connection has been broken";
    private static final String invalidCloseFrameStatusCode = "UT002026: Invalid close frame status code: %s";
    private static final String payloadNotSupportedInCloseFrames = "UT002018: Payload is not support in CloseFrames when using WebSocket Version 00";
    private static final String noPayloadAllowedForCloseFrames = "UT002020: Payload is not supported for Close Frames when using WebSocket 00";
    private static final String lengthBiggerThenFileChannel = "UT002028: Specified length is bigger the available size of the FileChannel";
    private static final String unsupportedOpCode = "UT002013: Cannot decode web socket frame with opcode: %s";
    private static final String unsupportedFrameType = "UT002014: WebSocketFrameType %s is not supported by this WebSocketChannel\"";
    private static final String channelClosed = "UT002002: Channel is closed";
    private static final String extensionsNotSupported = "UT002023: Extensions not supported";
    private static final String blockingOperationInIoThread = "UT002033: Blocking operation was called in IO thread";
    private static final String invalidTextFrameEncoding = "UT002003: Text frame contains non UTF-8 data";
    private static final String invalidDataFrameLength = "UT002012: Invalid data frame length (not using minimal length encoding)";
    private static final String fragmentedControlFrame = "UT002005: Fragmented control frame";
    private static final String frameNotMasked = "UT002034: Web socket frame was not masked";
    private static final String fragmentationNotSupported = "UT002021: Fragmentation not supported";
    private static final String fragmentedSenderInUse = "UT002031: Only one FragmentedSender can be used at the same time";
    private static final String noWebSocketConnectionHeader = "UT002036: The response did not contain a 'Connection: upgrade' header";
    private static final String continuationFrameOutsideFragmented = "UT002010: Received continuation data frame outside fragmented message";
    private static final String fragmentedSenderCompleteAlready = "UT002029: FragmentedSender was complete already";
    private static final String controlFrameWithPayloadLen1 = "UT002008: Received close control frame with payload len 1";
    private static final String nonContinuationFrameInsideFragmented = "UT002011: Received non-continuation data frame while inside fragmented message";
    private static final String toBigControlFrame = "UT002006: Control frame with payload length > 125 octets";
    private static final String noLengthEncodedInFrame = "UT002017: No Length encoded in the frame";
    private static final String unsupportedProtocol = "UT002016: Could not find supported protocol in request list %s. Supported protocols are %s";
    private static final String writeInProgress = "UT002022: Can only be changed before the write is in progress";
    private static final String reservedOpCodeInControlFrame = "UT002007: Control frame using reserved opcode = %s";
    private static final String reservedOpCodeInDataFrame = "UT002009: Data frame using reserved opcode = %s";
    private static final String noWebSocketUpgradeHeader = "UT002035: The response did not contain an 'Upgrade: websocket' header";
    private static final String extensionsNotAllowed = "UT002015: Extensions not allowed but received rsv of %s";
    private static final String missingHeader = "UT002001: Not a WebSocket handshake request: missing %s in the headers";
    private static final String negativePayloadLength = "UT002024: The payload length must be >= 0";
    private static final String closeFrameSentBefore = "UT002032: Close frame was send before";

    protected WebSocketMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final IllegalArgumentException invalidPayloadLengthForPing(long payloadLength) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidPayloadLengthForPing$str(), payloadLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPayloadLengthForPing$str() {
        return invalidPayloadLengthForPing;
    }

    @Override
    public final IOException notAllPayloadDataWritten(long written, long payloadSize) {
        IOException result = new IOException(String.format(this.notAllPayloadDataWritten$str(), written, payloadSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAllPayloadDataWritten$str() {
        return notAllPayloadDataWritten;
    }

    @Override
    public final IOException webSocketAcceptKeyMismatch(String dKey, String acceptKey) {
        IOException result = new IOException(String.format(this.webSocketAcceptKeyMismatch$str(), dKey, acceptKey));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String webSocketAcceptKeyMismatch$str() {
        return webSocketAcceptKeyMismatch;
    }

    @Override
    public final IllegalArgumentException senderCallbacksEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.senderCallbacksEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String senderCallbacksEmpty$str() {
        return senderCallbacksEmpty;
    }

    @Override
    public final IOException closedBeforeAllBytesWereRead() {
        IOException result = new IOException(String.format(this.closedBeforeAllBytesWereRead$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closedBeforeAllBytesWereRead$str() {
        return closedBeforeAllBytesWereRead;
    }

    @Override
    public final IOException streamIsBroken() {
        IOException result = new IOException(String.format(this.streamIsBroken$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String streamIsBroken$str() {
        return streamIsBroken;
    }

    @Override
    public final IOException invalidCloseFrameStatusCode(int statusCode) {
        IOException result = new IOException(String.format(this.invalidCloseFrameStatusCode$str(), statusCode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCloseFrameStatusCode$str() {
        return invalidCloseFrameStatusCode;
    }

    @Override
    public final IllegalArgumentException payloadNotSupportedInCloseFrames() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.payloadNotSupportedInCloseFrames$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String payloadNotSupportedInCloseFrames$str() {
        return payloadNotSupportedInCloseFrames;
    }

    @Override
    public final IOException noPayloadAllowedForCloseFrames() {
        IOException result = new IOException(String.format(this.noPayloadAllowedForCloseFrames$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPayloadAllowedForCloseFrames$str() {
        return noPayloadAllowedForCloseFrames;
    }

    @Override
    public final IllegalArgumentException lengthBiggerThenFileChannel() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.lengthBiggerThenFileChannel$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String lengthBiggerThenFileChannel$str() {
        return lengthBiggerThenFileChannel;
    }

    @Override
    public final WebSocketFrameCorruptedException unsupportedOpCode(int opCode) {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.unsupportedOpCode$str(), opCode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedOpCode$str() {
        return unsupportedOpCode;
    }

    @Override
    public final IllegalArgumentException unsupportedFrameType(WebSocketFrameType type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unsupportedFrameType$str(), new Object[]{type}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFrameType$str() {
        return unsupportedFrameType;
    }

    @Override
    public final IOException channelClosed() {
        IOException result = new IOException(String.format(this.channelClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelClosed$str() {
        return channelClosed;
    }

    @Override
    public final UnsupportedOperationException extensionsNotSupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.extensionsNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extensionsNotSupported$str() {
        return extensionsNotSupported;
    }

    @Override
    public final IllegalStateException blockingOperationInIoThread() {
        IllegalStateException result = new IllegalStateException(String.format(this.blockingOperationInIoThread$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String blockingOperationInIoThread$str() {
        return blockingOperationInIoThread;
    }

    @Override
    public final UnsupportedEncodingException invalidTextFrameEncoding() {
        UnsupportedEncodingException result = new UnsupportedEncodingException(String.format(this.invalidTextFrameEncoding$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTextFrameEncoding$str() {
        return invalidTextFrameEncoding;
    }

    @Override
    public final WebSocketFrameCorruptedException invalidDataFrameLength() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.invalidDataFrameLength$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDataFrameLength$str() {
        return invalidDataFrameLength;
    }

    @Override
    public final WebSocketFrameCorruptedException fragmentedControlFrame() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.fragmentedControlFrame$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fragmentedControlFrame$str() {
        return fragmentedControlFrame;
    }

    @Override
    public final WebSocketFrameCorruptedException frameNotMasked() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.frameNotMasked$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String frameNotMasked$str() {
        return frameNotMasked;
    }

    @Override
    public final UnsupportedOperationException fragmentationNotSupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.fragmentationNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fragmentationNotSupported$str() {
        return fragmentationNotSupported;
    }

    @Override
    public final IllegalStateException fragmentedSenderInUse() {
        IllegalStateException result = new IllegalStateException(String.format(this.fragmentedSenderInUse$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fragmentedSenderInUse$str() {
        return fragmentedSenderInUse;
    }

    @Override
    public final IOException noWebSocketConnectionHeader() {
        IOException result = new IOException(String.format(this.noWebSocketConnectionHeader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noWebSocketConnectionHeader$str() {
        return noWebSocketConnectionHeader;
    }

    @Override
    public final WebSocketFrameCorruptedException continuationFrameOutsideFragmented() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.continuationFrameOutsideFragmented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String continuationFrameOutsideFragmented$str() {
        return continuationFrameOutsideFragmented;
    }

    @Override
    public final IllegalArgumentException fragmentedSenderCompleteAlready() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.fragmentedSenderCompleteAlready$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fragmentedSenderCompleteAlready$str() {
        return fragmentedSenderCompleteAlready;
    }

    @Override
    public final WebSocketFrameCorruptedException controlFrameWithPayloadLen1() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.controlFrameWithPayloadLen1$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String controlFrameWithPayloadLen1$str() {
        return controlFrameWithPayloadLen1;
    }

    @Override
    public final WebSocketFrameCorruptedException nonContinuationFrameInsideFragmented() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.nonContinuationFrameInsideFragmented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonContinuationFrameInsideFragmented$str() {
        return nonContinuationFrameInsideFragmented;
    }

    @Override
    public final WebSocketFrameCorruptedException toBigControlFrame() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.toBigControlFrame$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String toBigControlFrame$str() {
        return toBigControlFrame;
    }

    @Override
    public final WebSocketFrameCorruptedException noLengthEncodedInFrame() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.noLengthEncodedInFrame$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noLengthEncodedInFrame$str() {
        return noLengthEncodedInFrame;
    }

    public final WebSocketHandshakeException unsupportedProtocol(String requestedSubprotocols, Set subprotocols) {
        WebSocketHandshakeException result = new WebSocketHandshakeException(String.format(this.unsupportedProtocol$str(), requestedSubprotocols, subprotocols));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedProtocol$str() {
        return unsupportedProtocol;
    }

    @Override
    public final IllegalStateException writeInProgress() {
        IllegalStateException result = new IllegalStateException(String.format(this.writeInProgress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String writeInProgress$str() {
        return writeInProgress;
    }

    @Override
    public final WebSocketFrameCorruptedException reservedOpCodeInControlFrame(int opCode) {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.reservedOpCodeInControlFrame$str(), opCode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String reservedOpCodeInControlFrame$str() {
        return reservedOpCodeInControlFrame;
    }

    @Override
    public final WebSocketFrameCorruptedException reservedOpCodeInDataFrame(int opCode) {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.reservedOpCodeInDataFrame$str(), opCode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String reservedOpCodeInDataFrame$str() {
        return reservedOpCodeInDataFrame;
    }

    @Override
    public final IOException noWebSocketUpgradeHeader() {
        IOException result = new IOException(String.format(this.noWebSocketUpgradeHeader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noWebSocketUpgradeHeader$str() {
        return noWebSocketUpgradeHeader;
    }

    @Override
    public final WebSocketFrameCorruptedException extensionsNotAllowed(int rsv) {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.extensionsNotAllowed$str(), rsv));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extensionsNotAllowed$str() {
        return extensionsNotAllowed;
    }

    @Override
    public final WebSocketHandshakeException missingHeader(String header) {
        WebSocketHandshakeException result = new WebSocketHandshakeException(String.format(this.missingHeader$str(), header));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingHeader$str() {
        return missingHeader;
    }

    @Override
    public final IllegalArgumentException negativePayloadLength() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.negativePayloadLength$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String negativePayloadLength$str() {
        return negativePayloadLength;
    }

    @Override
    public final IOException closeFrameSentBefore() {
        IOException result = new IOException(String.format(this.closeFrameSentBefore$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closeFrameSentBefore$str() {
        return closeFrameSentBefore;
    }
}

