/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.AssembledFrameHandler;
import io.undertow.websockets.api.CloseReason;
import io.undertow.websockets.api.FragmentedFrameHandler;
import io.undertow.websockets.api.FrameHandler;
import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.api.WebSocketSessionIdGenerator;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.impl.DefaultWebSocketFrameHeader;
import io.undertow.websockets.impl.StreamSinkChannelUtils;
import io.undertow.websockets.impl.UuidWebSocketSessionIdGenerator;
import io.undertow.websockets.impl.WebSocketChannelSession;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public class WebSocketSessionConnectionCallback
implements WebSocketConnectionCallback {
    private final WebSocketSessionIdGenerator idGenerator;
    private final WebSocketSessionHandler sessionHandler;
    private final boolean executeInIoThread;

    public WebSocketSessionConnectionCallback(WebSocketSessionHandler sessionHandler) {
        this(new UuidWebSocketSessionIdGenerator(), sessionHandler, false);
    }

    public WebSocketSessionConnectionCallback(WebSocketSessionIdGenerator idGenerator, WebSocketSessionHandler sessionHandler) {
        this(idGenerator, sessionHandler, false);
    }

    public WebSocketSessionConnectionCallback(WebSocketSessionIdGenerator idGenerator, WebSocketSessionHandler sessionHandler, boolean executeInIoThread) {
        this.idGenerator = idGenerator;
        this.sessionHandler = sessionHandler;
        this.executeInIoThread = executeInIoThread;
    }

    @Override
    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        WebSocketChannelSession session = new WebSocketChannelSession(channel, this.idGenerator.nextId(), this.executeInIoThread);
        this.sessionHandler.onSession(session, exchange);
        channel.getReceiveSetter().set(new FrameHandlerDelegateListener(session));
        channel.resumeReceives();
    }

    private static void handleError(final WebSocketChannelSession session, final Throwable cause) {
        if (session.executeInIoThread) {
            session.getFrameHandler().onError(session, cause);
            IoUtils.safeClose((Closeable)session.getChannel());
        } else {
            session.getFrameHandlerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    session.getFrameHandler().onError(session, cause);
                    IoUtils.safeClose((Closeable)session.getChannel());
                }
            });
        }
    }

    private static long maxMessageSize(WebSocketSession session, WebSocketFrameType type) {
        switch (type) {
            case BINARY: {
                return session.getMaximumBinaryFrameSize();
            }
            case TEXT: {
                return session.getMaximumTextFrameSize();
            }
        }
        return 0L;
    }

    private static void free(Pooled<ByteBuffer> pooled, List<Pooled<ByteBuffer>> pooledList) {
        if (pooledList != null) {
            for (Pooled<ByteBuffer> p : pooledList) {
                p.free();
            }
        }
        if (pooled != null) {
            pooled.free();
        }
    }

    private final class AssembleFrameChannelListener
    extends FrameHandlerListener {
        private final Pool<ByteBuffer> pool;
        private ArrayList<Pooled<ByteBuffer>> pooledList;
        private Pooled<ByteBuffer> pooled;
        private WebSocketFrameHeader header;
        private final AssembledFrameHandler handler;
        private long size;
        private final long maxSize;
        private boolean frameInProgress;

        AssembleFrameChannelListener(WebSocketChannelSession session, AssembledFrameHandler handler, FrameHandlerDelegateListener delegateListener, StreamSourceFrameChannel source) {
            super(session, handler, delegateListener);
            this.handler = handler;
            this.pool = session.getChannel().getBufferPool();
            this.pooled = this.pool.allocate();
            this.maxSize = WebSocketSessionConnectionCallback.maxMessageSize(session, source.getType());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(StreamSourceChannel ch) {
            StreamSourceFrameChannel streamSourceFrameChannel = (StreamSourceFrameChannel)ch;
            switch (streamSourceFrameChannel.getType()) {
                case BINARY: 
                case TEXT: 
                case CONTINUATION: {
                    boolean free = true;
                    if (!this.frameInProgress) {
                        this.header = new DefaultWebSocketFrameHeader(streamSourceFrameChannel.getType(), streamSourceFrameChannel.getRsv(), true);
                        this.frameInProgress = true;
                        this.size += streamSourceFrameChannel.getPayloadSize();
                        if (this.maxSize > 0L && this.size > this.maxSize) {
                            if (WebSocketSessionConnectionCallback.this.executeInIoThread) {
                                this.session.sendClose(new CloseReason(1009, null), null);
                                return;
                            }
                            this.session.getFrameHandlerExecutor().execute(new Runnable(){

                                @Override
                                public void run() {
                                    AssembleFrameChannelListener.this.session.sendClose(new CloseReason(1009, null), null);
                                }
                            });
                            return;
                        }
                    }
                    try {
                        while (true) {
                            ByteBuffer buffer;
                            int r;
                            if ((r = streamSourceFrameChannel.read(buffer = this.pooled.getResource())) == 0) {
                                free = false;
                                streamSourceFrameChannel.resumeReads();
                                return;
                            }
                            if (r == -1) {
                                this.frameInProgress = false;
                                streamSourceFrameChannel.close();
                                ((ChannelListener.SimpleSetter)streamSourceFrameChannel.getReadSetter()).set(null);
                                buffer.flip();
                                if (this.pooledList != null) {
                                    this.pooledList.add(this.pooled);
                                }
                                if (!streamSourceFrameChannel.isFinalFragment()) {
                                    this.session.getChannel().getReceiveSetter().set(new ChannelListener<WebSocketChannel>(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void handleEvent(WebSocketChannel webSocketChannel) {
                                            boolean free = true;
                                            try {
                                                StreamSourceFrameChannel frame = webSocketChannel.receive();
                                                if (frame != null) {
                                                    ((ChannelListener.SimpleSetter)frame.getReadSetter()).set(AssembleFrameChannelListener.this);
                                                    frame.wakeupReads();
                                                } else {
                                                    webSocketChannel.resumeReceives();
                                                }
                                                free = false;
                                            }
                                            catch (IOException e) {
                                                WebSocketSessionConnectionCallback.handleError(AssembleFrameChannelListener.this.session, e);
                                            }
                                            finally {
                                                if (free) {
                                                    AssembleFrameChannelListener.this.free0();
                                                }
                                            }
                                        }
                                    });
                                    free = false;
                                    return;
                                }
                                this.session.getChannel().getReceiveSetter().set(this.delegateListener);
                                if (this.pooledList != null) {
                                    this.notifyHandler(this.session, this.handler, this.header, this.pooledList.toArray(new Pooled[0]));
                                    free = false;
                                    return;
                                }
                                this.notifyHandler(this.session, this.handler, this.header, this.pooled);
                                free = false;
                                return;
                            }
                            if (buffer.hasRemaining()) continue;
                            buffer.flip();
                            if (this.pooledList == null) {
                                this.pooledList = new ArrayList(2);
                            }
                            this.pooledList.add(this.pooled);
                            this.pooled = this.pool.allocate();
                            continue;
                            break;
                        }
                    }
                    catch (IOException e) {
                        WebSocketSessionConnectionCallback.handleError(this.session, e);
                        ((ChannelListener.SimpleSetter)streamSourceFrameChannel.getReadSetter()).set(null);
                        return;
                    }
                    finally {
                        if (free) {
                            this.free0();
                        }
                    }
                }
            }
            super.handleEvent(streamSourceFrameChannel);
        }

        private void free0() {
            WebSocketSessionConnectionCallback.free(this.pooled, this.pooledList);
            this.pooled = null;
            this.pooledList = null;
        }

        private void notifyHandler(final WebSocketChannelSession session, final AssembledFrameHandler handler, final WebSocketFrameHeader header, final Pooled<ByteBuffer> ... pooled) {
            if (session.executeInIoThread) {
                this.notifyHandler0(session, handler, header, pooled);
            } else {
                session.getFrameHandlerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        AssembleFrameChannelListener.this.notifyHandler0(session, handler, header, pooled);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void notifyHandler0(WebSocketChannelSession session, AssembledFrameHandler handler, WebSocketFrameHeader header, Pooled<ByteBuffer> ... pooled) {
            try {
                buffers = new ByteBuffer[pooled.length];
                for (i = 0; i < pooled.length; ++i) {
                    buffers[i] = pooled[i].getResource();
                }
                switch (2.$SwitchMap$io$undertow$websockets$api$WebSocketFrameHeader$FrameType[header.getType().ordinal()]) {
                    case 1: {
                        handler.onBinaryFrame(session, header, buffers);
                        ** break;
lbl10:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        handler.onTextFrame(session, header, WebSocketUtils.toUtf8String(buffers));
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            finally {
                this.free0();
            }
            session.getChannel().resumeReceives();
        }
    }

    private static class FrameHandlerListener
    implements ChannelListener<StreamSourceChannel> {
        protected final WebSocketChannelSession session;
        private final FrameHandler handler;
        private Pooled<ByteBuffer> pooled;
        private List<Pooled<ByteBuffer>> pooledList;
        protected final FrameHandlerDelegateListener delegateListener;

        FrameHandlerListener(WebSocketChannelSession session, FrameHandler handler, FrameHandlerDelegateListener delegateListener) {
            this.session = session;
            this.handler = handler;
            this.delegateListener = delegateListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(StreamSourceChannel streamSourceChannel) {
            StreamSourceFrameChannel streamSourceFrameChannel = (StreamSourceFrameChannel)streamSourceChannel;
            if (this.pooled == null) {
                this.pooled = this.session.getChannel().getBufferPool().allocate();
            }
            boolean free = true;
            try {
                while (true) {
                    ByteBuffer buffer;
                    int r;
                    if ((r = streamSourceChannel.read(buffer = this.pooled.getResource())) == 0) {
                        streamSourceChannel.resumeReads();
                        free = false;
                        return;
                    }
                    if (r == -1) {
                        ByteBuffer[] buffers;
                        buffer.flip();
                        streamSourceChannel.close();
                        streamSourceChannel.getReadSetter().set(null);
                        if (this.pooledList != null) {
                            this.pooledList.add(this.pooled);
                            buffers = new ByteBuffer[this.pooledList.size()];
                            for (int i = 0; i < this.pooledList.size(); ++i) {
                                buffers[i] = this.pooledList.get(i).getResource();
                            }
                        } else {
                            buffers = new ByteBuffer[]{buffer};
                        }
                        switch (streamSourceFrameChannel.getType()) {
                            case PING: {
                                final ByteBuffer[] payload = new ByteBuffer[buffers.length];
                                for (int i = 0; i < buffers.length; ++i) {
                                    ByteBuffer buf = buffers[i];
                                    payload[i] = buf.slice();
                                }
                                if (this.session.executeInIoThread) {
                                    this.handler.onPingFrame(this.session, payload);
                                    this.session.sendPong(buffers, new SendCallback(){

                                        @Override
                                        public void onCompletion() {
                                            FrameHandlerListener.this.free0();
                                        }

                                        @Override
                                        public void onError(Throwable cause) {
                                            FrameHandlerListener.this.free0();
                                        }
                                    });
                                    this.session.getChannel().resumeReceives();
                                } else {
                                    this.session.getFrameHandlerExecutor().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            FrameHandlerListener.this.handler.onPingFrame(FrameHandlerListener.this.session, payload);
                                            FrameHandlerListener.this.session.sendPong(buffers, new SendCallback(){

                                                @Override
                                                public void onCompletion() {
                                                    FrameHandlerListener.this.free0();
                                                }

                                                @Override
                                                public void onError(Throwable cause) {
                                                    FrameHandlerListener.this.free0();
                                                }
                                            });
                                            FrameHandlerListener.this.session.getChannel().resumeReceives();
                                        }
                                    });
                                }
                                free = false;
                                return;
                            }
                            case PONG: {
                                if (this.session.executeInIoThread) {
                                    this.handler.onPongFrame(this.session, buffers);
                                    this.session.getChannel().resumeReceives();
                                    return;
                                }
                                this.session.getFrameHandlerExecutor().execute(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        try {
                                            FrameHandlerListener.this.handler.onPongFrame(FrameHandlerListener.this.session, buffers);
                                            FrameHandlerListener.this.session.getChannel().resumeReceives();
                                        }
                                        finally {
                                            FrameHandlerListener.this.free0();
                                        }
                                    }
                                });
                                free = false;
                                return;
                            }
                            case CLOSE: {
                                CloseReason reason;
                                this.delegateListener.closeFrameReceived = true;
                                if (buffers[0].hasRemaining()) {
                                    short code = buffers[0].getShort();
                                    String text = StreamSinkChannelUtils.payloadLength(buffers) > 0L ? WebSocketUtils.toUtf8String(buffers) : null;
                                    reason = new CloseReason(code, text);
                                } else {
                                    reason = null;
                                }
                                if (this.session.executeInIoThread) {
                                    this.handler.onCloseFrame(this.session, reason);
                                    this.session.sendClose(reason, null);
                                    this.session.getChannel().resumeReceives();
                                    return;
                                }
                                this.session.getFrameHandlerExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        FrameHandlerListener.this.handler.onCloseFrame(FrameHandlerListener.this.session, reason);
                                        FrameHandlerListener.this.session.sendClose(reason, null);
                                        FrameHandlerListener.this.session.getChannel().resumeReceives();
                                    }
                                });
                                return;
                            }
                        }
                        return;
                    }
                    if (buffer.hasRemaining()) continue;
                    buffer.flip();
                    if (this.pooledList == null) {
                        this.pooledList = new ArrayList<Pooled<ByteBuffer>>(2);
                    }
                    this.pooledList.add(this.pooled);
                    this.pooled = this.session.getChannel().getBufferPool().allocate();
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                WebSocketSessionConnectionCallback.handleError(this.session, e);
                streamSourceChannel.getReadSetter().set(null);
                return;
            }
            finally {
                if (free) {
                    this.free0();
                }
            }
        }

        private void free0() {
            WebSocketSessionConnectionCallback.free(this.pooled, this.pooledList);
            this.pooled = null;
            this.pooledList = null;
        }
    }

    private static class EchoFrameHandlerListener
    implements ChannelListener<StreamSourceChannel> {
        protected final WebSocketChannelSession session;
        private final FrameHandlerDelegateListener delegateListener;

        EchoFrameHandlerListener(WebSocketChannelSession session, FrameHandlerDelegateListener delegateListener) {
            this.session = session;
            this.delegateListener = delegateListener;
        }

        @Override
        public void handleEvent(StreamSourceChannel ch) {
            final StreamSourceFrameChannel streamSourceFrameChannel = (StreamSourceFrameChannel)ch;
            try {
                switch (streamSourceFrameChannel.getType()) {
                    case PING: 
                    case CLOSE: {
                        this.delegateListener.closeFrameReceived = true;
                        if (this.session.executeInIoThread) {
                            WebSocketUtils.echoFrame(this.session.getChannel(), streamSourceFrameChannel);
                            this.session.getChannel().resumeReceives();
                            break;
                        }
                        this.session.getFrameHandlerExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    WebSocketUtils.echoFrame(EchoFrameHandlerListener.this.session.getChannel(), streamSourceFrameChannel);
                                    EchoFrameHandlerListener.this.session.getChannel().resumeReceives();
                                }
                                catch (IOException e) {
                                    WebSocketSessionConnectionCallback.handleError(EchoFrameHandlerListener.this.session, e);
                                    ((ChannelListener.SimpleSetter)streamSourceFrameChannel.getReadSetter()).set(null);
                                }
                            }
                        });
                        break;
                    }
                    default: {
                        streamSourceFrameChannel.discard();
                        streamSourceFrameChannel.getCloseSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

                            @Override
                            public void handleEvent(StreamSourceChannel channel) {
                                EchoFrameHandlerListener.this.session.getChannel().resumeReceives();
                            }
                        });
                        break;
                    }
                }
            }
            catch (IOException e) {
                WebSocketSessionConnectionCallback.handleError(this.session, e);
                ((ChannelListener.SimpleSetter)streamSourceFrameChannel.getReadSetter()).set(null);
            }
        }
    }

    private static final class FragmentedFrameChannelListener
    extends FrameHandlerListener {
        private WebSocketFrameType type;
        private List<Pooled<ByteBuffer>> pooledList;
        private final FragmentedFrameHandler handler;
        private Pooled<ByteBuffer> pooled;
        private final Pool<ByteBuffer> pool;

        private FragmentedFrameChannelListener(WebSocketChannelSession session, FragmentedFrameHandler handler, FrameHandlerDelegateListener delegateListener) {
            super(session, handler, delegateListener);
            this.handler = handler;
            this.pool = session.getChannel().getBufferPool();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(StreamSourceChannel ch) {
            StreamSourceFrameChannel streamSourceFrameChannel = (StreamSourceFrameChannel)ch;
            WebSocketFrameType type = streamSourceFrameChannel.getType();
            switch (type) {
                case BINARY: 
                case TEXT: 
                case CONTINUATION: {
                    if (type == WebSocketFrameType.CONTINUATION) {
                        assert (this.type != null);
                        type = this.type;
                    }
                    this.type = type;
                    boolean free = true;
                    if (this.pooled == null) {
                        this.pooled = this.pool.allocate();
                    }
                    try {
                        while (true) {
                            ByteBuffer buffer;
                            int r;
                            if ((r = streamSourceFrameChannel.read(buffer = this.pooled.getResource())) == 0) {
                                free = false;
                                streamSourceFrameChannel.resumeReads();
                                return;
                            }
                            if (r == -1) {
                                ((ChannelListener.SimpleSetter)streamSourceFrameChannel.getReadSetter()).set(null);
                                streamSourceFrameChannel.close();
                                buffer.flip();
                                if (!streamSourceFrameChannel.isFinalFragment()) {
                                    this.session.getChannel().getReceiveSetter().set(new ChannelListener<WebSocketChannel>(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void handleEvent(WebSocketChannel webSocketChannel) {
                                            boolean free = true;
                                            try {
                                                StreamSourceFrameChannel frame = webSocketChannel.receive();
                                                if (frame != null) {
                                                    webSocketChannel.suspendReceives();
                                                    ((ChannelListener.SimpleSetter)frame.getReadSetter()).set(FragmentedFrameChannelListener.this);
                                                    frame.wakeupReads();
                                                } else {
                                                    webSocketChannel.resumeReceives();
                                                }
                                                free = false;
                                            }
                                            catch (IOException e) {
                                                WebSocketSessionConnectionCallback.handleError(FragmentedFrameChannelListener.this.session, e);
                                            }
                                            finally {
                                                if (free) {
                                                    FragmentedFrameChannelListener.this.free0();
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    this.session.getChannel().getReceiveSetter().set(this.delegateListener);
                                }
                                DefaultWebSocketFrameHeader header = new DefaultWebSocketFrameHeader(streamSourceFrameChannel.getType(), streamSourceFrameChannel.getRsv(), streamSourceFrameChannel.isFinalFragment());
                                if (this.pooledList != null) {
                                    this.pooledList.add(this.pooled);
                                    this.notifyHandler(this.session, this.handler, type, header, this.pooledList.toArray(new Pooled[0]));
                                } else {
                                    this.notifyHandler(this.session, this.handler, type, header, this.pooled);
                                }
                                free = false;
                                return;
                            }
                            if (buffer.hasRemaining()) continue;
                            buffer.flip();
                            if (this.pooledList == null) {
                                this.pooledList = new ArrayList<Pooled<ByteBuffer>>(2);
                            }
                            this.pooledList.add(this.pooled);
                            this.pooled = this.pool.allocate();
                            continue;
                            break;
                        }
                    }
                    catch (IOException e) {
                        WebSocketSessionConnectionCallback.handleError(this.session, e);
                        ((ChannelListener.SimpleSetter)streamSourceFrameChannel.getReadSetter()).set(null);
                        return;
                    }
                    finally {
                        if (free) {
                            this.free0();
                        }
                    }
                }
            }
            super.handleEvent(streamSourceFrameChannel);
        }

        private void free0() {
            WebSocketSessionConnectionCallback.free(this.pooled, this.pooledList);
            this.pooled = null;
            this.pooledList = null;
        }

        private void notifyHandler(final WebSocketChannelSession session, final FragmentedFrameHandler handler, final WebSocketFrameType type, final WebSocketFrameHeader header, final Pooled<ByteBuffer> ... pooled) {
            if (session.executeInIoThread) {
                this.notifyHandler0(session, handler, type, header, pooled);
            } else {
                session.getFrameHandlerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        FragmentedFrameChannelListener.this.notifyHandler0(session, handler, type, header, pooled);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void notifyHandler0(WebSocketChannelSession session, FragmentedFrameHandler handler, WebSocketFrameType type, WebSocketFrameHeader header, Pooled<ByteBuffer> ... pooled) {
            try {
                buffers = new ByteBuffer[pooled.length];
                for (i = 0; i < pooled.length; ++i) {
                    buffers[i] = pooled[i].getResource();
                }
                switch (2.$SwitchMap$io$undertow$websockets$core$WebSocketFrameType[type.ordinal()]) {
                    case 1: {
                        handler.onBinaryFrame(session, header, buffers);
                        ** break;
lbl10:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        handler.onTextFrame(session, header, buffers);
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            finally {
                this.free0();
            }
            session.getChannel().resumeReceives();
        }
    }

    private final class FrameHandlerDelegateListener
    implements ChannelListener<WebSocketChannel> {
        private final WebSocketChannelSession session;
        private final EchoFrameHandlerListener defaultListener;
        boolean closeFrameReceived;

        FrameHandlerDelegateListener(WebSocketChannelSession session) {
            this.session = session;
            this.defaultListener = new EchoFrameHandlerListener(session, this);
        }

        @Override
        public void handleEvent(WebSocketChannel webSocketChannel) {
            try {
                StreamSourceFrameChannel frame = webSocketChannel.receive();
                if (frame == null) {
                    webSocketChannel.resumeReceives();
                    return;
                }
                if (this.closeFrameReceived) {
                    frame.discard();
                    return;
                }
                long maxSize = WebSocketSessionConnectionCallback.maxMessageSize(this.session, frame.getType());
                if (maxSize > 0L && frame.getPayloadSize() > maxSize) {
                    if (WebSocketSessionConnectionCallback.this.executeInIoThread) {
                        this.session.sendClose(new CloseReason(1009, null), null);
                    } else {
                        this.session.getFrameHandlerExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                FrameHandlerDelegateListener.this.session.sendClose(new CloseReason(1009, null), null);
                            }
                        });
                    }
                    return;
                }
                webSocketChannel.suspendReceives();
                FrameHandler handler = this.session.getFrameHandler();
                ChannelListener<StreamSourceChannel> listener = handler == null ? this.defaultListener : (handler instanceof AssembledFrameHandler ? new AssembleFrameChannelListener(this.session, (AssembledFrameHandler)handler, this, frame) : (handler instanceof FragmentedFrameHandler ? new FragmentedFrameChannelListener(this.session, (FragmentedFrameHandler)handler, this) : new FrameHandlerListener(this.session, handler, this)));
                ((ChannelListener.SimpleSetter)frame.getReadSetter()).set(listener);
                frame.wakeupReads();
            }
            catch (IOException e) {
                WebSocketSessionConnectionCallback.handleError(this.session, e);
            }
        }
    }
}

