/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.BrokenStreamSourceConduit;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.FinishableStreamSinkConduit;
import io.undertow.conduits.FixedLengthStreamSinkConduit;
import io.undertow.conduits.FixedLengthStreamSourceConduit;
import io.undertow.conduits.PipelingBufferingStreamSinkConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpResponseConduit;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import org.jboss.logging.Logger;
import org.xnio.XnioExecutor;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.EmptyStreamSourceConduit;
import org.xnio.conduits.StreamSinkChannelWrappingConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class HttpTransferEncoding {
    private static final Logger log = Logger.getLogger("io.undertow.server.handler.transfer-encoding");
    private static final ConduitWrapper<StreamSourceConduit> CHUNKED_STREAM_SOURCE_CONDUIT_WRAPPER = new ConduitWrapper<StreamSourceConduit>(){

        @Override
        public StreamSourceConduit wrap(ConduitFactory<StreamSourceConduit> factory, HttpServerExchange exchange) {
            return new ChunkedStreamSourceConduit(factory.create(), exchange, (ConduitListener<? super ChunkedStreamSourceConduit>)HttpTransferEncoding.chunkedDrainListener(exchange), HttpTransferEncoding.maxEntitySize(exchange));
        }
    };
    private static final ConduitWrapper<StreamSourceConduit> EMPTY_STREAM_SOURCE_CONDUIT_WRAPPER = new ConduitWrapper<StreamSourceConduit>(){

        @Override
        public StreamSourceConduit wrap(ConduitFactory<StreamSourceConduit> factory, HttpServerExchange exchange) {
            StreamSourceConduit channel = factory.create();
            return new EmptyStreamSourceConduit(channel.getReadThread());
        }
    };

    private HttpTransferEncoding() {
    }

    public static void handleRequest(HttpServerExchange exchange, HttpHandler next) {
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        String connectionHeader = requestHeaders.getFirst(Headers.CONNECTION);
        String transferEncodingHeader = requestHeaders.getLast(Headers.TRANSFER_ENCODING);
        String contentLengthHeader = requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        HttpServerConnection connection = exchange.getConnection();
        PipelingBufferingStreamSinkConduit pipeliningBuffer = connection.getAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY);
        if (pipeliningBuffer != null) {
            exchange.addResponseWrapper(pipeliningBuffer.getChannelWrapper());
        }
        exchange.addRequestWrapper(ReadDataStreamSourceConduit.WRAPPER);
        boolean persistentConnection = HttpTransferEncoding.persistentConnection(exchange, connectionHeader);
        if (exchange.getRequestMethod().equals(Methods.GET)) {
            if (persistentConnection && connection.getExtraBytes() != null && pipeliningBuffer == null && connection.getUndertowOptions().get(UndertowOptions.BUFFER_PIPELINED_DATA, false)) {
                pipeliningBuffer = new PipelingBufferingStreamSinkConduit(new StreamSinkChannelWrappingConduit(connection.getChannel().getSinkChannel()), connection.getBufferPool());
                connection.putAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY, pipeliningBuffer);
                exchange.addResponseWrapper(pipeliningBuffer.getChannelWrapper());
            }
            exchange.terminateRequest();
            exchange.addRequestWrapper(EMPTY_STREAM_SOURCE_CONDUIT_WRAPPER);
        } else {
            persistentConnection = HttpTransferEncoding.handleRequestEncoding(exchange, transferEncodingHeader, contentLengthHeader, connection, pipeliningBuffer, persistentConnection);
        }
        exchange.setPersistent(persistentConnection);
        exchange.addResponseWrapper(HttpResponseConduit.WRAPPER);
        exchange.addResponseWrapper(HttpTransferEncoding.responseWrapper(persistentConnection));
        HttpHandlers.executeRootHandler(next, exchange, Thread.currentThread() instanceof XnioExecutor);
    }

    private static boolean handleRequestEncoding(HttpServerExchange exchange, String transferEncodingHeader, String contentLengthHeader, HttpServerConnection connection, PipelingBufferingStreamSinkConduit pipeliningBuffer, boolean persistentConnection) {
        HttpString transferEncoding = Headers.IDENTITY;
        if (transferEncodingHeader != null) {
            transferEncoding = new HttpString(transferEncodingHeader);
        }
        if (transferEncodingHeader != null && !transferEncoding.equals(Headers.IDENTITY)) {
            exchange.addRequestWrapper(CHUNKED_STREAM_SOURCE_CONDUIT_WRAPPER);
        } else if (contentLengthHeader != null) {
            long contentLength = Long.parseLong(contentLengthHeader);
            if (contentLength == 0L) {
                log.trace("No content, starting next request");
                exchange.addRequestWrapper(EMPTY_STREAM_SOURCE_CONDUIT_WRAPPER);
                exchange.terminateRequest();
            } else {
                exchange.addRequestWrapper(HttpTransferEncoding.fixedLengthStreamSourceConduitWrapper(contentLength));
            }
        } else if (transferEncodingHeader != null) {
            if (transferEncoding.equals(Headers.IDENTITY)) {
                log.trace("Connection not persistent (no content length and identity transfer encoding)");
                persistentConnection = false;
            }
        } else if (persistentConnection) {
            if (connection.getExtraBytes() != null && pipeliningBuffer == null && connection.getUndertowOptions().get(UndertowOptions.BUFFER_PIPELINED_DATA, false)) {
                pipeliningBuffer = new PipelingBufferingStreamSinkConduit(new StreamSinkChannelWrappingConduit(connection.getChannel().getSinkChannel()), connection.getBufferPool());
                connection.putAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY, pipeliningBuffer);
                exchange.addResponseWrapper(pipeliningBuffer.getChannelWrapper());
            }
            exchange.terminateRequest();
            exchange.addRequestWrapper(EMPTY_STREAM_SOURCE_CONDUIT_WRAPPER);
        } else if (exchange.isHttp11()) {
            exchange.terminateRequest();
            exchange.addRequestWrapper(EMPTY_STREAM_SOURCE_CONDUIT_WRAPPER);
        }
        return persistentConnection;
    }

    private static boolean persistentConnection(HttpServerExchange exchange, String connectionHeader) {
        if (exchange.isHttp11()) {
            return connectionHeader == null || !new HttpString(connectionHeader).equals(Headers.CLOSE);
        }
        if (exchange.isHttp10() && connectionHeader != null && Headers.KEEP_ALIVE.equals(new HttpString(connectionHeader))) {
            return true;
        }
        log.trace("Connection not persistent");
        return false;
    }

    private static ConduitWrapper<StreamSinkConduit> responseWrapper(final boolean requestLooksPersistent) {
        return new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                AbstractStreamSinkConduit wrappedConduit;
                StreamSinkConduit channel = factory.create();
                HeaderMap responseHeaders = exchange.getResponseHeaders();
                boolean stillPersistent = requestLooksPersistent;
                HttpString transferEncoding = Headers.IDENTITY;
                String transferEncodingHeader = responseHeaders.getLast(Headers.TRANSFER_ENCODING);
                String contentLengthHeader = responseHeaders.getFirst(Headers.CONTENT_LENGTH);
                if (transferEncodingHeader != null) {
                    if (exchange.isHttp11()) {
                        transferEncoding = new HttpString(transferEncodingHeader);
                    } else {
                        responseHeaders.remove(Headers.TRANSFER_ENCODING);
                    }
                } else if (exchange.isHttp11() && contentLengthHeader == null) {
                    responseHeaders.put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
                    transferEncoding = Headers.CHUNKED;
                }
                int code = exchange.getResponseCode();
                if (exchange.getRequestMethod().equals(Methods.HEAD) || 100 <= code && code <= 199 || code == 204 || code == 304) {
                    ConduitListener finishListener;
                    ConduitListener conduitListener = finishListener = stillPersistent ? HttpTransferEncoding.terminateResponseListener(exchange) : null;
                    if (code == 101 && contentLengthHeader != null) {
                        try {
                            long contentLength = Long.parseLong(contentLengthHeader);
                            wrappedConduit = new FixedLengthStreamSinkConduit(channel, contentLength, true, !stillPersistent, finishListener);
                        }
                        catch (NumberFormatException e) {
                            stillPersistent = false;
                            wrappedConduit = new FinishableStreamSinkConduit(channel, HttpTransferEncoding.terminateResponseListener(exchange));
                        }
                    } else {
                        wrappedConduit = new FixedLengthStreamSinkConduit(channel, 0L, true, !stillPersistent, finishListener);
                    }
                } else if (!transferEncoding.equals(Headers.IDENTITY)) {
                    ConduitListener finishListener = stillPersistent ? HttpTransferEncoding.terminateResponseListener(exchange) : null;
                    wrappedConduit = new ChunkedStreamSinkConduit(channel, true, !stillPersistent, finishListener);
                } else if (contentLengthHeader != null) {
                    try {
                        long contentLength = Long.parseLong(contentLengthHeader);
                        ConduitListener finishListener = stillPersistent ? HttpTransferEncoding.terminateResponseListener(exchange) : null;
                        wrappedConduit = new FixedLengthStreamSinkConduit(channel, contentLength, true, !stillPersistent, finishListener);
                    }
                    catch (NumberFormatException e) {
                        stillPersistent = false;
                        wrappedConduit = new FinishableStreamSinkConduit(channel, HttpTransferEncoding.terminateResponseListener(exchange));
                    }
                } else {
                    log.trace("Cancelling persistence because response is identity with no content length");
                    stillPersistent = false;
                    wrappedConduit = new FinishableStreamSinkConduit(channel, HttpTransferEncoding.terminateResponseListener(exchange));
                }
                if (code != 101) {
                    if (exchange.isHttp11()) {
                        if (stillPersistent) {
                            responseHeaders.put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
                        } else {
                            responseHeaders.put(Headers.CONNECTION, Headers.CLOSE.toString());
                        }
                    } else if (exchange.isHttp10()) {
                        if (stillPersistent) {
                            responseHeaders.put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
                        } else {
                            responseHeaders.remove(Headers.CONNECTION);
                        }
                    }
                }
                return wrappedConduit;
            }
        };
    }

    private static ConduitWrapper<StreamSourceConduit> fixedLengthStreamSourceConduitWrapper(final long contentLength) {
        return new ConduitWrapper<StreamSourceConduit>(){

            @Override
            public StreamSourceConduit wrap(ConduitFactory<StreamSourceConduit> factory, HttpServerExchange exchange) {
                StreamSourceConduit channel = factory.create();
                long max = HttpTransferEncoding.maxEntitySize(exchange);
                if (max > 0L && contentLength > max) {
                    return new BrokenStreamSourceConduit(channel, UndertowMessages.MESSAGES.requestEntityWasTooLarge(exchange.getSourceAddress(), max));
                }
                return new FixedLengthStreamSourceConduit(channel, contentLength, HttpTransferEncoding.fixedLengthDrainListener(exchange));
            }
        };
    }

    private static ConduitListener<FixedLengthStreamSourceConduit> fixedLengthDrainListener(final HttpServerExchange exchange) {
        return new ConduitListener<FixedLengthStreamSourceConduit>(){

            @Override
            public void handleEvent(FixedLengthStreamSourceConduit fixedLengthConduit) {
                long remaining = fixedLengthConduit.getRemaining();
                if (remaining > 0L) {
                    UndertowLogger.REQUEST_LOGGER.requestWasNotFullyConsumed();
                    exchange.setPersistent(false);
                }
                exchange.terminateRequest();
            }
        };
    }

    private static ConduitListener<ChunkedStreamSourceConduit> chunkedDrainListener(final HttpServerExchange exchange) {
        return new ConduitListener<ChunkedStreamSourceConduit>(){

            @Override
            public void handleEvent(ChunkedStreamSourceConduit chunkedStreamSourceConduit) {
                if (!chunkedStreamSourceConduit.isFinished()) {
                    UndertowLogger.REQUEST_LOGGER.requestWasNotFullyConsumed();
                    exchange.setPersistent(false);
                }
                exchange.terminateRequest();
            }
        };
    }

    private static ConduitListener<StreamSinkConduit> terminateResponseListener(final HttpServerExchange exchange) {
        return new ConduitListener<StreamSinkConduit>(){

            @Override
            public void handleEvent(StreamSinkConduit channel) {
                exchange.terminateResponse();
            }
        };
    }

    private static long maxEntitySize(HttpServerExchange exchange) {
        return exchange.getAttachment(UndertowOptions.ATTACHMENT_KEY).get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
    }
}

