/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpContinue;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.io.IOException;

public class HttpContinueHandler
implements HttpHandler {
    private volatile HttpHandler next;

    public HttpContinueHandler(HttpHandler next) {
        this.next = next;
    }

    public HttpContinueHandler() {
        this(ResponseCodeHandler.HANDLE_404);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (HttpContinue.requiresContinueResponse(exchange)) {
            if (this.acceptRequest(exchange)) {
                HttpContinue.sendContinueResponse(exchange, new IoCallback(){

                    @Override
                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        exchange.dispatch(HttpContinueHandler.this.next);
                    }

                    @Override
                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        UndertowLogger.REQUEST_LOGGER.debugf("IOException writing HTTP/1.1 100 Continue response", new Object[0]);
                        exchange.endExchange();
                    }
                });
            } else {
                HttpContinue.rejectExchange(exchange);
            }
        } else {
            HttpHandlers.executeHandler(this.next, exchange);
        }
    }

    protected boolean acceptRequest(HttpServerExchange exchange) {
        return true;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public HttpContinueHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

