/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

public class ServletHandler
implements HttpHandler {
    private final ManagedServlet managedServlet;
    private final boolean asyncSupported;
    private static final AtomicLongFieldUpdater<ServletHandler> unavailableUntilUpdater = AtomicLongFieldUpdater.newUpdater(ServletHandler.class, "unavailableUntil");
    private volatile long unavailableUntil = 0L;

    public ServletHandler(ManagedServlet managedServlet) {
        this.managedServlet = managedServlet;
        this.asyncSupported = managedServlet.getServletInfo().isAsyncSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(HttpServerExchange exchange) throws IOException, ServletException {
        if (this.managedServlet.isPermanentlyUnavailable()) {
            UndertowServletLogger.REQUEST_LOGGER.debugf("Returning 404 for servlet %s due to permanent unavailability", (Object)this.managedServlet.getServletInfo().getName());
            exchange.setResponseCode(404);
            return;
        }
        long until = this.unavailableUntil;
        if (until != 0L) {
            UndertowServletLogger.REQUEST_LOGGER.debugf("Returning 503 for servlet %s due to temporary unavailability", (Object)this.managedServlet.getServletInfo().getName());
            if (System.currentTimeMillis() < until) {
                exchange.setResponseCode(503);
                return;
            }
            unavailableUntilUpdater.compareAndSet(this, until, 0L);
        }
        if (!this.asyncSupported) {
            exchange.putAttachment(AsyncContextImpl.ASYNC_SUPPORTED, false);
        }
        ServletRequest request = exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY);
        ServletResponse response = exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
        InstanceHandle<? extends Servlet> servlet = null;
        try {
            servlet = this.managedServlet.getServlet();
            servlet.getInstance().service(request, response);
        }
        catch (UnavailableException e) {
            if (e.isPermanent()) {
                UndertowServletLogger.REQUEST_LOGGER.stoppingServletDueToPermanentUnavailability(this.managedServlet.getServletInfo().getName(), e);
                this.managedServlet.stop();
                this.managedServlet.setPermanentlyUnavailable(true);
                exchange.setResponseCode(404);
            } else {
                unavailableUntilUpdater.set(this, System.currentTimeMillis() + (long)(e.getUnavailableSeconds() * 1000));
                UndertowServletLogger.REQUEST_LOGGER.stoppingServletUntilDueToTemporaryUnavailability(this.managedServlet.getServletInfo().getName(), new Date(until), e);
                exchange.setResponseCode(503);
            }
        }
        finally {
            if (servlet != null) {
                servlet.release();
            }
        }
    }

    public ManagedServlet getManagedServlet() {
        return this.managedServlet;
    }
}

