/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.util.IteratorEnumeration;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionImpl
implements HttpSession {
    private final Session session;
    private final ServletContext servletContext;
    private final ApplicationListeners applicationListeners;
    private final HttpServerExchange exchange;
    private final boolean newSession;
    private volatile boolean invalid;

    public HttpSessionImpl(Session session, ServletContext servletContext, ApplicationListeners applicationListeners, HttpServerExchange exchange, boolean newSession) {
        this.session = session;
        this.servletContext = servletContext;
        this.applicationListeners = applicationListeners;
        this.exchange = exchange;
        this.newSession = newSession;
    }

    @Override
    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    @Override
    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    @Override
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.session.getAttributeNames().iterator());
    }

    @Override
    public String[] getValueNames() {
        Set<String> names = this.session.getAttributeNames();
        String[] ret = new String[names.size()];
        int i = 0;
        for (String name : names) {
            ret[i++] = name;
        }
        return ret;
    }

    @Override
    public void setAttribute(String name, Object value) {
        Object old = this.session.setAttribute(name, value);
        if (value == null && old != null) {
            this.applicationListeners.httpSessionAttributeRemoved(this, name, old);
        } else if (old == null) {
            this.applicationListeners.httpSessionAttributeAdded(this, name, value);
        } else {
            if (old instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent(this, name, old));
            }
            this.applicationListeners.httpSessionAttributeReplaced(this, name, old);
        }
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(this, name, value));
        }
    }

    @Override
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        Object old = this.session.removeAttribute(name);
        this.applicationListeners.httpSessionAttributeRemoved(this, name, old);
        if (old instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent(this, name, old));
        }
    }

    @Override
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    @Override
    public void invalidate() {
        this.invalid = true;
        this.applicationListeners.sessionDestroyed(this);
        this.session.invalidate(this.exchange);
    }

    @Override
    public boolean isNew() {
        if (this.invalid) {
            throw UndertowServletMessages.MESSAGES.sessionIsInvalid();
        }
        return this.newSession;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

