/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ParseState;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.xnio.IoUtils;

public abstract class HttpParser {
    public static final HttpParser INSTANCE;
    private static final int START = 0;
    private static final int FIRST_COLON = 1;
    private static final int FIRST_SLASH = 2;
    private static final int SECOND_SLASH = 3;
    private static final int HOST_DONE = 4;
    private static final int QUERY_PARAM_NAME = 5;
    private static final int QUERY_PARAM_VALUE = 6;
    private static final int NORMAL = 0;
    private static final int WHITESPACE = 1;
    private static final int BEGIN_LINE_END = 2;
    private static final int LINE_END = 3;
    private static final int AWAIT_DATA_END = 4;

    public void handle(ByteBuffer buffer, ParseState currentState, HttpServerExchange builder) {
        if (currentState.state == 0) {
            this.handleHttpVerb(buffer, currentState, builder);
            this.handlePath(buffer, currentState, builder);
            this.handleHttpVersion(buffer, currentState, builder);
            this.handleAfterVersion(buffer, currentState, builder);
            while (currentState.state != 6 && buffer.hasRemaining()) {
                this.handleHeader(buffer, currentState, builder);
                if (currentState.state != 5) continue;
                this.handleHeaderValue(buffer, currentState, builder);
            }
            return;
        }
        if (currentState.state == 1) {
            this.handlePath(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 2) {
            this.handleHttpVersion(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 3) {
            this.handleAfterVersion(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        while (currentState.state != 6) {
            if (currentState.state == 4) {
                this.handleHeader(buffer, currentState, builder);
                if (!buffer.hasRemaining()) {
                    return;
                }
            }
            if (currentState.state != 5) continue;
            this.handleHeaderValue(buffer, currentState, builder);
            if (buffer.hasRemaining()) continue;
            return;
        }
    }

    abstract void handleHttpVerb(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    abstract void handleHttpVersion(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    abstract void handleHeader(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    final void handlePath(ByteBuffer buffer, ParseState state, HttpServerExchange exchange) {
        StringBuilder stringBuilder = state.stringBuilder;
        int parseState = state.parseState;
        int canonicalPathStart = state.pos;
        int queryParamPos = state.queryParamPos;
        int requestEnd = state.requestEnd;
        String nextQueryParam = state.nextQueryParam;
        while (buffer.hasRemaining()) {
            String path;
            char next = (char)buffer.get();
            if (next == ' ' || next == '\t') {
                if (stringBuilder.length() == 0) continue;
                path = stringBuilder.toString();
                if (parseState < 5) {
                    exchange.setRequestURI(path);
                    if (parseState < 4) {
                        exchange.setParsedRequestPath(path);
                    } else {
                        exchange.setParsedRequestPath(path.substring(canonicalPathStart));
                    }
                    exchange.setQueryString("");
                } else {
                    exchange.setQueryString(path.substring(requestEnd));
                }
                if (parseState == 5) {
                    exchange.addQueryParam(stringBuilder.substring(queryParamPos), "");
                } else if (parseState == 6) {
                    exchange.addQueryParam(nextQueryParam, stringBuilder.substring(queryParamPos));
                }
                state.state = 2;
                state.stringBuilder.setLength(0);
                state.parseState = 0;
                state.pos = 0;
                state.nextHeader = null;
                state.queryParamPos = 0;
                state.requestEnd = 0;
                state.mapCount = 0;
                return;
            }
            if (next == '\r' || next == '\n') {
                UndertowLogger.REQUEST_LOGGER.debug("Failed to parser URI due to newline");
                IoUtils.safeClose((Closeable)exchange.getConnection());
                throw UndertowMessages.MESSAGES.failedToParsePath();
            }
            if (next == ':' && parseState == 0) {
                parseState = 1;
            } else if (next == '/' && parseState == 1) {
                parseState = 2;
            } else if (next == '/' && parseState == 2) {
                parseState = 3;
            } else if (next == '/' && parseState == 3) {
                parseState = 4;
                canonicalPathStart = stringBuilder.length();
            } else if (parseState == 1 || parseState == 2) {
                parseState = 0;
            } else if (next == '?' && (parseState == 0 || parseState == 4)) {
                path = stringBuilder.toString();
                exchange.setRequestURI(path);
                if (parseState < 4) {
                    exchange.setParsedRequestPath(path);
                } else {
                    exchange.setParsedRequestPath(path.substring(canonicalPathStart));
                }
                parseState = 5;
                requestEnd = queryParamPos = stringBuilder.length() + 1;
            } else if (next == '=' && parseState == 5) {
                parseState = 6;
                nextQueryParam = stringBuilder.substring(queryParamPos);
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '&' && parseState == 5) {
                parseState = 5;
                if (state.mapCount++ > 1000) {
                    throw UndertowMessages.MESSAGES.tooManyQueryParameters(1000);
                }
                exchange.addQueryParam(stringBuilder.substring(queryParamPos), "");
                nextQueryParam = null;
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '&' && parseState == 6) {
                parseState = 5;
                if (state.mapCount++ > 1000) {
                    throw UndertowMessages.MESSAGES.tooManyQueryParameters(1000);
                }
                exchange.addQueryParam(nextQueryParam, stringBuilder.substring(queryParamPos));
                nextQueryParam = null;
                queryParamPos = stringBuilder.length() + 1;
            }
            stringBuilder.append(next);
        }
        state.parseState = parseState;
        state.pos = canonicalPathStart;
        state.nextQueryParam = nextQueryParam;
        state.queryParamPos = queryParamPos;
        state.requestEnd = requestEnd;
    }

    final void handleHeaderValue(ByteBuffer buffer, ParseState state, HttpServerExchange builder) {
        byte next;
        StringBuilder stringBuilder = state.stringBuilder;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            state.parseState = 0;
            if (state.mapCount++ > 1000) {
                throw UndertowMessages.MESSAGES.tooManyHeaders(1000);
            }
        }
        int parseState = state.parseState;
        while (buffer.hasRemaining() && parseState == 0) {
            next = buffer.get();
            if (next == 13) {
                parseState = 2;
                continue;
            }
            if (next == 10) {
                parseState = 3;
                continue;
            }
            if (next == 32 || next == 9) {
                parseState = 1;
                continue;
            }
            stringBuilder.append((char)next);
        }
        while (buffer.hasRemaining()) {
            next = buffer.get();
            switch (parseState) {
                case 0: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) {
                        parseState = 1;
                        break;
                    }
                    stringBuilder.append((char)next);
                    break;
                }
                case 1: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) break;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append((char)next);
                    parseState = 0;
                    break;
                }
                case 2: 
                case 3: {
                    if (next == 10 && parseState == 2) {
                        parseState = 3;
                        break;
                    }
                    if (next == 9 || next == 32) {
                        parseState = 1;
                        break;
                    }
                    HttpString nextStandardHeader = state.nextHeader;
                    String headerValue = stringBuilder.toString();
                    builder.getRequestHeaders().add(nextStandardHeader, headerValue);
                    state.nextHeader = null;
                    state.leftOver = next;
                    state.stringBuilder.setLength(0);
                    if (next == 13) {
                        parseState = 4;
                        break;
                    }
                    state.state = 4;
                    state.parseState = 0;
                    return;
                }
                case 4: {
                    state.state = 6;
                    return;
                }
            }
        }
        state.parseState = parseState;
    }

    protected void handleAfterVersion(ByteBuffer buffer, ParseState state, HttpServerExchange builder) {
        boolean newLine;
        boolean bl = newLine = state.leftOver == 10;
        while (buffer.hasRemaining()) {
            byte next = buffer.get();
            if (newLine) {
                if (next == 10) {
                    state.state = 6;
                    return;
                }
                state.state = 4;
                state.leftOver = next;
                return;
            }
            if (next == 10) {
                newLine = true;
                continue;
            }
            if (next == 13 || next == 32 || next == 9) continue;
            state.state = 4;
            state.leftOver = next;
            return;
        }
        if (newLine) {
            state.leftOver = (byte)10;
        }
    }

    protected static Map<String, HttpString> httpStrings() {
        Class[] classs;
        HashMap<String, HttpString> results = new HashMap<String, HttpString>();
        for (Class c : classs = new Class[]{Headers.class, Methods.class, Protocols.class}) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.getType().equals(HttpString.class)) continue;
                field.setAccessible(true);
                HttpString result = null;
                try {
                    result = (HttpString)field.get(null);
                    results.put(result.toString(), result);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return results;
    }

    static {
        try {
            Class<?> cls = HttpParser.class.getClassLoader().loadClass(HttpParser.class.getName() + "$$generated");
            INSTANCE = (HttpParser)cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

