/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpParser;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpTransferEncoding;
import io.undertow.server.ParseState;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;

final class HttpReadListener
implements ChannelListener<StreamSourceChannel>,
ExchangeCompletionListener,
Runnable {
    private final HttpServerConnection connection;
    private final ParseState state = new ParseState();
    private HttpServerExchange httpServerExchange;
    private int read = 0;
    private final int maxRequestSize;

    HttpReadListener(HttpServerConnection connection) {
        this.connection = connection;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 51200);
    }

    public void newRequest() {
        this.state.reset();
        this.read = 0;
        this.httpServerExchange = new HttpServerExchange(this.connection);
        this.httpServerExchange.addExchangeCompleteListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(StreamSourceChannel channel) {
        Pooled<ByteBuffer> existing = this.connection.getExtraBytes();
        Pooled<ByteBuffer> pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = pooled.getResource();
        boolean free = true;
        try {
            do {
                int total;
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res == 0) {
                    if (!channel.isReadResumed()) {
                        channel.getReadSetter().set(this);
                        channel.resumeReads();
                    }
                    return;
                }
                if (res == -1) {
                    try {
                        channel.suspendReads();
                        channel.shutdownReads();
                        ConduitStreamSinkChannel responseChannel = this.connection.getChannel().getSinkChannel();
                        responseChannel.shutdownWrites();
                        if (!responseChannel.flush()) {
                            responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                            responseChannel.resumeWrites();
                        }
                    }
                    catch (IOException e) {
                        if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    return;
                }
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                HttpParser.INSTANCE.handle(buffer, this.state, this.httpServerExchange);
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes(pooled);
                    continue;
                }
                this.read = total = this.read + res;
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)this.connection);
                return;
            } while (!this.state.isComplete());
            channel.getReadSetter().set(null);
            channel.suspendReads();
            HttpServerExchange httpServerExchange = this.httpServerExchange;
            httpServerExchange.putAttachment(UndertowOptions.ATTACHMENT_KEY, this.connection.getUndertowOptions());
            try {
                httpServerExchange.setRequestScheme(this.connection.getSslSession() != null ? "https" : "http");
                this.httpServerExchange = null;
                this.httpServerExchange = null;
                HttpTransferEncoding.handleRequest(httpServerExchange, this.connection.getRootHandler());
            }
            catch (Throwable t) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t);
                IoUtils.safeClose((Closeable)channel);
                IoUtils.safeClose((Closeable)this.connection);
            }
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
            IoUtils.safeClose((Closeable)this.connection.getChannel());
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    @Override
    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
        this.connection.resetChannel();
        if (exchange.isPersistent() && !exchange.isUpgrade()) {
            this.newRequest();
            StreamConnection channel = exchange.getConnection().getChannel();
            if (exchange.getConnection().getExtraBytes() == null) {
                channel.getSourceChannel().getReadSetter().set(this);
                channel.getSourceChannel().resumeReads();
            } else {
                if (channel.getSourceChannel().isReadResumed()) {
                    channel.getSourceChannel().suspendReads();
                }
                if (exchange.isInIoThread()) {
                    channel.getIoThread().execute(this);
                } else {
                    Executor executor = exchange.getDispatchExecutor();
                    if (executor == null) {
                        executor = exchange.getConnection().getWorker();
                    }
                    executor.execute(this);
                }
            }
        }
        nextListener.proceed();
    }

    @Override
    public void run() {
        this.handleEvent(this.connection.getChannel().getSourceChannel());
    }
}

