/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletResponse;

public class ServletSecurityRoleHandler
implements HttpHandler {
    private final HttpHandler next;

    public ServletSecurityRoleHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        List<Set<String>> roles = exchange.getAttachmentList(ServletAttachments.REQUIRED_ROLES);
        SecurityContext sc = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        HttpServletRequestImpl request = HttpServletRequestImpl.getRequestImpl(exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY));
        if (request.getDispatcherType() != DispatcherType.REQUEST) {
            this.next.handleRequest(exchange);
        } else if (roles == null || roles.isEmpty()) {
            this.next.handleRequest(exchange);
        } else {
            for (Set<String> roleSet : roles) {
                boolean found = false;
                Account account = sc.getAuthenticatedAccount();
                for (String role : roleSet) {
                    if (!account.isUserInRole(role)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                HttpServletResponse response = (HttpServletResponse)exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
                response.sendError(403);
                return;
            }
            this.next.handleRequest(exchange);
        }
    }
}

