/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.io.BufferWritableOutputStream;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.xnio.IoUtils;

public class BlockingSenderImpl
implements Sender {
    private static final Charset utf8 = Charset.forName("UTF-8");
    public static final int BUFFER_SIZE = 128;
    private final HttpServerExchange exchange;
    private final OutputStream outputStream;
    private boolean inCall;
    private ByteBuffer[] next;
    private FileChannel pendingFile;
    private IoCallback queuedCallback;

    public BlockingSenderImpl(HttpServerExchange exchange, OutputStream outputStream) {
        this.exchange = exchange;
        this.outputStream = outputStream;
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        if (this.inCall) {
            this.queue(new ByteBuffer[]{buffer}, callback);
            return;
        }
        if (this.writeBuffer(buffer, callback)) {
            this.invokeOnComplete(callback);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        if (this.inCall) {
            this.queue(buffer, callback);
            return;
        }
        if (!this.writeBuffer(buffer, callback)) {
            return;
        }
        this.invokeOnComplete(callback);
    }

    @Override
    public void send(ByteBuffer buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(ByteBuffer[] buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, IoCallback callback) {
        if (this.inCall) {
            this.queue(new ByteBuffer[]{ByteBuffer.wrap(data.getBytes(utf8))}, callback);
            return;
        }
        try {
            this.outputStream.write(data.getBytes(utf8));
            this.invokeOnComplete(callback);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        if (this.inCall) {
            this.queue(new ByteBuffer[]{ByteBuffer.wrap(data.getBytes(charset))}, callback);
            return;
        }
        try {
            this.outputStream.write(data.getBytes(charset));
            this.invokeOnComplete(callback);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(String data) {
        this.send(data, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, Charset charset) {
        this.send(data, charset, IoCallback.END_EXCHANGE);
    }

    @Override
    public void transferFrom(FileChannel source, IoCallback callback) {
        if (this.inCall) {
            this.queue(source, callback);
            return;
        }
        this.performTransfer(source, callback);
        this.invokeOnComplete(callback);
    }

    private void performTransfer(FileChannel source, IoCallback callback) {
        if (this.outputStream instanceof BufferWritableOutputStream) {
            try {
                ((BufferWritableOutputStream)((Object)this.outputStream)).transferFrom(source);
            }
            catch (IOException e) {
                callback.onException(this.exchange, this, e);
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(128);
            try {
                int ret;
                long pos = source.position();
                long size = source.size();
                while (size - pos > 0L && (ret = source.read(buffer)) > 0) {
                    pos += (long)ret;
                    this.outputStream.write(buffer.array(), buffer.arrayOffset(), ret);
                    buffer.clear();
                }
                if (pos != size) {
                    throw new EOFException("Unexpected EOF reading file");
                }
            }
            catch (IOException e) {
                callback.onException(this.exchange, this, e);
            }
        }
    }

    @Override
    public void close(IoCallback callback) {
        try {
            this.outputStream.close();
            this.invokeOnComplete(callback);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void close() {
        IoUtils.safeClose((Closeable)this.outputStream);
    }

    private boolean writeBuffer(ByteBuffer buffer, IoCallback callback) {
        return this.writeBuffer(new ByteBuffer[]{buffer}, callback);
    }

    private boolean writeBuffer(ByteBuffer[] buffers, IoCallback callback) {
        if (this.outputStream instanceof BufferWritableOutputStream) {
            try {
                ((BufferWritableOutputStream)((Object)this.outputStream)).write(buffers);
                return true;
            }
            catch (IOException e) {
                callback.onException(this.exchange, this, e);
                return false;
            }
        }
        for (ByteBuffer buffer : buffers) {
            if (buffer.hasArray()) {
                try {
                    this.outputStream.write(buffer.array(), buffer.arrayOffset(), buffer.remaining());
                    continue;
                }
                catch (IOException e) {
                    callback.onException(this.exchange, this, e);
                    return false;
                }
            }
            byte[] b = new byte[128];
            while (buffer.hasRemaining()) {
                int toRead = Math.min(buffer.remaining(), 128);
                buffer.get(b, 0, toRead);
                try {
                    this.outputStream.write(b, 0, toRead);
                }
                catch (IOException e) {
                    callback.onException(this.exchange, this, e);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnComplete(IoCallback callback) {
        this.inCall = true;
        try {
            callback.onComplete(this.exchange, this);
        }
        finally {
            this.inCall = false;
        }
        while (this.next != null || this.pendingFile != null) {
            ByteBuffer[] next = this.next;
            IoCallback queuedCallback = this.queuedCallback;
            FileChannel file = this.pendingFile;
            this.next = null;
            this.queuedCallback = null;
            this.pendingFile = null;
            if (next != null) {
                for (ByteBuffer buffer : next) {
                    this.writeBuffer(buffer, queuedCallback);
                }
            } else if (file != null) {
                this.performTransfer(file, queuedCallback);
            }
            this.inCall = true;
            try {
                queuedCallback.onComplete(this.exchange, this);
            }
            finally {
                this.inCall = false;
            }
        }
    }

    private void queue(ByteBuffer[] byteBuffers, IoCallback ioCallback) {
        if (this.next != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.next = byteBuffers;
        this.queuedCallback = ioCallback;
    }

    private void queue(FileChannel source, IoCallback ioCallback) {
        if (this.pendingFile != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.pendingFile = source;
        this.queuedCallback = ioCallback;
    }
}

